/*
 * Decompiled with CFR 0.152.
 */
package cloudflow.operator.action.runner;

import akka.cloudflow.config.CloudflowConfig;
import cloudflow.operator.action.runner.ContainerConfig;
import cloudflow.operator.action.runner.PodConfig;
import cloudflow.operator.action.runner.PodsConfig;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import io.fabric8.kubernetes.api.model.KeyToPathFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try;
import scala.util.Try$;

public final class PodsConfig$
implements Serializable {
    public static final PodsConfig$ MODULE$ = new PodsConfig$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());
    private static final String CloudflowPodName = "pod";
    private static final String CloudflowContainerName = "container";

    public scala.collection.immutable.Map<String, PodConfig> $lessinit$greater$default$1() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    public Logger logger() {
        return logger;
    }

    public String CloudflowPodName() {
        return CloudflowPodName;
    }

    public String CloudflowContainerName() {
        return CloudflowContainerName;
    }

    private ContainerConfig getContainerConfig(CloudflowConfig.Container container) {
        scala.collection.immutable.Map requests;
        List env = (List)container.env().map((Function1 & Serializable)x$10 -> x$10.map((Function1 & Serializable)env -> ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(env.name())).withValue(env.value())).build())).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$));
        scala.collection.immutable.Map limits = (scala.collection.immutable.Map)Option$.MODULE$.option2Iterable(container.resources().limits().cpu().map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cpu"), (Object)Quantity.parse((String)v.value())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(container.resources().limits().memory().map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"memory"), (Object)Quantity.parse((String)v.value())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        None$ resources = limits.$plus$plus((IterableOnce)(requests = (scala.collection.immutable.Map)Option$.MODULE$.option2Iterable(container.resources().requests().cpu().map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cpu"), (Object)Quantity.parse((String)v.value())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(container.resources().requests().memory().map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"memory"), (Object)Quantity.parse((String)v.value())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())))).isEmpty() ? None$.MODULE$ : new Some((Object)((ResourceRequirementsBuilder)((ResourceRequirementsFluentImpl)new ResourceRequirementsBuilder().withLimits(CollectionConverters$.MODULE$.MapHasAsJava((Map)limits).asJava())).withRequests(CollectionConverters$.MODULE$.MapHasAsJava((Map)requests).asJava())).build());
        List volumeMounts = ((IterableOnceOps)container.volumeMounts().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            CloudflowConfig.VolumeMount vm = (CloudflowConfig.VolumeMount)tuple2._2();
            VolumeMount volumeMount = ((VolumeMountBuilder)((VolumeMountFluentImpl)((VolumeMountFluentImpl)((VolumeMountFluentImpl)new VolumeMountBuilder().withName(name)).withMountPath(vm.mountPath())).withSubPath(vm.subPath())).withReadOnly(Predef$.MODULE$.boolean2Boolean(vm.readOnly()))).build();
            return volumeMount;
        })).toList();
        List ports = (List)container.ports().map((Function1 & Serializable)x$11 -> x$11.map((Function1 & Serializable)port -> {
            ContainerPortBuilder containerPortBuilder;
            ContainerPortBuilder base = (ContainerPortBuilder)((ContainerPortFluentImpl)((ContainerPortFluentImpl)((ContainerPortFluentImpl)new ContainerPortBuilder().withName((String)port.name().map((Function1 & Serializable)x$12 -> x$12.value()).getOrElse((Function0 & Serializable)() -> null))).withContainerPort(Predef$.MODULE$.int2Integer(port.containerPort()))).withHostIP(port.hostIP())).withProtocol(port.protocol());
            Option option = port.hostPort();
            if (option instanceof Some) {
                Some some = (Some)option;
                int hp = BoxesRunTime.unboxToInt((Object)some.value());
                containerPortBuilder = (ContainerPortBuilder)base.withHostPort(Predef$.MODULE$.int2Integer(hp));
            } else {
                containerPortBuilder = base;
            }
            return containerPortBuilder.build();
        })).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$));
        return new ContainerConfig((List<EnvVar>)env, (Option<ResourceRequirements>)resources, (List<VolumeMount>)volumeMounts, (List<ContainerPort>)ports);
    }

    private PodConfig getPodConfig(CloudflowConfig.Pod pod) {
        scala.collection.immutable.Map containers = (scala.collection.immutable.Map)pod.containers().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            CloudflowConfig.Container v = (CloudflowConfig.Container)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)MODULE$.getContainerConfig(v));
            return tuple22;
        });
        scala.collection.immutable.Map labels = (scala.collection.immutable.Map)pod.labels().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CloudflowConfig.LabelKey k = (CloudflowConfig.LabelKey)tuple2._1();
            CloudflowConfig.LabelValue v = (CloudflowConfig.LabelValue)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.key()), (Object)v.value());
            return tuple22;
        });
        scala.collection.immutable.Map annotations = (scala.collection.immutable.Map)pod.annotations().map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CloudflowConfig.AnnotationKey k = (CloudflowConfig.AnnotationKey)tuple2._1();
            CloudflowConfig.AnnotationValue v = (CloudflowConfig.AnnotationValue)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.key()), (Object)v.value());
            return tuple22;
        });
        List volumes = ((IterableOnceOps)pod.volumes().map((Function1 & Serializable)x0$4 -> {
            Volume volume;
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String name = (String)tuple2._1();
            CloudflowConfig.Volume volume2 = (CloudflowConfig.Volume)tuple2._2();
            CloudflowConfig.Volume volume3 = volume2;
            if (volume3 instanceof CloudflowConfig.SecretVolume) {
                CloudflowConfig.SecretVolume secretVolume = (CloudflowConfig.SecretVolume)volume3;
                volume = ((VolumeBuilder)((VolumeFluentImpl)new VolumeBuilder().withName(name)).withSecret(((SecretVolumeSourceBuilder)new SecretVolumeSourceBuilder().withNewSecretName(secretVolume.name())).build())).build();
                return volume;
            } else if (volume3 instanceof CloudflowConfig.PvcVolume) {
                CloudflowConfig.PvcVolume pvcVolume = (CloudflowConfig.PvcVolume)volume3;
                volume = ((VolumeBuilder)((VolumeFluentImpl)new VolumeBuilder().withName(name)).withPersistentVolumeClaim(((PersistentVolumeClaimVolumeSourceBuilder)((PersistentVolumeClaimVolumeSourceFluentImpl)new PersistentVolumeClaimVolumeSourceBuilder().withClaimName(pvcVolume.name())).withReadOnly(Predef$.MODULE$.boolean2Boolean(pvcVolume.readOnly()))).build())).build();
                return volume;
            } else if (volume3 instanceof CloudflowConfig.ConfigMapVolume) {
                CloudflowConfig.ConfigMapVolume configMapVolume = (CloudflowConfig.ConfigMapVolume)volume3;
                volume = ((VolumeBuilder)((VolumeFluentImpl)new VolumeBuilder().withName(name)).withConfigMap(((ConfigMapVolumeSourceBuilder)((ConfigMapVolumeSourceFluentImpl)((ConfigMapVolumeSourceFluentImpl)new ConfigMapVolumeSourceBuilder().withName(configMapVolume.name())).withOptional(Predef$.MODULE$.boolean2Boolean(configMapVolume.optional()))).withItems(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)configMapVolume.items().map((Function1 & Serializable)x0$5 -> {
                    Tuple2 tuple2 = x0$5;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String k = (String)tuple2._1();
                    CloudflowConfig.ConfigMapVolumeKeyToPath item = (CloudflowConfig.ConfigMapVolumeKeyToPath)tuple2._2();
                    KeyToPath keyToPath = ((KeyToPathBuilder)((KeyToPathFluentImpl)new KeyToPathBuilder().withKey(k)).withPath(item.path())).build();
                    return keyToPath;
                })).toList()).asJava())).build())).build();
                return volume;
            } else {
                MODULE$.logger().error(new StringBuilder(35).append("Found unknown ").append(volume3).append(" volume type skipping").toString());
                throw new Exception(new StringBuilder(15).append("Unknown volume ").append(volume3).toString());
            }
        })).toList();
        return new PodConfig((scala.collection.immutable.Map<String, ContainerConfig>)containers, (scala.collection.immutable.Map<String, String>)labels, (scala.collection.immutable.Map<String, String>)annotations, (List<Volume>)volumes);
    }

    public Try<PodsConfig> fromKubernetes(CloudflowConfig.Kubernetes kubernetes) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> new PodsConfig((scala.collection.immutable.Map<String, PodConfig>)((scala.collection.immutable.Map)kubernetes.pods().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            CloudflowConfig.Pod v = (CloudflowConfig.Pod)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)MODULE$.getPodConfig(v));
            return tuple22;
        }))));
    }

    public PodsConfig apply(scala.collection.immutable.Map<String, PodConfig> pods) {
        return new PodsConfig(pods);
    }

    public scala.collection.immutable.Map<String, PodConfig> apply$default$1() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    public Option<scala.collection.immutable.Map<String, PodConfig>> unapply(PodsConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.pods());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PodsConfig$.class);
    }

    private PodsConfig$() {
    }
}

