/*
 * Decompiled with CFR 0.152.
 */
package cloudflow.operator.action;

import akka.datap.crd.App;
import akka.kube.actions.Action;
import akka.kube.actions.Action$;
import akka.kube.actions.CompositeAction;
import cloudflow.blueprint.deployment.RunnerConfig$;
import cloudflow.blueprint.deployment.Topic;
import cloudflow.blueprint.deployment.Topic$;
import cloudflow.operator.action.CloudflowLabels;
import cloudflow.operator.action.CloudflowLabels$;
import cloudflow.operator.action.CloudflowStatus$;
import cloudflow.operator.action.JsonConfig$;
import cloudflow.operator.action.Name$;
import cloudflow.operator.action.TopicActions;
import cloudflow.operator.action.TopicActions$KafkaAdmins$;
import cloudflow.operator.action.TopicActions$TopicInfo$;
import cloudflow.operator.action.runner.Base64Helper$;
import cloudflow.operator.action.runner.Runner;
import cloudflow.operator.event.ConfigInput$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Secret;
import java.io.Serializable;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.KafkaFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import sourcecode.File;
import sourcecode.Line;

public final class TopicActions$ {
    public static final TopicActions$ MODULE$ = new TopicActions$();
    private static final Logger cloudflow$operator$action$TopicActions$$log = LoggerFactory.getLogger(MODULE$.getClass());
    private static final String DefaultConfigurationName = "default";
    private static final String KafkaClusterNameFormat = "cloudflow-kafka-cluster-%s";
    private static final String KafkaClusterNameLabel = "cloudflow.lightbend.com/kafka-cluster-name";

    public Logger cloudflow$operator$action$TopicActions$$log() {
        return cloudflow$operator$action$TopicActions$$log;
    }

    public Topic portMappingToTopic(App.PortMapping pm) {
        return new Topic(pm.id(), pm.cluster(), JsonConfig$.MODULE$.apply(pm.config()));
    }

    public Seq<Action> apply(App.Cr newApp, scala.collection.immutable.Map<String, Runner<?>> runners, String namedClustersNamespace) {
        Set managedTopics = TopicActions$.distinctTopics$1((App.Spec)newApp.getSpec());
        CloudflowLabels labels = CloudflowLabels$.MODULE$.apply(newApp);
        Vector actions = (Vector)managedTopics.toVector().map((Function1 & Serializable)topic -> {
            Option appConfigSecretName = ((IterableOps)((App.Spec)newApp.getSpec()).deployments().filter((Function1 & Serializable)deployment -> BoxesRunTime.boxToBoolean((boolean)TopicActions$.deploymentOf$1(topic.id(), deployment)))).headOption().map((Function1 & Serializable)x$4 -> x$4.secretName());
            return MODULE$.action((Option<String>)appConfigSecretName, runners, labels, (TopicActions.TopicInfo)topic, newApp, namedClustersNamespace);
        });
        return actions;
    }

    public String DefaultConfigurationName() {
        return DefaultConfigurationName;
    }

    public String KafkaClusterNameFormat() {
        return KafkaClusterNameFormat;
    }

    public String KafkaClusterNameLabel() {
        return KafkaClusterNameLabel;
    }

    public Action action(Option<String> appConfigSecretName, scala.collection.immutable.Map<String, Runner<?>> runners, CloudflowLabels labels, TopicActions.TopicInfo topic, App.Cr newApp, String namedClustersNamespace) {
        return (Action)appConfigSecretName.map((Function1 & Serializable)name -> Action$.MODULE$.get(name, newApp.namespace(), (Function1 & Serializable)secretOption -> (Action)MODULE$.maybeCreateActionFromAppConfigSecret((Option<Secret>)secretOption, newApp, runners, labels, topic).getOrElse((Function0 & Serializable)() -> TopicActions$.useClusterConfiguration$1(topic, namedClustersNamespace, newApp, runners, labels, topic)), ClassTag$.MODULE$.apply(Secret.class), Action$.MODULE$.nsub(), new Line(123), new File("/home/runner/work/cloudflow-release/cloudflow-release/target/cloudflow/core/cloudflow-operator/src/main/scala/cloudflow/operator/action/TopicActions.scala"))).getOrElse((Function0 & Serializable)() -> TopicActions$.useClusterConfiguration$1(topic, namedClustersNamespace, newApp, runners, labels, topic));
    }

    public String getData(Secret secret) {
        return (String)Option$.MODULE$.apply(secret.getData().get(ConfigInput$.MODULE$.SecretDataKey())).map((Function1 & Serializable)base64Str -> Base64Helper$.MODULE$.decode((String)base64Str)).getOrElse((Function0 & Serializable)() -> "");
    }

    public Config getConfigFromSecret(Secret secret) {
        String str = this.getData(secret);
        return ConfigFactory.parseString((String)str);
    }

    public Action createActionFromKafkaConfigSecret(Secret secret, App.Cr newApp, scala.collection.immutable.Map<String, Runner<?>> runners, CloudflowLabels labels, TopicActions.TopicInfo topic) {
        Config config = this.getConfigFromSecret(secret);
        TopicActions.TopicInfo topicInfo = TopicActions$TopicInfo$.MODULE$.apply(new Topic(topic.id(), topic.cluster(), config));
        return this.createTopicOrError(newApp, runners, labels, topicInfo);
    }

    public Option<Action> maybeCreateActionFromAppConfigSecret(Option<Secret> secretOption, App.Cr newApp, scala.collection.immutable.Map<String, Runner<?>> runners, CloudflowLabels labels, TopicActions.TopicInfo topic) {
        return secretOption.map((Function1 & Serializable)secret -> {
            Config config = MODULE$.getConfigFromSecret((Secret)secret);
            return new Tuple2(secret, (Object)config);
        }).flatMap((Function1 & Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Config config = (Config)tuple2._2();
            Option option = MODULE$.getKafkaConfig(config, topic).map((Function1 & Serializable)kafkaConfig -> {
                String x$1 = topic.id();
                Config x$2 = kafkaConfig;
                Option x$3 = Topic$.MODULE$.apply$default$2();
                TopicActions.TopicInfo topicWithKafkaConfig = TopicActions$TopicInfo$.MODULE$.apply(new Topic(x$1, x$3, x$2));
                return new Tuple2(kafkaConfig, (Object)topicWithKafkaConfig);
            }).flatMap((Function1 & Serializable)x$6 -> {
                Tuple2 tuple2 = x$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicActions.TopicInfo topicWithKafkaConfig = (TopicActions.TopicInfo)tuple2._2();
                Option option = topicWithKafkaConfig.bootstrapServers().map((Function1 & Serializable)x$5 -> {
                    String string = x$5;
                    Action action = MODULE$.createTopicOrError(newApp, runners, labels, topicWithKafkaConfig);
                    return action;
                });
                return option;
            });
            return option;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Action createTopicOrError(App.Cr newApp, scala.collection.immutable.Map<String, Runner<?>> runners, CloudflowLabels labels, TopicActions.TopicInfo topic) {
        Tuple3 tuple3 = new Tuple3(topic.bootstrapServers(), topic.partitions(), topic.replicationFactor());
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option2 = (Option)tuple3._2();
            Option option3 = (Option)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                String bootstrapServers = (String)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    int partitions = BoxesRunTime.unboxToInt((Object)some2.value());
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        int replicas = BoxesRunTime.unboxToInt((Object)some3.value());
                        return this.createAction(topic, labels, runners, newApp, bootstrapServers, partitions, replicas);
                    }
                }
            }
        }
        String msg = new StringBuilder(177).append(new StringBuilder(63).append("Default Kafka connection configuration was invalid for topic [").append(topic.name()).append("]").toString()).append(topic.cluster().map((Function1 & Serializable)c -> new StringBuilder(12).append(", cluster [").append((String)c).append("]").toString()).getOrElse((Function0 & Serializable)() -> "")).append(". Update installation of Cloudflow with Helm charts to include a default Kafka cluster configuration that contains defaults for 'bootstrapServers', 'partitions', and 'replicas'.").toString();
        return CloudflowStatus$.MODULE$.errorAction(newApp, runners, msg);
    }

    public CompositeAction<Nothing$> createAction(TopicActions.TopicInfo topic, CloudflowLabels labels, scala.collection.immutable.Map<String, Runner<?>> runners, App.Cr newApp, String bootstrapServers, int partitions, int replicas) {
        scala.collection.immutable.Map<String, String> brokerConfig = topic.brokerConfig();
        ConfigMap configMap = this.resource(newApp.namespace(), topic, partitions, replicas, bootstrapServers, labels);
        Admin adminClient = TopicActions$KafkaAdmins$.MODULE$.getOrCreate(bootstrapServers, brokerConfig);
        return Action$.MODULE$.composite((scala.collection.immutable.Iterable)new .colon.colon((Object)Action$.MODULE$.createOrReplace((HasMetadata)configMap, ClassTag$.MODULE$.apply(ConfigMap.class), Action$.MODULE$.nsub(), new Line(231), new File("/home/runner/work/cloudflow-release/cloudflow-release/target/cloudflow/core/cloudflow-operator/src/main/scala/cloudflow/operator/action/TopicActions.scala")), (List)new .colon.colon((Object)new TopicActions.CreateTopicAction(newApp, runners, adminClient, topic, partitions, replicas, new File("/home/runner/work/cloudflow-release/cloudflow-release/target/cloudflow/core/cloudflow-operator/src/main/scala/cloudflow/operator/action/TopicActions.scala"), new Line(232)), (List)Nil$.MODULE$)));
    }

    public ConfigMap resource(String namespace, TopicActions.TopicInfo topic, int partitions, int replicationFactor, String bootstrapServers, CloudflowLabels labels) {
        return ((ConfigMapBuilder)((ConfigMapFluentImpl)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(Name$.MODULE$.makeDNS1123CompatibleSubDomainName(new StringBuilder(6).append("topic-").append(topic.id()).toString())).withLabels(CollectionConverters$.MODULE$.MapHasAsJava(labels.apply(topic.id())).asJava()).withNamespace(namespace)).endMetadata()).withData(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)topic.id()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)topic.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), (Object)Integer.toString(partitions)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replicationFactor"), (Object)Integer.toString(replicationFactor)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)bootstrapServers)}))).$plus$plus(topic.properties())).asJava())).build();
    }

    private Option<Config> getKafkaConfig(Config config, TopicActions.TopicInfo topic) {
        None$ none$;
        if (config.hasPath(RunnerConfig$.MODULE$.PortMappingsPath())) {
            Config portMappingsConfig = config.getConfig(RunnerConfig$.MODULE$.PortMappingsPath());
            none$ = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(portMappingsConfig.root().entrySet()).asScala().map((Function1 & Serializable)x$11 -> (String)x$11.getKey())).find((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)TopicActions$.$anonfun$getKafkaConfig$2(portMappingsConfig, topic, key))).flatMap((Function1 & Serializable)key -> MODULE$.getConfig(portMappingsConfig, new StringBuilder(7).append((String)key).append(".config").toString()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<Config> getConfig(Config config, String key) {
        return config.hasPath(key) ? new Some((Object)config.getConfig(key)) : None$.MODULE$;
    }

    public <T> TopicActions.KafkaFutureConverter<T> KafkaFutureConverter(KafkaFuture<T> fut) {
        return new TopicActions.KafkaFutureConverter<T>(fut);
    }

    private static final Set distinctTopics$1(App.Spec app) {
        return ((IterableOnceOps)app.deployments().flatMap((Function1 & Serializable)x$1 -> (Iterable)((IterableOps)((IterableOps)x$1.portMappings().values().map((Function1 & Serializable)pm -> MODULE$.portMappingToTopic((App.PortMapping)pm))).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.managed()))).map((Function1 & Serializable)topic -> TopicActions$TopicInfo$.MODULE$.apply((Topic)topic)))).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(String topicId$1, App.PortMapping x$3) {
        String string = x$3.id();
        String string2 = topicId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final boolean deploymentOf$1(String topicId, App.Deployment deployment) {
        return deployment.portMappings().values().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TopicActions$.$anonfun$apply$5(topicId, x$3)));
    }

    private static final Action useClusterConfiguration$1(TopicActions.TopicInfo providedTopic, String namedClustersNamespace$2, App.Cr newApp$2, scala.collection.immutable.Map runners$2, CloudflowLabels labels$2, TopicActions.TopicInfo topic$2) {
        return (Action)providedTopic.cluster().map((Function1 & Serializable)cluster -> Action$.MODULE$.get(String.format(MODULE$.KafkaClusterNameFormat(), cluster), namedClustersNamespace$2, (Function1 & Serializable)res -> {
            Action action;
            Option option = res;
            if (option instanceof Some) {
                Some some = (Some)option;
                Secret secret = (Secret)some.value();
                action = MODULE$.createActionFromKafkaConfigSecret(secret, newApp$2, runners$2, labels$2, providedTopic);
            } else if (None$.MODULE$.equals(option)) {
                String msg = new StringBuilder(58).append("Could not find Kafka configuration for topic [").append(providedTopic.name()).append("] cluster [").append((String)cluster).append("]").toString();
                MODULE$.cloudflow$operator$action$TopicActions$$log().error(msg);
                action = CloudflowStatus$.MODULE$.errorAction(newApp$2, runners$2, msg);
            } else {
                throw new MatchError((Object)option);
            }
            return action;
        }, ClassTag$.MODULE$.apply(Secret.class), Action$.MODULE$.nsub(), new Line(99), new File("/home/runner/work/cloudflow-release/cloudflow-release/target/cloudflow/core/cloudflow-operator/src/main/scala/cloudflow/operator/action/TopicActions.scala"))).getOrElse((Function0 & Serializable)() -> {
            Action action;
            if (topic$2.cluster() == new Some((Object)MODULE$.DefaultConfigurationName())) {
                String msg = "A default Kafka configuration was not defined during installation of cloudflow-operator. Cannot create managed topics.";
                MODULE$.cloudflow$operator$action$TopicActions$$log().error(msg);
                action = CloudflowStatus$.MODULE$.errorAction(newApp$2, runners$2, msg);
            } else {
                Some x$1 = new Some((Object)MODULE$.DefaultConfigurationName());
                String x$2 = topic$2.copy$default$1();
                String x$3 = topic$2.copy$default$2();
                Option<Object> x$4 = topic$2.copy$default$4();
                Option<Object> x$5 = topic$2.copy$default$5();
                scala.collection.immutable.Map<String, String> x$6 = topic$2.copy$default$6();
                boolean x$7 = topic$2.copy$default$7();
                Option<String> x$8 = topic$2.copy$default$8();
                scala.collection.immutable.Map<String, String> x$9 = topic$2.copy$default$9();
                action = TopicActions$.useClusterConfiguration$1(topic$2.copy(x$2, x$3, (Option<String>)x$1, x$4, x$5, x$6, x$7, x$8, x$9), namedClustersNamespace$2, newApp$2, runners$2, labels$2, topic$2);
            }
            return action;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getKafkaConfig$2(Config portMappingsConfig$1, TopicActions.TopicInfo topic$4, String key) {
        String topicIdInConfig;
        String string = topicIdInConfig = portMappingsConfig$1.getString(new StringBuilder(3).append(key).append(".id").toString());
        String string2 = topic$4.id();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private TopicActions$() {
    }
}

