/*
 * Decompiled with CFR 0.152.
 */
package cloudflow.operator.action;

import java.io.Serializable;
import java.text.Normalizer;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Name$ {
    public static final Name$ MODULE$ = new Name$();
    private static final Function1<String, String> max15Chars = (Function1 & Serializable)s -> MODULE$.maxStringLength(15, (String)s);
    private static final String ofContainerAdminPort = (String)MODULE$.max15Chars().apply((Object)"admin");
    private static final String ofContainerPrometheusExporterPort = (String)MODULE$.max15Chars().apply((Object)"prom-metrics");
    private static final String ofPVCComponent = "cloudflow-app-pvc";

    private String maxStringLength(int maxLength, String s) {
        Predef$.MODULE$.require(s.length() <= maxLength, (Function0 & Serializable)() -> new StringBuilder(46).append("maximum size for this parameter is ").append(maxLength).append(" characters").toString());
        return s;
    }

    private Function1<String, String> max15Chars() {
        return max15Chars;
    }

    private String truncateTo63Characters(String name) {
        return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(name), 63);
    }

    private String truncateTo253Characters(String name) {
        return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(name), 253);
    }

    private String truncateTo63CharactersWithSuffix(String name, String suffix) {
        return new StringBuilder(0).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(name), 63 - suffix.length())).append(suffix).toString();
    }

    private String trim(String name, List<Object> characters) {
        return StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(name), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)characters.contains((Object)BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)x$1)))))))), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)characters.contains((Object)BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)x$2)))))));
    }

    public String makeDNS1039Compatible(String name) {
        String normalized = Normalizer.normalize(name, Normalizer.Form.NFKD).toLowerCase().replaceAll("[_.]", "-").replaceAll("[^-a-z0-9]", "");
        return this.trim(this.truncateTo63Characters(normalized), (List<Object>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'-'}))));
    }

    public String makeDNS1123CompatibleLabelName(String name) {
        String normalized = Normalizer.normalize(name, Normalizer.Form.NFKD).toLowerCase().replace('_', '-').replaceAll("[^-a-z0-9.]", "");
        return this.trim(this.truncateTo63Characters(normalized), (List<Object>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'-', '.'}))));
    }

    public String makeDNS1123CompatibleSubDomainName(String name) {
        String normalized = Normalizer.normalize(name, Normalizer.Form.NFKD).toLowerCase().replace('_', '-').replaceAll("[^-a-z0-9.]", "");
        return this.trim(this.truncateTo253Characters(normalized), (List<Object>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'-', '.'}))));
    }

    public String ofNamespace(String appId) {
        return new StringBuilder(4).append("app-").append(appId).toString();
    }

    public String ofCloudflowOperatorDeployment() {
        return "cloudflow-operator";
    }

    public String ofServiceAccount() {
        return "cloudflow-app-serviceaccount";
    }

    public String ofAkkaRoleBinding() {
        return "cloudflow-app-akka-rolebinding";
    }

    public String ofAkkaRole() {
        return "cloudflow-app-akka-role";
    }

    public String ofDockerRegistrySecret() {
        return "cloudflow-app-docker-registry";
    }

    public String ofRoleBinding() {
        return "cloudflow-app-rolebinding";
    }

    public String ofPod(String streamletDeploymentName) {
        return this.makeDNS1039Compatible(this.fixDots(streamletDeploymentName));
    }

    public String ofLabelValue(String name) {
        return this.truncateTo63Characters(name);
    }

    public String ofVolume(String name) {
        return this.truncateTo63Characters(name);
    }

    public String fixDots(String name) {
        return name.replace(".", "-");
    }

    public String ofContainerPort(int port) {
        return (String)this.max15Chars().apply((Object)new StringBuilder(7).append("c-port-").append(port).toString());
    }

    public String ofContainerAdminPort() {
        return ofContainerAdminPort;
    }

    public String ofContainerPrometheusExporterPort() {
        return ofContainerPrometheusExporterPort;
    }

    public String ofService(String streamletDeploymentName) {
        return this.truncateTo63CharactersWithSuffix(this.ofPod(streamletDeploymentName), "-service");
    }

    public String ofAdminService(String streamletDeploymentName) {
        return new StringBuilder(14).append(this.ofPod(streamletDeploymentName)).append("-admin-service").toString();
    }

    public String ofServicePort(int port) {
        return new StringBuilder(7).append("s-port-").append(port).toString();
    }

    public String ofPVCComponent() {
        return ofPVCComponent;
    }

    public String ofPVCInstance(String appId, String runtime) {
        return this.truncateTo63CharactersWithSuffix(appId, new StringBuilder(5).append("-").append(runtime).append("-pvc").toString());
    }

    private Name$() {
    }
}

