/*
 * Decompiled with CFR 0.152.
 */
package cloudflow.operator.action;

import akka.datap.crd.App;
import akka.kube.actions.Action;
import akka.kube.actions.Action$;
import cloudflow.operator.action.CloudflowLabels$;
import cloudflow.operator.action.EventActions$EventType$;
import cloudflow.operator.action.runner.Runner;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.EventFluentImpl;
import io.fabric8.kubernetes.api.model.EventSource;
import io.fabric8.kubernetes.api.model.EventSourceBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import sourcecode.File;
import sourcecode.Line;

public final class EventActions$ {
    public static final EventActions$ MODULE$ = new EventActions$();
    private static final EventSource OperatorSource = ((EventSourceBuilder)new EventSourceBuilder().withComponent("cloudflow-operator")).build();

    public EventSource OperatorSource() {
        return OperatorSource;
    }

    public Seq<Action> deployEvents(App.Cr app, Option<App.Cr> currentApp, Map<String, Runner<?>> runners, String podName, ObjectReference cause) {
        Action deployEvent;
        Option<App.Cr> option = currentApp;
        Tuple2 tuple2 = option instanceof Some ? new Tuple2((Object)"ApplicationUpdated", (Object)new StringBuilder(44).append("Updated Cloudflow Application ").append(((App.Spec)app.getSpec()).appId()).append(" to namespace ").append(app.namespace()).toString()) : new Tuple2((Object)"ApplicationDeployed", (Object)new StringBuilder(45).append("Deployed Cloudflow Application ").append(((App.Spec)app.getSpec()).appId()).append(" to namespace ").append(app.namespace()).toString());
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String reason = (String)tuple22._1();
        String message = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)reason, (Object)message);
        Tuple2 tuple24 = tuple23;
        String reason2 = (String)tuple24._1();
        String message2 = (String)tuple24._2();
        App.Cr x$1 = app;
        String x$2 = podName;
        String x$3 = reason2;
        String x$4 = message2;
        ObjectReference x$5 = cause;
        Enumeration.Value x$6 = this.createEvent$default$5();
        Option<String> x$7 = this.createEvent$default$7();
        Action action = deployEvent = this.createEvent(x$1, x$2, x$3, x$4, x$6, x$5, x$7);
        return (Seq)this.streamletScaledEvents(app, currentApp, runners, podName, cause).$plus$colon((Object)action);
    }

    private Seq<Action> streamletScaledEvents(App.Cr app, Option<App.Cr> currentAppOpt, Map<String, Runner<?>> runners, String podName, ObjectReference cause) {
        return (Seq)Option$.MODULE$.option2Iterable(currentAppOpt).toVector().flatMap((Function1 & Serializable)currentApp -> (Seq)((App.Spec)app.getSpec()).deployments().flatMap((Function1 & Serializable)streamlet -> ((App.Spec)currentApp.getSpec()).deployments().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EventActions$.$anonfun$streamletScaledEvents$3(streamlet, x$2))).withFilter((Function1 & Serializable)currentStreamlet -> BoxesRunTime.boxToBoolean((boolean)EventActions$.$anonfun$streamletScaledEvents$4(streamlet, currentStreamlet))).map((Function1 & Serializable)currentStreamlet -> {
            int replicas = MODULE$.replicasOrRunnerDefault((App.Deployment)streamlet, runners);
            int currentReplicas = MODULE$.replicasOrRunnerDefault((App.Deployment)currentStreamlet, runners);
            return new Tuple3(currentStreamlet, (Object)BoxesRunTime.boxToInteger((int)replicas), (Object)BoxesRunTime.boxToInteger((int)currentReplicas));
        }).map((Function1 & Serializable)x$3 -> {
            Tuple3 tuple3 = x$3;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int replicas = BoxesRunTime.unboxToInt((Object)tuple3._2());
            int currentReplicas = BoxesRunTime.unboxToInt((Object)tuple3._3());
            App.Cr x$1 = app;
            String x$2 = podName;
            String x$32 = "StreamletScaled";
            String x$4 = new StringBuilder(64).append("Scaled Cloudflow Application ").append(((App.Spec)app.getSpec()).appId()).append(" streamlet ").append(streamlet.name()).append(" in namespace ").append(app.namespace()).append(" from ").append(currentReplicas).append(" to ").append(replicas).toString();
            ObjectReference x$5 = cause;
            Some x$6 = new Some((Object)new StringBuilder(18).append("spec.deployments{").append(streamlet.name()).append("}").toString());
            Enumeration.Value x$7 = MODULE$.createEvent$default$5();
            Action action = MODULE$.createEvent(x$1, x$2, "StreamletScaled", x$4, x$7, x$5, (Option<String>)x$6);
            return action;
        })));
    }

    private int replicasOrRunnerDefault(App.Deployment streamlet, Map<String, Runner<?>> runners) {
        return BoxesRunTime.unboxToInt((Object)runners.get((Object)streamlet.runtime()).map((Function1 & Serializable)runner -> BoxesRunTime.boxToInteger((int)EventActions$.$anonfun$replicasOrRunnerDefault$1(streamlet, runner))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public Action undeployEvent(App.Cr app, String podName, ObjectReference cause) {
        App.Cr x$1 = app;
        String x$2 = podName;
        String x$3 = "ApplicationUndeployed";
        String x$4 = new StringBuilder(49).append("Undeployed Cloudflow Application ").append(((App.Spec)app.getSpec()).appId()).append(" from namespace ").append(app.namespace()).toString();
        ObjectReference x$5 = cause;
        Enumeration.Value x$6 = this.createEvent$default$5();
        Option<String> x$7 = this.createEvent$default$7();
        return this.createEvent(x$1, x$2, "ApplicationUndeployed", x$4, x$6, x$5, x$7);
    }

    public Action streamletChangeEvent(App.Cr app, App.Deployment streamlet, String podName, ObjectReference cause) {
        App.Cr x$1 = app;
        String x$2 = podName;
        String x$3 = "StreamletConfigurationChanged";
        String x$4 = new StringBuilder(82).append("Changed streamlet configuration of Cloudflow Application ").append(((App.Spec)app.getSpec()).appId()).append(" streamlet ").append(streamlet.name()).append(" in namespace ").append(app.namespace()).toString();
        ObjectReference x$5 = cause;
        Enumeration.Value x$6 = this.createEvent$default$5();
        Option<String> x$7 = this.createEvent$default$7();
        return this.createEvent(x$1, x$2, "StreamletConfigurationChanged", x$4, x$6, x$5, x$7);
    }

    public Action createEvent(App.Cr app, String podName, String reason, String message, Enumeration.Value type, ObjectReference objectReference, Option<String> fieldPath) {
        ZonedDateTime eventTime = ZonedDateTime.now();
        String metadataName = this.newEventName(podName, ((App.Spec)app.getSpec()).appId());
        fieldPath.foreach((Function1 & Serializable)path -> {
            objectReference.setFieldPath(path);
            return BoxedUnit.UNIT;
        });
        Event event = ((EventBuilder)((EventFluentImpl)((EventFluentImpl)((EventFluentImpl)((EventFluentImpl)((EventFluentImpl)((EventFluentImpl)((EventFluentImpl)((EventFluentImpl)((EventFluent.MetadataNested)new EventBuilder().withNewMetadata().withName(metadataName).withNamespace(app.namespace()).withLabels(CollectionConverters$.MODULE$.MapHasAsJava(CloudflowLabels$.MODULE$.apply(app).baseLabels()).asJava())).endMetadata()).withInvolvedObject(objectReference)).withReason(reason)).withMessage(message)).withType(type.toString())).withFirstTimestamp(eventTime.format(DateTimeFormatter.ISO_INSTANT))).withLastTimestamp(eventTime.format(DateTimeFormatter.ISO_INSTANT))).withCount(Predef$.MODULE$.int2Integer(1))).withSource(this.OperatorSource())).build();
        return Action$.MODULE$.createOrReplace((HasMetadata)event, ClassTag$.MODULE$.apply(Event.class), Action$.MODULE$.nsub(), new Line(132), new File("/home/runner/work/cloudflow-release/cloudflow-release/target/cloudflow/core/cloudflow-operator/src/main/scala/cloudflow/operator/action/EventActions.scala"));
    }

    public Enumeration.Value createEvent$default$5() {
        return EventActions$EventType$.MODULE$.Normal();
    }

    public Option<String> createEvent$default$7() {
        return None$.MODULE$;
    }

    private String newEventName(String sourceResource, String appId) {
        String uuid = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(UUID.randomUUID().toString()), 5);
        return new StringBuilder(2).append(sourceResource).append(".").append(appId).append(".").append(uuid).toString();
    }

    public static final /* synthetic */ boolean $anonfun$streamletScaledEvents$3(App.Deployment streamlet$1, App.Deployment x$2) {
        String string = x$2.name();
        String string2 = streamlet$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$streamletScaledEvents$4(App.Deployment streamlet$1, App.Deployment currentStreamlet) {
        Option option = currentStreamlet.replicas();
        Option option2 = streamlet$1.replicas();
        return option == null ? option2 != null : !option.equals(option2);
    }

    public static final /* synthetic */ int $anonfun$replicasOrRunnerDefault$1(App.Deployment streamlet$2, Runner runner) {
        return BoxesRunTime.unboxToInt((Object)streamlet$2.replicas().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> runner.defaultReplicas()));
    }

    private EventActions$() {
    }
}

