/*
 * Decompiled with CFR 0.152.
 */
package cloudflow.operator.action;

import akka.datap.crd.App;
import akka.datap.crd.App$;
import akka.kube.actions.Action;
import akka.kube.actions.Action$;
import akka.kube.actions.CustomResourceAdapter;
import cloudflow.operator.action.CloudflowStatus$PodStatus$;
import cloudflow.operator.action.CloudflowStatus$Status$;
import cloudflow.operator.action.runner.Runner;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.File;
import sourcecode.Line;

public final class CloudflowStatus$ {
    public static final CloudflowStatus$ MODULE$ = new CloudflowStatus$();
    private static final Logger log = LoggerFactory.getLogger(CloudflowStatus$Status$.MODULE$.getClass());
    private static final CustomResourceAdapter<App.Cr, App.List> adapter = new CustomResourceAdapter(App$.MODULE$.customResourceDefinitionContext(), ClassTag$.MODULE$.apply(App.Cr.class), ClassTag$.MODULE$.apply(App.List.class));

    private Logger log() {
        return log;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean podReady(App.PodStatus ps, Option<Object> expectedPodCount) {
        String string = ps.status();
        String string2 = CloudflowStatus$PodStatus$.MODULE$.Running();
        if (!(string != null ? !string.equals(string2) : string2 != null) && ps.nrOfContainersReady() == ps.nrOfContainers()) {
            if (ps.nrOfContainers() > 0) return true;
        }
        if (!BoxesRunTime.unboxToBoolean((Object)expectedPodCount.map((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 == 0).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) return false;
        if (ps.nrOfContainers() != 0) return false;
        if (ps.nrOfContainersReady() != 0) return false;
        return true;
    }

    private App.PodStatus podStatus(String name, String status, int restarts, int nrOfContainersReady, int nrOfContainers) {
        String ready = nrOfContainersReady == nrOfContainers && nrOfContainers > 0 ? CloudflowStatus$PodStatus$.MODULE$.ReadyTrue() : CloudflowStatus$PodStatus$.MODULE$.ReadyFalse();
        String x$1 = name;
        String x$2 = status;
        int x$3 = restarts;
        int x$4 = nrOfContainersReady;
        int x$5 = nrOfContainers;
        String x$6 = ready;
        return new App.PodStatus(x$1, x$6, x$4, x$5, x$3, x$2);
    }

    /*
     * Unable to fully structure code
     */
    public App.PodStatus fromPod(Pod pod) {
        block3: {
            block5: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                block2: {
                                    name = pod.getMetadata().getName();
                                    status = (PodStatus)Option$.MODULE$.apply((Object)pod.getStatus()).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fromPod$1(), ()Lio/fabric8/kubernetes/api/model/PodStatus;)());
                                    nrOfContainers = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$fromPod$2(io.fabric8.kubernetes.api.model.Pod io.fabric8.kubernetes.api.model.PodStatus ), ()I)((Pod)pod, (PodStatus)status)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$fromPod$5(), ()I)()));
                                    nrOfContainersReady = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$fromPod$6(io.fabric8.kubernetes.api.model.PodStatus ), ()I)((PodStatus)status)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$fromPod$8(), ()I)()));
                                    restarts = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$fromPod$9(io.fabric8.kubernetes.api.model.PodStatus ), ()I)((PodStatus)status)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$fromPod$11(), ()I)()));
                                    containerStates = (List)Try$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fromPod$12(io.fabric8.kubernetes.api.model.PodStatus ), ()Lscala/collection/immutable/List;)((PodStatus)status)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fromPod$14(), ()Lscala/collection/immutable/List;)());
                                    if (pod.getMetadata().getDeletionTimestamp() == null || !StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(pod.getMetadata().getDeletionTimestamp()))) break block2;
                                    v0 = CloudflowStatus$PodStatus$.MODULE$.Terminating();
                                    break block3;
                                }
                                var10_8 = false;
                                var11_9 = null;
                                var12_10 = Try$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fromPod$15(io.fabric8.kubernetes.api.model.PodStatus ), ()Ljava/lang/String;)((PodStatus)status)).toOption();
                                if (!(var12_10 instanceof Some)) break block4;
                                var10_8 = true;
                                var11_9 = (Some)var12_10;
                                var13_11 = (String)var11_9.value();
                                v1 = CloudflowStatus$PodStatus$.MODULE$.Pending();
                                var14_12 = var13_11;
                                if (v1 != null ? v1.equals(var14_12) == false : var14_12 != null) break block4;
                                var2_13 = this.getStatusFromContainerStates((List<ContainerState>)containerStates, nrOfContainers);
                                break block5;
                            }
                            if (!var10_8) break block6;
                            var15_14 = (String)var11_9.value();
                            v2 = CloudflowStatus$PodStatus$.MODULE$.Running();
                            var16_15 = var15_14;
                            if (v2 != null ? v2.equals(var16_15) == false : var16_15 != null) break block6;
                            var2_13 = this.getStatusFromContainerStates((List<ContainerState>)containerStates, nrOfContainers);
                            break block5;
                        }
                        if (!var10_8) break block7;
                        var17_16 = (String)var11_9.value();
                        v3 = CloudflowStatus$PodStatus$.MODULE$.Succeeded();
                        var18_17 = var17_16;
                        if (v3 != null ? v3.equals(var18_17) == false : var18_17 != null) break block7;
                        var2_13 = CloudflowStatus$PodStatus$.MODULE$.Succeeded();
                        break block5;
                    }
                    if (!var10_8) break block8;
                    var19_18 = (String)var11_9.value();
                    v4 = CloudflowStatus$PodStatus$.MODULE$.Failed();
                    var20_19 = var19_18;
                    if (v4 != null ? v4.equals(var20_19) == false : var20_19 != null) break block8;
                    var2_13 = CloudflowStatus$PodStatus$.MODULE$.Failed();
                    break block5;
                }
                if (!var10_8) ** GOTO lbl-1000
                var21_20 = (String)var11_9.value();
                v5 = CloudflowStatus$PodStatus$.MODULE$.Unknown();
                var22_21 = var21_20;
                if (!(v5 != null ? v5.equals(var22_21) == false : var22_21 != null)) {
                    var2_13 = CloudflowStatus$PodStatus$.MODULE$.Unknown();
                } else lbl-1000:
                // 2 sources

                {
                    var2_13 = this.getStatusFromContainerStates((List<ContainerState>)containerStates, nrOfContainers);
                }
            }
            v0 = var2_13;
        }
        st = v0;
        return this.podStatus(name, st, restarts, nrOfContainersReady, nrOfContainers);
    }

    private String getStatusFromContainerStates(List<ContainerState> containerStates, int nrOfContainers) {
        return containerStates.nonEmpty() ? (containerStates.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CloudflowStatus$.$anonfun$getStatusFromContainerStates$1(x$6))).size() == nrOfContainers ? CloudflowStatus$PodStatus$.MODULE$.Running() : (containerStates.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CloudflowStatus$.$anonfun$getStatusFromContainerStates$2(x$7))).size() == nrOfContainers ? CloudflowStatus$PodStatus$.MODULE$.Terminated() : (String)containerStates.filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)CloudflowStatus$.$anonfun$getStatusFromContainerStates$3(x$8))).headOption().map((Function1 & Serializable)x$9 -> x$9.getWaiting().getReason()).getOrElse((Function0 & Serializable)() -> CloudflowStatus$PodStatus$.MODULE$.Pending()))) : CloudflowStatus$PodStatus$.MODULE$.Pending();
    }

    private boolean hasExpectedPods(App.StreamletStatus streamlet, int nrOfPodsDetected) {
        return BoxesRunTime.unboxToInt((Object)streamlet.expectedPodCount().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) == nrOfPodsDetected || BoxesRunTime.unboxToBoolean((Object)streamlet.expectedPodCount().map((Function1)(JFunction1.mcZI.sp & Serializable)x$10 -> x$10 == 0).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    private App.StreamletStatus updatePod(App.StreamletStatus streamlet, Pod pod) {
        App.PodStatus podStatus = this.fromPod(pod);
        Seq x$1 = (Seq)((SeqOps)streamlet.podStatuses().filterNot((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)CloudflowStatus$.$anonfun$updatePod$1(podStatus, x$11)))).$colon$plus((Object)podStatus);
        String x$2 = streamlet.copy$default$1();
        Option x$3 = streamlet.copy$default$2();
        return streamlet.copy(x$2, x$3, x$1);
    }

    private App.StreamletStatus deletePod(App.StreamletStatus streamlet, Pod pod) {
        Seq x$1 = (Seq)streamlet.podStatuses().filterNot((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)CloudflowStatus$.$anonfun$deletePod$1(pod, x$12)));
        String x$2 = streamlet.copy$default$1();
        Option x$3 = streamlet.copy$default$2();
        return streamlet.copy(x$2, x$3, x$1);
    }

    public App.AppStatus freshStatus(App.Spec spec, Map<String, Runner<?>> runners) {
        Vector<App.StreamletStatus> streamletStatuses = this.createStreamletStatuses(spec, runners);
        return new App.AppStatus(spec.appId(), spec.appVersion(), CloudflowStatus$Status$.MODULE$.Pending(), "", (Seq)Nil$.MODULE$, streamletStatuses);
    }

    public Action pendingAction(App.Cr app, Map<String, Runner<?>> runners, String msg) {
        this.log().info(new StringBuilder(31).append("Setting pending status for app ").append(((App.Spec)app.getSpec()).appId()).toString());
        App.AppStatus qual$1 = this.freshStatus((App.Spec)app.getSpec(), runners);
        String x$1 = CloudflowStatus$Status$.MODULE$.Pending();
        String x$2 = msg;
        String x$3 = qual$1.copy$default$1();
        String x$4 = qual$1.copy$default$2();
        Seq x$5 = qual$1.copy$default$5();
        Seq x$6 = qual$1.copy$default$6();
        App.AppStatus newStatus = qual$1.copy(x$3, x$4, x$1, x$2, x$5, x$6);
        app.setStatus((Object)newStatus);
        App.Cr x$7 = app;
        int x$8 = this.statusUpdateAction$default$2(x$7);
        return this.statusUpdateAction(x$7, x$8);
    }

    public Action errorAction(App.Cr app, Map<String, Runner<?>> runners, String msg) {
        this.log().info(new StringBuilder(29).append("Setting error status for app ").append(((App.Spec)app.getSpec()).appId()).toString());
        App.AppStatus qual$1 = this.freshStatus((App.Spec)app.getSpec(), runners);
        String x$1 = CloudflowStatus$Status$.MODULE$.Error();
        String x$2 = new StringBuilder(77).append("An unrecoverable error has occured, please undeploy the application. Reason: ").append(msg).toString();
        String x$3 = qual$1.copy$default$1();
        String x$4 = qual$1.copy$default$2();
        Seq x$5 = qual$1.copy$default$5();
        Seq x$6 = qual$1.copy$default$6();
        App.AppStatus newStatus = qual$1.copy(x$3, x$4, x$1, x$2, x$5, x$6);
        app.setStatus((Object)newStatus);
        App.Cr x$7 = app;
        int x$8 = this.statusUpdateAction$default$2(x$7);
        return this.statusUpdateAction(x$7, x$8);
    }

    private Vector<App.StreamletStatus> createStreamletStatuses(App.Spec spec, Map<String, Runner<?>> runners) {
        return ((IterableOnceOps)spec.deployments().map((Function1 & Serializable)deployment -> {
            App.StreamletStatus streamletStatus;
            if (!runners.contains((Object)deployment.runtime())) {
                streamletStatus = new App.StreamletStatus(deployment.streamletName(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Seq)new .colon.colon((Object)new App.PodStatus("<external>", CloudflowStatus$PodStatus$.MODULE$.ReadyTrue(), 0, 0, 0, CloudflowStatus$PodStatus$.MODULE$.Unknown()), (List)Nil$.MODULE$));
            } else {
                int expectedPodCount = BoxesRunTime.unboxToInt((Object)runners.get((Object)deployment.runtime()).map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.expectedPodCount(deployment))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
                streamletStatus = new App.StreamletStatus(deployment.streamletName(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)expectedPodCount)), (Seq)Nil$.MODULE$);
            }
            return streamletStatus;
        })).toVector();
    }

    private String calcAppStatus(Seq<App.StreamletStatus> streamletStatuses) {
        return streamletStatuses.forall((Function1 & Serializable)streamletStatus -> BoxesRunTime.boxToBoolean((boolean)CloudflowStatus$.$anonfun$calcAppStatus$1(streamletStatus))) ? CloudflowStatus$Status$.MODULE$.Running() : (((IterableOnceOps)streamletStatuses.flatMap((Function1 & Serializable)x$14 -> x$14.podStatuses())).exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)CloudflowStatus$.$anonfun$calcAppStatus$4(x$15))) ? CloudflowStatus$Status$.MODULE$.CrashLoopBackOff() : CloudflowStatus$Status$.MODULE$.Pending());
    }

    public String aggregatedStatus(App.AppStatus status) {
        return status.appStatus() == null || status.appStatus().isEmpty() ? CloudflowStatus$Status$.MODULE$.Pending() : status.appStatus();
    }

    public App.Cr updateApp(App.Cr newApp, Map<String, Runner<?>> runners) {
        Vector newStreamletStatuses = (Vector)this.createStreamletStatuses((App.Spec)newApp.getSpec(), runners).map((Function1 & Serializable)newStreamletStatus -> (App.StreamletStatus)((IterableOnceOps)Try$.MODULE$.apply((Function0 & Serializable)() -> ((App.AppStatus)newApp.getStatus()).streamletStatuses()).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$)).find((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)CloudflowStatus$.$anonfun$updateApp$4(newStreamletStatus, x$16))).map((Function1 & Serializable)streamletStatus -> {
            Seq x$1 = streamletStatus.podStatuses();
            String x$2 = newStreamletStatus.copy$default$1();
            Option x$3 = newStreamletStatus.copy$default$2();
            return newStreamletStatus.copy(x$2, x$3, x$1);
        }).getOrElse((Function0 & Serializable)() -> newStreamletStatus));
        App.AppStatus qual$1 = (App.AppStatus)newApp.getStatus();
        String x$4 = ((App.Spec)newApp.getSpec()).appId();
        String x$5 = ((App.Spec)newApp.getSpec()).appVersion();
        Vector x$6 = newStreamletStatuses;
        String x$7 = this.calcAppStatus((Seq<App.StreamletStatus>)newStreamletStatuses);
        String x$8 = qual$1.copy$default$4();
        Seq x$9 = qual$1.copy$default$5();
        App.AppStatus newStatus = qual$1.copy(x$4, x$5, x$7, x$8, x$9, (Seq)x$6);
        newApp.setStatus((Object)newStatus);
        return newApp;
    }

    public App.AppStatus updatePod(App.AppStatus status, String streamletName, Pod pod) {
        Seq streamletStatusesUpdated;
        Seq streamlets = (Seq)Try$.MODULE$.apply((Function0 & Serializable)() -> status.streamletStatuses()).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        List streamletStatus2 = streamlets.find((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)CloudflowStatus$.$anonfun$updatePod$4(streamletName, x$17))).map((Function1 & Serializable)streamletStatus -> MODULE$.updatePod((App.StreamletStatus)streamletStatus, pod)).toList();
        Seq x$1 = streamletStatusesUpdated = (Seq)((IterableOps)streamlets.filterNot((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)CloudflowStatus$.$anonfun$updatePod$6(streamletName, x$18)))).$plus$plus((IterableOnce)streamletStatus2);
        String x$2 = this.calcAppStatus((Seq<App.StreamletStatus>)streamletStatusesUpdated);
        String x$3 = status.copy$default$1();
        String x$4 = status.copy$default$2();
        String x$5 = status.copy$default$4();
        Seq x$6 = status.copy$default$5();
        return status.copy(x$3, x$4, x$2, x$5, x$6, x$1);
    }

    public App.AppStatus deletePod(App.AppStatus status, String streamletName, Pod pod) {
        Seq streamletStatusesUpdated;
        Seq streamlets = (Seq)Try$.MODULE$.apply((Function0 & Serializable)() -> status.streamletStatuses()).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        List streamletStatus2 = streamlets.find((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)CloudflowStatus$.$anonfun$deletePod$4(streamletName, x$19))).map((Function1 & Serializable)streamletStatus -> MODULE$.deletePod((App.StreamletStatus)streamletStatus, pod)).toList();
        Seq x$1 = streamletStatusesUpdated = (Seq)((IterableOps)streamlets.filterNot((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)CloudflowStatus$.$anonfun$deletePod$6(streamletName, x$20)))).$plus$plus((IterableOnce)streamletStatus2);
        String x$2 = this.calcAppStatus((Seq<App.StreamletStatus>)streamletStatusesUpdated);
        String x$3 = status.copy$default$1();
        String x$4 = status.copy$default$2();
        String x$5 = status.copy$default$4();
        Seq x$6 = status.copy$default$5();
        return status.copy(x$3, x$4, x$2, x$5, x$6, x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean ignoreOnErrorStatus(Option<App.Cr> oldApp, App.Cr newApp) {
        App.Cr cr = newApp;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        Option option = oldApp.map((Function1 & Serializable)x$22 -> (App.AppStatus)x$22.getStatus());
        if (!(option instanceof Some)) return true;
        Some some = (Some)option;
        App.AppStatus status = (App.AppStatus)some.value();
        String string = status.appStatus();
        Some some2 = new Some((Object)CloudflowStatus$Status$.MODULE$.Error());
        if (string != null) {
            if (!string.equals(some2)) return true;
            return false;
        }
        if (some2 == null) return false;
        return true;
    }

    public CustomResourceAdapter<App.Cr, App.List> adapter() {
        return adapter;
    }

    public Action statusUpdateAction(App.Cr app, int retry) {
        return Action$.MODULE$.operation((Function1 & Serializable)client -> client.customResources(App$.MODULE$.customResourceDefinitionContext(), App.Cr.class, App.List.class), (Function1 & Serializable)cr -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
            None$ none$;
            Resource current = (Resource)((Nameable)cr.inNamespace(app.namespace())).withName(app.name());
            Option option = Option$.MODULE$.apply(((Gettable)current.fromServer()).get());
            if (option instanceof Some) {
                Some some = (Some)option;
                App.Cr curr = (App.Cr)some.value();
                curr.setStatus(app.getStatus());
                App.Cr newAppWithStatus = new App.Cr(null, curr.getMetadata(), (App.AppStatus)curr.getStatus());
                none$ = new Some(current.updateStatus((Object)newAppWithStatus));
            } else {
                if (retry <= 0) {
                    MODULE$.log().warn("Cannot yet find the CR to update, giving up");
                }
                none$ = None$.MODULE$;
            }
            return none$;
        }), (Function1 & Serializable)res -> {
            boolean bl = false;
            Failure failure = null;
            Try try_ = res;
            if (try_ instanceof Success) {
                return Action$.MODULE$.noop();
            }
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable err = failure.exception();
                if (retry > 0) {
                    MODULE$.log().error(new StringBuilder(40).append("Failure updating the CR status retries: ").append(retry).toString(), err);
                    Thread.sleep(200L);
                    return MODULE$.statusUpdateAction(app, retry - 1);
                }
            }
            if (!bl) throw new MatchError((Object)try_);
            Throwable err = failure.exception();
            MODULE$.log().error("Failure updating the CR status retries exhausted, giving up", err);
            return Action$.MODULE$.noop();
        }, new Line(277), new File("/home/runner/work/cloudflow-release/cloudflow-release/target/cloudflow/core/cloudflow-operator/src/main/scala/cloudflow/operator/action/CloudflowStatus.scala"));
    }

    public int statusUpdateAction$default$2(App.Cr app) {
        return 3;
    }

    public static final /* synthetic */ PodStatus $anonfun$fromPod$1() {
        return new PodStatus();
    }

    public static final /* synthetic */ int $anonfun$fromPod$3(PodSpec x$2) {
        return x$2.getContainers().size();
    }

    public static final /* synthetic */ int $anonfun$fromPod$2(Pod pod$1, PodStatus status$1) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)pod$1.getSpec()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)CloudflowStatus$.$anonfun$fromPod$3(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> status$1.getContainerStatuses().size()));
    }

    public static final /* synthetic */ int $anonfun$fromPod$5() {
        return 0;
    }

    public static final /* synthetic */ int $anonfun$fromPod$6(PodStatus status$1) {
        return ((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(status$1.getContainerStatuses()).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$3.getReady())))).size();
    }

    public static final /* synthetic */ int $anonfun$fromPod$8() {
        return 0;
    }

    public static final /* synthetic */ int $anonfun$fromPod$9(PodStatus status$1) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(status$1.getContainerStatuses()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.getRestartCount()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$fromPod$11() {
        return 0;
    }

    public static final /* synthetic */ List $anonfun$fromPod$12(PodStatus status$1) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(status$1.getContainerStatuses()).asScala().map((Function1 & Serializable)x$5 -> x$5.getState())).toList();
    }

    public static final /* synthetic */ List $anonfun$fromPod$14() {
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ String $anonfun$fromPod$15(PodStatus status$1) {
        return status$1.getPhase();
    }

    public static final /* synthetic */ boolean $anonfun$getStatusFromContainerStates$1(ContainerState x$6) {
        return x$6.getRunning() != null;
    }

    public static final /* synthetic */ boolean $anonfun$getStatusFromContainerStates$2(ContainerState x$7) {
        return x$7.getTerminated() != null;
    }

    public static final /* synthetic */ boolean $anonfun$getStatusFromContainerStates$3(ContainerState x$8) {
        return x$8.getWaiting() != null;
    }

    public static final /* synthetic */ boolean $anonfun$updatePod$1(App.PodStatus podStatus$1, App.PodStatus x$11) {
        String string = x$11.name();
        String string2 = podStatus$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deletePod$1(Pod pod$2, App.PodStatus x$12) {
        String string = x$12.name();
        String string2 = pod$2.getMetadata().getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$calcAppStatus$1(App.StreamletStatus streamletStatus) {
        return MODULE$.hasExpectedPods(streamletStatus, streamletStatus.podStatuses().size()) && streamletStatus.podStatuses().forall((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)CloudflowStatus$.MODULE$.podReady(p, (Option<Object>)streamletStatus.expectedPodCount())));
    }

    public static final /* synthetic */ boolean $anonfun$calcAppStatus$4(App.PodStatus x$15) {
        String string = x$15.status();
        String string2 = CloudflowStatus$PodStatus$.MODULE$.CrashLoopBackOff();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateApp$4(App.StreamletStatus newStreamletStatus$1, App.StreamletStatus x$16) {
        String string = x$16.streamletName();
        String string2 = newStreamletStatus$1.streamletName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updatePod$4(String streamletName$1, App.StreamletStatus x$17) {
        String string = x$17.streamletName();
        String string2 = streamletName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updatePod$6(String streamletName$1, App.StreamletStatus x$18) {
        String string = x$18.streamletName();
        String string2 = streamletName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deletePod$4(String streamletName$2, App.StreamletStatus x$19) {
        String string = x$19.streamletName();
        String string2 = streamletName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deletePod$6(String streamletName$2, App.StreamletStatus x$20) {
        String string = x$20.streamletName();
        String string2 = streamletName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private CloudflowStatus$() {
    }
}

