/*
 * Decompiled with CFR 0.152.
 */
package cloudflow.operator;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ExtensionId;
import akka.actor.ExtensionIdProvider;
import cloudflow.operator.Settings;
import cloudflow.operator.action.AkkaRunnerDefaults;
import cloudflow.operator.action.ResourceConstraints;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import io.fabric8.kubernetes.api.model.Quantity;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.ModuleSerializationProxy;

public final class Settings$
implements ExtensionId<Settings>,
ExtensionIdProvider,
Serializable {
    public static final Settings$ MODULE$ = new Settings$();
    private static final String root;

    static {
        ExtensionId.$init$((ExtensionId)MODULE$);
        root = "cloudflow.platform";
    }

    public Extension apply(ClassicActorSystemProvider system) {
        return ExtensionId.apply$((ExtensionId)this, (ClassicActorSystemProvider)system);
    }

    public Extension get(ActorSystem system) {
        return ExtensionId.get$((ExtensionId)this, (ActorSystem)system);
    }

    public Extension get(ClassicActorSystemProvider system) {
        return ExtensionId.get$((ExtensionId)this, (ClassicActorSystemProvider)system);
    }

    public final int hashCode() {
        return ExtensionId.hashCode$((ExtensionId)this);
    }

    public final boolean equals(Object other) {
        return ExtensionId.equals$((ExtensionId)this, (Object)other);
    }

    public Settings$ lookup() {
        return this;
    }

    public Settings createExtension(ExtendedActorSystem system) {
        return new Settings(system.settings().config());
    }

    public Settings apply(ActorSystem system) {
        return new Settings(system.settings().config());
    }

    public String root() {
        return root;
    }

    public String cloudflow$operator$Settings$$getNonEmptyString(Config config, String key) {
        String value = config.getString(key).trim();
        if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(value))) {
            throw new ConfigException.BadValue(key, "Should be a non-empty String");
        }
        return value;
    }

    private Option<String> getOptionalString(Config config, String key) {
        Some some;
        try {
            some = new Some((Object)config.getString(key).trim());
        }
        catch (ConfigException.Missing missing) {
            some = None$.MODULE$;
        }
        return some;
    }

    public int cloudflow$operator$Settings$$getPort(Config config, String key) {
        return this.validatePortnumber(config.getInt(key), key);
    }

    private int validatePortnumber(int port, String key) {
        if (port < 0 || port > 65535) {
            throw new ConfigException.BadValue(key, new StringBuilder(25).append("Not a valid port number: ").append(port).toString());
        }
        return port;
    }

    private ResourceConstraints getResourceConstraints(Config config) {
        return new ResourceConstraints(Quantity.parse((String)this.cloudflow$operator$Settings$$getNonEmptyString(config, "requests-cpu")), Quantity.parse((String)this.cloudflow$operator$Settings$$getNonEmptyString(config, "requests-memory")), (Option<Quantity>)this.getOptionalString(config, "limits-cpu").map((Function1 & Serializable)v -> Quantity.parse((String)v)), (Option<Quantity>)this.getOptionalString(config, "limits-memory").map((Function1 & Serializable)v -> Quantity.parse((String)v)));
    }

    public AkkaRunnerDefaults cloudflow$operator$Settings$$getAkkaRunnerDefaults(Config config, String runnerPath, String runnerStr) {
        Config runnerConfig = config.getConfig(runnerPath);
        return new AkkaRunnerDefaults(this.getResourceConstraints(runnerConfig), this.cloudflow$operator$Settings$$getNonEmptyString(runnerConfig, "java-opts"));
    }

    private String appendResourcesToString(Seq<String> paths) {
        return (String)paths.foldLeft((Object)"", (Function2 & Serializable)(x0$1, x1$1) -> {
            String string;
            block6: {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    String acc = (String)tuple2._1();
                    String path = (String)tuple2._2();
                    try (BufferedSource source = null;){
                        try {
                            source = Source$.MODULE$.fromResource(path, Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec());
                            string = new StringBuilder(1).append(acc).append(source.getLines().mkString("\n")).append("\n").toString();
                            break block6;
                        }
                        catch (Throwable t) {
                            throw new Exception(new StringBuilder(45).append("Could not load file from resources with path ").append(path).toString(), t);
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = string;
            return string2;
        });
    }

    public Settings apply(Config config) {
        return new Settings(config);
    }

    public Option<Config> unapply(Settings x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.config());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Settings$.class);
    }

    private Settings$() {
    }
}

