/*
 * Decompiled with CFR 0.152.
 */
package cloudflow.operator;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.ClassicActorSystemProvider;
import akka.datap.crd.App;
import akka.datap.crd.App$;
import akka.stream.Materializer$;
import cloudflow.operator.BuildInfo$;
import cloudflow.operator.HealthChecks$;
import cloudflow.operator.Operator$;
import cloudflow.operator.Settings;
import cloudflow.operator.Settings$;
import cloudflow.operator.action.DeploymentContext;
import cloudflow.operator.action.Name$;
import cloudflow.operator.action.runner.AkkaRunner;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import javax.management.ObjectName;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class Main$ {
    public static final Main$ MODULE$ = new Main$();

    public void main(String[] args) {
        ActorSystem system = ActorSystem$.MODULE$.apply();
        try {
            ExecutionContextExecutor ec = system.dispatcher();
            Settings settings = Settings$.MODULE$.apply(system);
            DeploymentContext ctx = settings.deploymentContext();
            this.logStartOperatorMessage(settings, system);
            HealthChecks$.MODULE$.serve(settings, system, (ExecutionContext)ec);
            Serialization.jsonMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
            Serialization.jsonMapper().setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
            KubernetesClient client = this.connectToKubernetes(settings, system);
            client.customResources(App$.MODULE$.customResourceDefinitionContext(), App.Cr.class, App.List.class);
            this.checkCRD(settings, client, system);
            List<OwnerReference> ownerReferences = this.getDeploymentOwnerReferences(settings, client);
            this.installProtocolVersion(settings, client, ownerReferences);
            Map runners = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"akka"), (Object)new AkkaRunner(ctx.akkaRunnerDefaults()))}));
            Operator$.MODULE$.handleEvents(client, runners, ctx.podName(), ctx.podNamespace(), system, Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)system), (ExecutionContext)ec);
        }
        catch (Throwable t) {
            system.log().error(t, "Unexpected error starting cloudflow operator, terminating.");
            system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.exitWithFailure());
            system.terminate();
        }
    }

    private void logStartOperatorMessage(Settings settings, ActorSystem system) {
        system.log().info(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(130).append("\n      |Started cloudflow operator ..\n      |\n").append(this.box("Build Info")).append("\n      |").append(this.formatBuildInfo()).append("\n      |\n").append(this.box("JVM Resources")).append("\n      |").append(this.getJVMRuntimeParameters()).append("\n      |\n").append(this.box("GC Type")).append("\n      |\n").append(this.getGCInfo()).append("\n      |\n").append(this.box("Cloudflow Context")).append("\n      |").append(settings.deploymentContext().infoMessage()).append("\n      |\n").append(this.box("Deployment")).append("\n      |").append(this.formatDeploymentInfo(settings)).append("\n      ").toString())));
    }

    private List<OwnerReference> getDeploymentOwnerReferences(Settings settings, KubernetesClient client) {
        return (List)Option$.MODULE$.apply(((Gettable)((Nameable)client.apps().deployments().inNamespace(settings.podNamespace())).withName(Name$.MODULE$.ofCloudflowOperatorDeployment())).get()).map((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.ListHasAsScala(x$1.getMetadata().getOwnerReferences()).asScala().toList()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$));
    }

    private KubernetesClient connectToKubernetes(Settings settings, ActorSystem system) {
        NamespacedKubernetesClient namespacedKubernetesClient;
        Config conf = Config.autoConfigure(null);
        Option<String> option = settings.controlledNamespace();
        if (option instanceof Some) {
            Some some = (Some)option;
            String ns = (String)some.value();
            system.log().info(new StringBuilder(24).append("Connecting to namespace ").append(ns).toString());
            namespacedKubernetesClient = new DefaultKubernetesClient(conf).inNamespace(ns);
        } else {
            system.log().info("Connecting to all namespaces");
            namespacedKubernetesClient = new DefaultKubernetesClient(conf).inAnyNamespace();
        }
        NamespacedKubernetesClient client = namespacedKubernetesClient;
        String cluster = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> new StringBuilder(2).append(": ").append(conf.getCurrentContext().getContext().getCluster()).toString()).getOrElse((Function0 & Serializable)() -> "");
        system.log().info(new StringBuilder(32).append("Connected to Kubernetes cluster ").append(cluster).toString());
        return client;
    }

    private void exitWithFailure() {
        System.exit(-1);
    }

    private void checkCRD(Settings settings, KubernetesClient client, ActorSystem system) {
        Some some;
        CustomResourceDefinition crd;
        Option option = Option$.MODULE$.apply(((Gettable)client.apiextensions().v1().customResourceDefinitions().withName(App$.MODULE$.ResourceName())).get());
        if (!(option instanceof Some) || !CollectionConverters$.MODULE$.ListHasAsScala((crd = (CustomResourceDefinition)(some = (Some)option).value()).getSpec().getVersions()).asScala().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Main$.$anonfun$checkCRD$1(x$2)))) {
            system.log().error(new StringBuilder(167).append("Cloudflow CRD not found, please install it: 'kubectl apply -f https://raw.githubusercontent.com/lightbend/cloudflow/v").append(BuildInfo$.MODULE$.version()).append("/core/cloudflow-crd/kubernetes/cloudflow-crd.yaml'").toString());
            throw new Exception("Cloudflow CRD not found");
        }
        system.log().info(new StringBuilder(29).append("CRD found at version ").append("v1alpha1").toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void installProtocolVersion(Settings settings, KubernetesClient client, List<OwnerReference> ownerReferences) {
        ((CreateOrReplaceable)((Nameable)client.secrets().inNamespace(settings.podNamespace())).withName("cloudflow-protocol-version")).createOrReplace((Object[])new Secret[]{Operator$.MODULE$.ProtocolVersionSecret(ownerReferences)});
    }

    private List<Tuple2<String, ObjectName>> getGCInfo() {
        java.util.List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(gcMxBeans).asScala().map((Function1 & Serializable)b -> new Tuple2((Object)b.getName(), (Object)b.getObjectName()))).toList();
    }

    private String box(String str) {
        String string;
        if (str == null || str.isEmpty()) {
            string = "";
        } else {
            String line = new StringBuilder(2).append("+").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), 80)).append("+").toString();
            string = new StringBuilder(2).append(line).append("\n").append(str).append("\n").append(line).toString();
        }
        return string;
    }

    private String formatBuildInfo() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n    |Name          : ").append(BuildInfo$.MODULE$.name()).append("\n    |Version       : ").append(BuildInfo$.MODULE$.version()).append("\n    |Scala Version : ").append(BuildInfo$.MODULE$.scalaVersion()).append("\n    |sbt Version   : ").append(BuildInfo$.MODULE$.sbtVersion()).append("\n    |Build Time    : ").append(BuildInfo$.MODULE$.buildTime()).append("\n    |Build User    : ").append(BuildInfo$.MODULE$.buildUser()).append("\n    ").toString()));
    }

    private String formatDeploymentInfo(Settings settings) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(29).append("\n    |Release version : ").append(settings.releaseVersion()).append("\n    ").toString()));
    }

    private String getJVMRuntimeParameters() {
        Runtime runtime = Runtime.getRuntime();
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n     |Available processors    : ").append(runtime.availableProcessors()).append("\n     |Free Memory in the JVM  : ").append(runtime.freeMemory()).append("\n     |Max Memory JVM can use  : ").append(runtime.maxMemory()).append("\n     |Total Memory in the JVM : ").append(runtime.maxMemory()).append("\n    ").toString()));
    }

    public static final /* synthetic */ boolean $anonfun$checkCRD$1(CustomResourceDefinitionVersion x$2) {
        String string = x$2.getName();
        String string2 = "v1alpha1";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private Main$() {
    }
}

