/*
 * Decompiled with CFR 0.152.
 */
package cloudflow.localrunner;

import cloudflow.blueprint.RunnerConfigUtils$;
import cloudflow.blueprint.deployment.ApplicationDescriptor;
import cloudflow.blueprint.deployment.ApplicationDescriptorJsonFormat$;
import cloudflow.blueprint.deployment.Endpoint;
import cloudflow.blueprint.deployment.StreamletDeployment;
import cloudflow.blueprint.deployment.StreamletDeployment$;
import cloudflow.blueprint.deployment.StreamletInstance;
import cloudflow.blueprint.deployment.Topic;
import cloudflow.localrunner.LocalRunner;
import cloudflow.localrunner.LocalRunner$;
import cloudflow.runner.config;
import cloudflow.runner.config$;
import cloudflow.streamlets.BooleanValidationType$;
import cloudflow.streamlets.DoubleValidationType$;
import cloudflow.streamlets.IntegerValidationType$;
import cloudflow.streamlets.LoadedStreamlet;
import cloudflow.streamlets.Streamlet;
import cloudflow.streamlets.StreamletContext;
import cloudflow.streamlets.StreamletDefinition;
import cloudflow.streamlets.StreamletExecution;
import cloudflow.streamlets.StreamletLoader;
import cloudflow.streamlets.StreamletLoader$InvalidStreamletClass$;
import cloudflow.streamlets.StreamletLoader$NoArgsConstructorExpectedException$;
import cloudflow.streamlets.StreamletLoader$StreamletClassNotFound$;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import spray.json.JsonParser$;
import spray.json.JsonReader;
import spray.json.ParserInput;
import spray.json.ParserInput$;

public final class LocalRunner$
implements StreamletLoader {
    public static final LocalRunner$ MODULE$ = new LocalRunner$();
    private static Logger log;
    private static final PrintStream consoleOut;
    private static final PrintStream errOut;
    private static final String BootstrapServersKey;
    private static final ObjectMapper mapper;
    private static final Set<String> isNonQuotedType;
    private static volatile StreamletLoader$StreamletClassNotFound$ StreamletClassNotFound$module;
    private static volatile StreamletLoader$InvalidStreamletClass$ InvalidStreamletClass$module;
    private static volatile StreamletLoader$NoArgsConstructorExpectedException$ NoArgsConstructorExpectedException$module;
    private static volatile boolean bitmap$0;

    static {
        StreamletLoader.$init$((StreamletLoader)MODULE$);
        consoleOut = System.out;
        errOut = System.err;
        BootstrapServersKey = "bootstrap.servers";
        mapper = new ObjectMapper().registerModule((Module)new DefaultScalaModule());
        isNonQuotedType = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{BooleanValidationType$.MODULE$.type(), IntegerValidationType$.MODULE$.type(), DoubleValidationType$.MODULE$.type()}));
    }

    public Try<LoadedStreamlet> loadStreamlet(Config config2) {
        return StreamletLoader.loadStreamlet$((StreamletLoader)this, (Config)config2);
    }

    public Try<Streamlet<StreamletContext>> loadStreamletClass(String streamletClassName) {
        return StreamletLoader.loadStreamletClass$((StreamletLoader)this, (String)streamletClassName);
    }

    public Try<LoadedStreamlet> loadStreamlet(StreamletDefinition streamletConfig) {
        return StreamletLoader.loadStreamlet$((StreamletLoader)this, (StreamletDefinition)streamletConfig);
    }

    public StreamletLoader$StreamletClassNotFound$ StreamletClassNotFound() {
        if (StreamletClassNotFound$module == null) {
            this.StreamletClassNotFound$lzycompute$1();
        }
        return StreamletClassNotFound$module;
    }

    public StreamletLoader$InvalidStreamletClass$ InvalidStreamletClass() {
        if (InvalidStreamletClass$module == null) {
            this.InvalidStreamletClass$lzycompute$1();
        }
        return InvalidStreamletClass$module;
    }

    public StreamletLoader$NoArgsConstructorExpectedException$ NoArgsConstructorExpectedException() {
        if (NoArgsConstructorExpectedException$module == null) {
            this.NoArgsConstructorExpectedException$lzycompute$1();
        }
        return NoArgsConstructorExpectedException$module;
    }

    public PrintStream consoleOut() {
        return consoleOut;
    }

    public PrintStream errOut() {
        return errOut;
    }

    private Logger log$lzycompute() {
        LocalRunner$ localRunner$ = this;
        synchronized (localRunner$) {
            if (!bitmap$0) {
                log = LoggerFactory.getLogger((String)"localRunner");
                bitmap$0 = true;
            }
        }
        return log;
    }

    public Logger log() {
        return !bitmap$0 ? this.log$lzycompute() : log;
    }

    public Thread shutdownHook(OutputStream outputStream) {
        return new Thread(new Runnable(outputStream){
            private final OutputStream outputStream$1;

            public void run() {
                System.setOut(LocalRunner$.MODULE$.consoleOut());
                System.setErr(LocalRunner$.MODULE$.errOut());
                LocalRunner$.MODULE$.withResourceDo(this.outputStream$1, (Function1 & Serializable)x$1 -> {
                    anon.1.$anonfun$run$1(x$1);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$run$1(OutputStream x$1) {
                x$1.flush();
            }
            {
                this.outputStream$1 = outputStream$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(java.io.OutputStream )}, serializedLambda);
            }
        });
    }

    public String BootstrapServersKey() {
        return BootstrapServersKey;
    }

    /*
     * Unable to fully structure code
     */
    public void main(String[] args) {
        block7: {
            block6: {
                usage = "Usage: localRunner <applicationFileJson> <outputFile> <kafka-host> [localConfigFile]";
                var7_3 = false;
                var8_4 = null;
                var9_5 = Predef$.MODULE$.wrapRefArray((Object[])args).toList();
                if (!(var9_5 instanceof .colon.colon)) break block6;
                var7_3 = true;
                var8_4 = (.colon.colon)var9_5;
                app = (String)var8_4.head();
                var11_7 = var8_4.next$access$1();
                if (!(var11_7 instanceof .colon.colon)) break block6;
                var12_8 = (.colon.colon)var11_7;
                out = (String)var12_8.head();
                var14_10 = var12_8.next$access$1();
                if (!(var14_10 instanceof .colon.colon)) break block6;
                var15_11 = (.colon.colon)var14_10;
                kafkaHost = (String)var15_11.head();
                var17_13 = var15_11.next$access$1();
                if (!(var17_13 instanceof .colon.colon)) break block6;
                var18_14 = (.colon.colon)var17_13;
                conf = (String)var18_14.head();
                var20_16 = var18_14.next$access$1();
                if (!Nil$.MODULE$.equals(var20_16)) break block6;
                var3_17 = new Tuple4((Object)app, (Object)out, (Object)kafkaHost, (Object)ConfigFactory.parseFile((File)new File(conf)).resolve());
                break block7;
            }
            if (!var7_3) ** GOTO lbl-1000
            app = (String)var8_4.head();
            var22_19 = var8_4.next$access$1();
            if (!(var22_19 instanceof .colon.colon)) ** GOTO lbl-1000
            var23_20 = (.colon.colon)var22_19;
            out = (String)var23_20.head();
            var25_22 = var23_20.next$access$1();
            if (!(var25_22 instanceof .colon.colon)) ** GOTO lbl-1000
            var26_23 = (.colon.colon)var25_22;
            kafkaHost = (String)var26_23.head();
            var28_25 = var26_23.next$access$1();
            if (Nil$.MODULE$.equals(var28_25)) {
                var3_17 = new Tuple4((Object)app, (Object)out, (Object)kafkaHost, (Object)ConfigFactory.empty());
            } else lbl-1000:
            // 4 sources

            {
                if (Nil$.MODULE$.equals(var9_5)) {
                    throw new RuntimeException(new StringBuilder(72).append("Missing application configuration file and output file for Local Runner\n").append(usage).toString());
                }
                if (var7_3 && Nil$.MODULE$.equals(var29_26 = var8_4.next$access$1())) {
                    throw new RuntimeException(new StringBuilder(37).append("Missing output file for Local Runner\n").append(usage).toString());
                }
                if (var7_3 && (var30_27 = var8_4.next$access$1()) instanceof .colon.colon && Nil$.MODULE$.equals(var32_29 = (var31_28 = (.colon.colon)var30_27).next$access$1())) {
                    throw new RuntimeException(new StringBuilder(19).append("Missing kafka port\n").append(usage).toString());
                }
                throw new RuntimeException(new StringBuilder(38).append("Missing parameters for Local Runner. \n").append(usage).toString());
            }
        }
        var6_30 = var3_17;
        if (var6_30 == null) {
            throw new MatchError((Object)var6_30);
        }
        appDescriptorFilename = (String)var6_30._1();
        outputFilename = (String)var6_30._2();
        kafkaHost = (String)var6_30._3();
        localConfig = (Config)var6_30._4();
        var2_35 = new Tuple4((Object)appDescriptorFilename, (Object)outputFilename, (Object)kafkaHost, (Object)localConfig);
        var5_36 = var2_35;
        appDescriptorFilename = (String)var5_36._1();
        outputFilename = (String)var5_36._2();
        kafkaHost = (String)var5_36._3();
        localConfig = (Config)var5_36._4();
        outputFile = new File(outputFilename);
        Predef$.MODULE$.require(outputFile.exists(), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$main$1(java.io.File ), ()Ljava/lang/String;)((File)outputFile));
        fos = new FileOutputStream(outputFile);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook(fos));
        Console$.MODULE$.withOut((OutputStream)fos, (Function0)(JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$main$2(java.io.FileOutputStream java.lang.String com.typesafe.config.Config java.lang.String ), ()V)((FileOutputStream)fos, (String)appDescriptorFilename, (Config)localConfig, (String)kafkaHost));
    }

    private ObjectMapper mapper() {
        return mapper;
    }

    private String getRunnerConfig(String appId, String appVersion, StreamletDeployment deployment) {
        config.Streamlet streamletConfig = new config.Streamlet(deployment.className(), deployment.streamletName(), new config.StreamletContext(appId, appVersion, this.toJsonNode$1(deployment.config()), (Seq)((List)deployment.volumeMounts().getOrElse((Function0 & Serializable)() -> List$.MODULE$.empty())).map((Function1 & Serializable)vm -> new config.VolumeMount(vm.name(), vm.path(), vm.accessMode())), (Map)deployment.portMappings().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Topic topic = (Topic)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)new config.Topic(topic.id(), topic.cluster(), this.toJsonNode$1(topic.config())));
            return tuple22;
        })));
        return config$.MODULE$.toJson(streamletConfig);
    }

    private void run(ApplicationDescriptor appDescriptor, Config localConfig, String kafkaHost) {
        String bootstrapServers = localConfig.hasPath(this.BootstrapServersKey()) ? localConfig.getString(this.BootstrapServersKey()) : kafkaHost;
        Config topicConfig = ConfigFactory.parseString((String)new StringBuilder(22).append("bootstrap.servers = \"").append(bootstrapServers).append("\"").toString());
        String appId = appDescriptor.appId();
        String appVersion = appDescriptor.appVersion();
        Config baseConfig = ConfigFactory.load();
        Vector streamlets = (Vector)appDescriptor.streamlets().sortBy((Function1 & Serializable)x$3 -> x$3.name(), (Ordering)Ordering.String$.MODULE$);
        IntRef endpointIdx = IntRef.create((int)0);
        Vector streamletsWithConf = (Vector)streamlets.map((Function1 & Serializable)streamletInstance -> {
            String streamletName = streamletInstance.name();
            Config streamletParamConfig = (Config)MODULE$.resolveLocalStreamletConf((StreamletInstance)streamletInstance, localConfig).recoverWith((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof LocalRunner.MissingConfigurationException) {
                        LocalRunner.MissingConfigurationException missingConfigurationException = (LocalRunner.MissingConfigurationException)A1;
                        LocalRunner$.MODULE$.log().error(new StringBuilder(34).append("Missing streamlet configuration: \n").append(missingConfigurationException.keys().mkString("\n")).toString());
                        LocalRunner$.MODULE$.log().error("Configuration for local running is resolved the configuration `runLocalConfigFile` in the build.sbt");
                        object = new Failure((Throwable)missingConfigurationException);
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable instanceof LocalRunner.MissingConfigurationException;
                    return bl;
                }
            }).get();
            String localStorageDirectory = Files.createTempDirectory(new StringBuilder(21).append("local-runner-storage-").append(streamletName).toString(), new FileAttribute[0]).toFile().getAbsolutePath().replace('\\', '/');
            MODULE$.log().info(new StringBuilder(31).append("Using local storage directory: ").append(localStorageDirectory).toString());
            MapOps existingPortMappings = (MapOps)appDescriptor.deployments().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LocalRunner$.$anonfun$run$4(streamletInstance, x$4))).map((Function1 & Serializable)x$5 -> x$5.portMappings().mapValues((Function1 & Serializable)x$6 -> {
                None$ x$1 = None$.MODULE$;
                Config x$2 = topicConfig;
                String x$3 = x$6.copy$default$1();
                return x$6.copy(x$3, (Option)x$1, x$2);
            })).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
            StreamletDeployment deployment = StreamletDeployment$.MODULE$.apply(appDescriptor.appId(), streamletInstance, "", existingPortMappings.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), StreamletDeployment$.MODULE$.EndpointContainerPort() + endpointIdx$1.elem, StreamletDeployment$.MODULE$.apply$default$6());
            deployment.endpoint().foreach((Function1 & Serializable)x$7 -> {
                LocalRunner$.$anonfun$run$8(endpointIdx, x$7);
                return BoxedUnit.UNIT;
            });
            String runnerConfigObj = MODULE$.getRunnerConfig(appId, appVersion, deployment);
            Config runnerConfig = RunnerConfigUtils$.MODULE$.addStorageConfig(ConfigFactory.parseString((String)runnerConfigObj), localStorageDirectory);
            Config patchedRunnerConfig = runnerConfig.withFallback((ConfigMergeable)streamletParamConfig).withFallback((ConfigMergeable)baseConfig).withFallback((ConfigMergeable)localConfig).withValue("cloudflow.local", ConfigValueFactory.fromAnyRef((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            return new Tuple2(streamletInstance, (Object)patchedRunnerConfig);
        });
        Vector launchedStreamlets = (Vector)streamletsWithConf.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StreamletInstance streamletDescriptor = (StreamletInstance)tuple2._1();
            Config config2 = (Config)tuple2._2();
            Try try_ = MODULE$.loadStreamletClass(streamletDescriptor.descriptor().className()).map((Function1 & Serializable)streamlet -> {
                MODULE$.log().info(new StringBuilder(30).append("Preparing to run streamlet: [").append(streamletDescriptor.name()).append("]").toString());
                return streamlet.run(config2);
            }).recoverWith((PartialFunction)new Serializable(streamletDescriptor){
                private static final long serialVersionUID = 0L;
                private final StreamletInstance streamletDescriptor$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    Option option;
                    A1 A1 = x2;
                    if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                        Throwable ex = (Throwable)option.get();
                        LocalRunner$.MODULE$.log().error("Streamlet execution failed.", ex);
                        object = new Failure((Throwable)new LocalRunner.StreamletLaunchFailure(this.streamletDescriptor$1.name(), ex));
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Option option;
                    Throwable throwable = x2;
                    boolean bl = throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                    return bl;
                }
                {
                    this.streamletDescriptor$1 = streamletDescriptor$1;
                }
            });
            return try_;
        });
        this.reportAndExitOnFailure((Vector<Try<StreamletExecution>>)launchedStreamlets, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.reportAndExitOnFailure$default$2());
        Future pipelineExecution = Future$.MODULE$.sequence((IterableOnce)launchedStreamlets.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Try<StreamletExecution>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof Success) {
                    Success success = (Success)A1;
                    StreamletExecution streamletExecution = (StreamletExecution)success.value();
                    object = streamletExecution.completed();
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Try<StreamletExecution> x3) {
                Try<StreamletExecution> try_ = x3;
                boolean bl = try_ instanceof Success;
                return bl;
            }
        }), BuildFrom$.MODULE$.buildFromIterableOps(), ExecutionContext.Implicits$.MODULE$.global());
        ((Future)Await$.MODULE$.ready((Awaitable)pipelineExecution, (Duration)Duration$.MODULE$.Inf())).onComplete((Function1 & Serializable)x0$2 -> {
            LocalRunner$.$anonfun$run$12(x0$2);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private void reportAndExitOnFailure(Vector<Try<StreamletExecution>> launchedStreamlets, Function0<BoxedUnit> exit) {
        block0: {
            Vector failed = (Vector)launchedStreamlets.collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Try<StreamletExecution>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Failure) {
                        Failure failure = (Failure)A1;
                        Throwable ex = failure.exception();
                        object = ex;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Try<StreamletExecution> x1) {
                    Try<StreamletExecution> try_ = x1;
                    boolean bl = try_ instanceof Failure;
                    return bl;
                }
            });
            if (!failed.nonEmpty()) break block0;
            this.log().error("The application can't be started.");
            failed.foreach((Function1 & Serializable)ex -> {
                LocalRunner$.$anonfun$reportAndExitOnFailure$1(ex);
                return BoxedUnit.UNIT;
            });
            exit.apply$mcV$sp();
        }
    }

    private void reportAndExitOnFailure$default$2() {
        System.exit(-1);
    }

    private Try<Config> resolveLocalStreamletConf(StreamletInstance streamletDescriptor, Config localConf) {
        Seq streamletParamConfig = (Seq)streamletDescriptor.descriptor().configParameters().map((Function1 & Serializable)configParamDescriptor -> {
            String sourceKey = new StringBuilder(40).append("cloudflow.streamlets.").append(streamletDescriptor.name()).append(".config-parameters.").append(configParamDescriptor.key()).toString();
            String targetKey = new StringBuilder(22).append("cloudflow.streamlets.").append(streamletDescriptor.name()).append(".").append(configParamDescriptor.key()).toString();
            String validationType = configParamDescriptor.validationType();
            Some value = localConf.hasPath(sourceKey) ? new Some((Object)localConf.getString(sourceKey)) : configParamDescriptor.defaultValue();
            return new Tuple3((Object)targetKey, (Object)validationType, (Object)value);
        });
        String streamletSourceKey = new StringBuilder(28).append("cloudflow.streamlets.").append(streamletDescriptor.name()).append(".config").toString();
        String runtimeSourceKey = new StringBuilder(26).append("cloudflow.runtimes.").append(streamletDescriptor.descriptor().runtime().name()).append(".config").toString();
        Config streamletConf = localConf.hasPath(streamletSourceKey) ? localConf.getConfig(streamletSourceKey) : ConfigFactory.empty();
        Config runtimeConf = localConf.hasPath(runtimeSourceKey) ? localConf.getConfig(runtimeSourceKey) : ConfigFactory.empty();
        Config streamletConfig = streamletConf.withFallback((ConfigMergeable)runtimeConf);
        Seq missingValues = (Seq)streamletParamConfig.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple3<String, String, Option<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String k = (String)A1._1();
                    Option option = (Option)A1._3();
                    if (None$.MODULE$.equals(option)) {
                        object = k;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple3<String, String, Option<String>> x1) {
                Option option;
                Tuple3<String, String, Option<String>> tuple3 = x1;
                boolean bl = tuple3 != null && None$.MODULE$.equals(option = (Option)tuple3._3());
                return bl;
            }
        });
        return missingValues.nonEmpty() ? new Failure((Throwable)new LocalRunner.MissingConfigurationException((Seq<String>)missingValues)) : new Success((Object)ConfigFactory.parseString((String)((IterableOnceOps)streamletParamConfig.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple3<String, String, Option<String>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    String key = (String)A1._1();
                    String validationType = (String)A1._2();
                    Option option = (Option)A1._3();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String value = (String)some.value();
                        object = new StringBuilder(3).append(key).append(" : ").append(LocalRunner$.MODULE$.cloudflow$localrunner$LocalRunner$$quotePolicy(validationType).apply((Object)value)).toString();
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple3<String, String, Option<String>> x2) {
                Option option;
                Tuple3<String, String, Option<String>> tuple3 = x2;
                boolean bl = tuple3 != null && (option = (Option)tuple3._3()) instanceof Some;
                return bl;
            }
        })).mkString("\n")).withFallback((ConfigMergeable)streamletConfig));
    }

    private Set<String> isNonQuotedType() {
        return isNonQuotedType;
    }

    public Function1<String, String> cloudflow$localrunner$LocalRunner$$quotePolicy(String validationType) {
        return (Function1 & Serializable)x -> MODULE$.isNonQuotedType().apply((Object)validationType) ? x : new StringBuilder(2).append("\"").append((String)x).append("\"").toString();
    }

    private Try<ApplicationDescriptor> readDescriptorFile(String appDescriptorFilename) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (ApplicationDescriptor)JsonParser$.MODULE$.apply((ParserInput)ParserInput$.MODULE$.apply(Files.readAllBytes(Paths.get(appDescriptorFilename, new String[0])))).convertTo((JsonReader)ApplicationDescriptorJsonFormat$.MODULE$.applicationDescriptorFormat())).recoverWith((PartialFunction)new Serializable(appDescriptorFilename){
            private static final long serialVersionUID = 0L;
            private final String appDescriptorFilename$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Option option;
                A1 A1 = x1;
                if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    LocalRunner$.MODULE$.log().error(new StringBuilder(46).append("Failed to load application descriptor file [").append(this.appDescriptorFilename$2).append("].").toString(), ex);
                    object = new Failure(ex);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option option;
                Throwable throwable = x1;
                boolean bl = throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                return bl;
            }
            {
                this.appDescriptorFilename$2 = appDescriptorFilename$2;
            }
        });
    }

    public <T extends Closeable> void withResourceDo(T closeable, Function1<T, BoxedUnit> f) {
        block11: {
            try {
                try {
                    f.apply(closeable);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block11;
                    }
                    throw throwable;
                }
            }
            finally {
                try {
                    closeable.close();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && !(option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            }
        }
    }

    private final void StreamletClassNotFound$lzycompute$1() {
        LocalRunner$ localRunner$ = this;
        synchronized (localRunner$) {
            if (StreamletClassNotFound$module == null) {
                StreamletClassNotFound$module = new StreamletLoader$StreamletClassNotFound$((StreamletLoader)this);
            }
        }
    }

    private final void InvalidStreamletClass$lzycompute$1() {
        LocalRunner$ localRunner$ = this;
        synchronized (localRunner$) {
            if (InvalidStreamletClass$module == null) {
                InvalidStreamletClass$module = new StreamletLoader$InvalidStreamletClass$((StreamletLoader)this);
            }
        }
    }

    private final void NoArgsConstructorExpectedException$lzycompute$1() {
        LocalRunner$ localRunner$ = this;
        synchronized (localRunner$) {
            if (NoArgsConstructorExpectedException$module == null) {
                NoArgsConstructorExpectedException$module = new StreamletLoader$NoArgsConstructorExpectedException$((StreamletLoader)this);
            }
        }
    }

    public static final /* synthetic */ String $anonfun$main$1(File outputFile$1) {
        return new StringBuilder(54).append("Output file [").append(outputFile$1).append("] must exist before starting this process").toString();
    }

    public static final /* synthetic */ void $anonfun$main$2(FileOutputStream fos$1, String appDescriptorFilename$1, Config localConfig$1, String kafkaHost$1) {
        Console$.MODULE$.withErr((OutputStream)fos$1, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            System.setOut(new PrintStream(fos$1));
            System.setErr(new PrintStream(fos$1));
            Try<ApplicationDescriptor> try_ = MODULE$.readDescriptorFile(appDescriptorFilename$1);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)success.value();
                MODULE$.run(applicationDescriptor, localConfig$1, kafkaHost$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                MODULE$.log().error(new StringBuilder(60).append("Failed JSON unmarshalling of application descriptor file [").append(appDescriptorFilename$1).append("].").toString(), ex);
                System.exit(1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(try_);
            }
        });
    }

    private final JsonNode toJsonNode$1(Config config2) {
        return this.mapper().readTree(config2.root().render(ConfigRenderOptions.concise().setJson(true).setOriginComments(false).setComments(false)));
    }

    public static final /* synthetic */ boolean $anonfun$run$4(StreamletInstance streamletInstance$1, StreamletDeployment x$4) {
        String string = x$4.streamletName();
        String string2 = streamletInstance$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$run$8(IntRef endpointIdx$1, Endpoint x$7) {
        ++endpointIdx$1.elem;
    }

    public static final /* synthetic */ void $anonfun$run$12(Try x0$2) {
        Try try_ = x0$2;
        if (try_ instanceof Success) {
            MODULE$.log().info("Application terminated successfully");
            System.exit(0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            MODULE$.log().error("Failure in streamlet execution", ex);
            ex.printStackTrace();
            System.exit(-1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$reportAndExitOnFailure$1(Throwable ex) {
        MODULE$.log().error(ex.getMessage(), ex);
    }

    private LocalRunner$() {
    }
}

