/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.spanner.internal;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.typed.scaladsl.package;
import akka.annotation.InternalApi;
import akka.dispatch.ExecutionContexts$;
import akka.persistence.SelectedSnapshot;
import akka.persistence.SnapshotMetadata;
import akka.persistence.SnapshotMetadata$;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.spanner.SpannerSettings;
import akka.persistence.spanner.internal.SessionPool;
import akka.persistence.spanner.internal.SpannerGrpcClient;
import akka.persistence.spanner.internal.SpannerSnapshotInteractions$Schema$Snapshots$;
import akka.persistence.spanner.internal.SpannerUtils$;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.Serializers$;
import com.google.protobuf.struct.ListValue;
import com.google.protobuf.struct.ListValue$;
import com.google.protobuf.struct.Struct;
import com.google.protobuf.struct.Struct$;
import com.google.protobuf.struct.Value;
import com.google.protobuf.struct.Value$;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.Mutation;
import com.google.spanner.v1.Mutation$;
import com.google.spanner.v1.Mutation$Write$;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.Type$;
import com.google.spanner.v1.TypeCode$INT64$;
import com.google.spanner.v1.TypeCode$STRING$;
import com.google.spanner.v1.TypeCode$TIMESTAMP$;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t]qAB\u00181\u0011\u0003\u0011\u0004H\u0002\u0004;a!\u0005!g\u000f\u0005\u0006\u0005\u0006!\t\u0001R\u0004\u0006\u000b\u0006A\tA\u0012\u0004\u0006\u0011\u0006A\t!\u0013\u0005\u0006\u0005\u0012!\tAS\u0004\u0006\u0017\u0012A\t\u0001\u0014\u0004\u0006\u001d\u0012A\ta\u0014\u0005\u0006\u0005\u001e!\t\u0001\u0015\u0005\u0006#\u001e!IA\u0015\u0005\u0006=\u001e!\ta\u0018\u0005\bM\u001e\u0011\r\u0011\"\u0001h\u0011\u0019ix\u0001)A\u0005Q\"9ap\u0002b\u0001\n\u00039\u0007BB@\bA\u0003%\u0001\u000e\u0003\u0005\u0002\u0002\u001d\u0011\r\u0011\"\u0001h\u0011\u001d\t\u0019a\u0002Q\u0001\n!D\u0001\"!\u0002\b\u0005\u0004%\ta\u001a\u0005\b\u0003\u000f9\u0001\u0015!\u0003i\u0011!\tIa\u0002b\u0001\n\u00039\u0007bBA\u0006\u000f\u0001\u0006I\u0001\u001b\u0005\t\u0003\u001b9!\u0019!C\u0001O\"9\u0011qB\u0004!\u0002\u0013A\u0007\u0002CA\t\u000f\t\u0007I\u0011A4\t\u000f\u0005Mq\u0001)A\u0005Q\"A\u0011QC\u0004C\u0002\u0013\u0005q\rC\u0004\u0002\u0018\u001d\u0001\u000b\u0011\u00025\t\u0011\u0005eqA1A\u0005\u0002\u001dDq!a\u0007\bA\u0003%\u0001\u000eC\u0005\u0002\u001e\u001d\u0011\r\u0011\"\u0001\u0002 !A\u0011\u0011G\u0004!\u0002\u0013\t\tC\u0002\u0004;a\t\u0011\u00141\t\u0005\u000b\u0003\u000bz\"\u0011!Q\u0001\n\u0005\u001d\u0003\u0002C1 \u0005\u0003\u0005\u000b\u0011\u00022\t\u0015\u00055sD!A!\u0002\u0017\ty\u0005\u0003\u0006\u0002\\}\u0011\t\u0011)A\u0006\u0003;BaAQ\u0010\u0005\u0002\u0005%\u0004\"CA<?\t\u0007I\u0011BA=\u0011!\tYi\bQ\u0001\n\u0005m\u0004\"CAG?\t\u0007I\u0011BAH\u0011!\tYj\bQ\u0001\n\u0005E\u0005bBAO?\u0011\u0005\u0011q\u0014\u0005\b\u0003\u0007|B\u0011AAc\u0011\u001d\t\u0019o\bC\u0001\u0003KDq!a; \t\u0013\ti\u000fC\u0004\u0002r~!I!a=\t\u000f\t%q\u0004\"\u0003\u0003\f\u0005Y2\u000b]1o]\u0016\u00148K\\1qg\"|G/\u00138uKJ\f7\r^5p]NT!!\r\u001a\u0002\u0011%tG/\u001a:oC2T!a\r\u001b\u0002\u000fM\u0004\u0018M\u001c8fe*\u0011QGN\u0001\fa\u0016\u00148/[:uK:\u001cWMC\u00018\u0003\u0011\t7n[1\u0011\u0005e\nQ\"\u0001\u0019\u00037M\u0003\u0018M\u001c8feNs\u0017\r]:i_RLe\u000e^3sC\u000e$\u0018n\u001c8t'\t\tA\b\u0005\u0002>\u00016\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teH\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0001(\u0001\u0004TG\",W.\u0019\t\u0003\u000f\u0012i\u0011!\u0001\u0002\u0007'\u000eDW-\\1\u0014\u0005\u0011aD#\u0001$\u0002\u0013Ms\u0017\r]:i_R\u001c\bCA'\b\u001b\u0005!!!C*oCB\u001c\bn\u001c;t'\t9A\bF\u0001M\u0003-iW\r^1D_2,XN\\:\u0016\u0003M\u0003\"\u0001V.\u000f\u0005UK\u0006C\u0001,?\u001b\u00059&B\u0001-D\u0003\u0019a$o\\8u}%\u0011!LP\u0001\u0007!J,G-\u001a4\n\u0005qk&AB*ue&twM\u0003\u0002[}\u0005i1O\\1qg\"|G\u000fV1cY\u0016$\"a\u00151\t\u000b\u0005T\u0001\u0019\u00012\u0002\u0011M,G\u000f^5oON\u0004\"a\u00193\u000e\u0003IJ!!\u001a\u001a\u0003\u001fM\u0003\u0018M\u001c8feN+G\u000f^5oON\fQ\u0002U3sg&\u001cH/\u001a8dK&#W#\u00015\u0011\tuJ7N]\u0005\u0003Uz\u0012a\u0001V;qY\u0016\u0014\u0004C\u00017r\u001b\u0005i'B\u00018p\u0003\u0011a\u0017M\\4\u000b\u0003A\fAA[1wC&\u0011A,\u001c\t\u0003gnl\u0011\u0001\u001e\u0006\u0003kZ\f!A^\u0019\u000b\u0005M:(B\u0001=z\u0003\u00199wn\\4mK*\t!0A\u0002d_6L!\u0001 ;\u0003\tQK\b/Z\u0001\u000f!\u0016\u00148/[:uK:\u001cW-\u00133!\u0003\u0015\u0019V-\u001d(s\u0003\u0019\u0019V-\u001d(sA\u0005IqK]5uKRKW.Z\u0001\u000b/JLG/\u001a+j[\u0016\u0004\u0013!B*fe&#\u0017AB*fe&#\u0007%A\u0006TKJl\u0015M\\5gKN$\u0018\u0001D*fe6\u000bg.\u001b4fgR\u0004\u0013\u0001C*oCB\u001c\bn\u001c;\u0002\u0013Ms\u0017\r]:i_R\u0004\u0013\u0001B'fi\u0006\fQ!T3uC\u0002\n\u0011\"T3uCN+'/\u00133\u0002\u00155+G/Y*fe&#\u0007%A\bNKR\f7+\u001a:NC:Lg-Z:u\u0003AiU\r^1TKJl\u0015M\\5gKN$\b%A\u0004D_2,XN\\:\u0016\u0005\u0005\u0005\u0002#BA\u0012\u0003[YWBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u0013%lW.\u001e;bE2,'bAA\u0016}\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0012Q\u0005\u0002\u0005\u0019&\u001cH/\u0001\u0005D_2,XN\\:!Q\r\t\u0011Q\u0007\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111\b\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002@\u0005e\"aC%oi\u0016\u0014h.\u00197Ba&D3\u0001AA\u001b'\tyB(A\tta\u0006tg.\u001a:HeB\u001c7\t\\5f]R\u00042!OA%\u0013\r\tY\u0005\r\u0002\u0012'B\fgN\\3s\u000fJ\u00048m\u00117jK:$\u0018AA3d!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+}\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005e\u00131\u000b\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\faa]=ti\u0016l\u0007\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\rd'A\u0003bGR|'/\u0003\u0003\u0002h\u0005\u0005$aC!di>\u00148+_:uK6$b!a\u001b\u0002t\u0005UDCBA7\u0003_\n\t\b\u0005\u0002:?!9\u0011Q\n\u0013A\u0004\u0005=\u0003bBA.I\u0001\u000f\u0011Q\f\u0005\b\u0003\u000b\"\u0003\u0019AA$\u0011\u0015\tG\u00051\u0001c\u0003\rawnZ\u000b\u0003\u0003w\u0002B!! \u0002\b6\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000b\u0019)A\u0003tY\u001a$$N\u0003\u0002\u0002\u0006\u0006\u0019qN]4\n\t\u0005%\u0015q\u0010\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u0016\u0005\u0005E\u0005\u0003BAJ\u0003/k!!!&\u000b\u0007\u00055e'\u0003\u0003\u0002\u001a\u0006U%!D*fe&\fG.\u001b>bi&|g.\u0001\btKJL\u0017\r\\5{CRLwN\u001c\u0011\u0002\u0019\u0019Lg\u000eZ*oCB\u001c\bn\u001c;\u0015\r\u0005\u0005\u0016QWA]!\u0019\t\t&a)\u0002(&!\u0011QUA*\u0005\u00191U\u000f^;sKB)Q(!+\u0002.&\u0019\u00111\u0016 \u0003\r=\u0003H/[8o!\u0011\ty+!-\u000e\u0003QJ1!a-5\u0005A\u0019V\r\\3di\u0016$7K\\1qg\"|G\u000f\u0003\u0004\u00028&\u0002\raU\u0001\u000ea\u0016\u00148/[:uK:\u001cW-\u00133\t\u000f\u0005m\u0016\u00061\u0001\u0002>\u0006A1M]5uKJL\u0017\r\u0005\u0003\u00020\u0006}\u0016bAAai\tI2K\\1qg\"|GoU3mK\u000e$\u0018n\u001c8De&$XM]5b\u00031\u0019\u0018M^3T]\u0006\u00048\u000f[8u)\u0019\t9-a4\u0002ZB1\u0011\u0011KAR\u0003\u0013\u00042!PAf\u0013\r\tiM\u0010\u0002\u0005+:LG\u000fC\u0004\u0002R*\u0002\r!a5\u0002\u00115,G/\u00193bi\u0006\u0004B!a,\u0002V&\u0019\u0011q\u001b\u001b\u0003!Ms\u0017\r]:i_RlU\r^1eCR\f\u0007bBAnU\u0001\u0007\u0011Q\\\u0001\tg:\f\u0007o\u001d5piB\u0019Q(a8\n\u0007\u0005\u0005hHA\u0002B]f\fq\u0002Z3mKR,7K\\1qg\"|Go\u001d\u000b\u0007\u0003\u000f\f9/!;\t\r\u0005]6\u00061\u0001T\u0011\u001d\tYl\u000ba\u0001\u0003{\u000bAb\u001e5fe\u0016\u0004\u0016M\u001d;G_J$2aUAx\u0011\u001d\tY\f\fa\u0001\u0003{\u000ba\"];fef\u0004\u0016M]1ng\u001a{'\u000f\u0006\u0004\u0002v\n\u0015!q\u0001\t\u0005\u0003o\u0014\t!\u0004\u0002\u0002z*!\u00111`A\u007f\u0003\u0019\u0019HO];di*\u0019\u0011q`<\u0002\u0011A\u0014x\u000e^8ck\u001aLAAa\u0001\u0002z\n11\u000b\u001e:vGRDa!a..\u0001\u0004\u0019\u0006bBA^[\u0001\u0007\u0011QX\u0001\u0013cV,'/\u001f)be\u0006lG+\u001f9fg\u001a{'\u000f\u0006\u0003\u0003\u000e\tM\u0001#\u0002+\u0003\u0010M\u0013\u0018b\u0001B\t;\n\u0019Q*\u00199\t\u000f\u0005mf\u00061\u0001\u0002>\"\u001aq$!\u000e")
@InternalApi
public final class SpannerSnapshotInteractions {
    public final SpannerGrpcClient akka$persistence$spanner$internal$SpannerSnapshotInteractions$$spannerGrpcClient;
    public final SpannerSettings akka$persistence$spanner$internal$SpannerSnapshotInteractions$$settings;
    private final ExecutionContext ec;
    private final ActorSystem system;
    private final Logger akka$persistence$spanner$internal$SpannerSnapshotInteractions$$log;
    private final Serialization serialization;

    public Logger akka$persistence$spanner$internal$SpannerSnapshotInteractions$$log() {
        return this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$log;
    }

    private Serialization serialization() {
        return this.serialization;
    }

    public Future<Option<SelectedSnapshot>> findSnapshot(String persistenceId, SnapshotSelectionCriteria criteria) {
        String query = new StringBuilder(149).append("SELECT persistence_id, sequence_nr, timestamp, ser_id, ser_manifest, snapshot, meta, meta_ser_id, meta_ser_manifest ").append(new StringBuilder(6).append("FROM ").append(this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$settings.snapshotsTable()).append(" ").toString()).append(this.wherePartFor(criteria)).append("ORDER BY sequence_nr DESC LIMIT 1").toString();
        Struct queryParams = this.queryParamsFor(persistenceId, criteria);
        Map<String, Type> queryParamTypes = this.queryParamTypesFor(criteria);
        return this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$spannerGrpcClient.withSession((Function1 & Serializable)session -> {
            block0: {
                if (!this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$log().isTraceEnabled()) break block0;
                package.LoggerOps$.MODULE$.traceN$extension(akka.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$log()), "findSnapshot: pid: {}, session: {}, criteria: {}, query: {}, params: {}, paramTypes: {}", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{persistenceId, BoxesRunTime.boxToLong((long)session.id()), criteria, query, queryParams, queryParamTypes}));
            }
            return $this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$spannerGrpcClient.executeQuery(query, queryParams, queryParamTypes, (SessionPool.PooledSession)session).map((Function1 & Serializable)result -> {
                None$ none$;
                if (result.rows().isEmpty()) {
                    none$ = None$.MODULE$;
                } else {
                    SelectedSnapshot selectedSnapshot;
                    if (result.rows().size() > 1) {
                        throw new IllegalArgumentException(new StringBuilder(35).append("Expected a single row from db, got ").append(result.rows().size()).toString());
                    }
                    Iterator fieldIterator = ((ListValue)result.rows().head()).values().iterator();
                    String persistenceId = (String)((Value)fieldIterator.next()).kind().stringValue().get();
                    long sequenceNr = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)((Value)fieldIterator.next()).kind().stringValue().get()));
                    long timestamp = SpannerUtils$.MODULE$.spannerTimestampToUnixMillis((String)((Value)fieldIterator.next()).kind().stringValue().get());
                    int serId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)((Value)fieldIterator.next()).kind().stringValue().get()));
                    String serManifest = (String)((Value)fieldIterator.next()).kind().stringValue().get();
                    byte[] snapshotBytes = Base64.getDecoder().decode((String)((Value)fieldIterator.next()).kind().stringValue().get());
                    Object snapshot = this.serialization().deserialize(snapshotBytes, serId, serManifest).get();
                    SnapshotMetadata metadata = SnapshotMetadata$.MODULE$.apply(persistenceId, sequenceNr, timestamp);
                    Value firstMetaField = (Value)fieldIterator.next();
                    if (firstMetaField.kind().isNullValue()) {
                        selectedSnapshot = new SelectedSnapshot(metadata, snapshot);
                    } else {
                        String snapshotByteString = firstMetaField.getStringValue();
                        int metaSerId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)((Value)fieldIterator.next()).kind().stringValue().get()));
                        String metaSerManifest = (String)((Value)fieldIterator.next()).kind().stringValue().get();
                        byte[] snapshotBytes2 = Base64.getDecoder().decode(snapshotByteString);
                        Object replicationMeta = this.serialization().deserialize(snapshotBytes2, metaSerId, metaSerManifest).get();
                        selectedSnapshot = new SelectedSnapshot(metadata.withMetadata(replicationMeta), snapshot);
                    }
                    none$ = new Some((Object)selectedSnapshot);
                }
                return none$;
            }, $this.ec);
        });
    }

    public Future<BoxedUnit> saveSnapshot(SnapshotMetadata metadata, Object snapshot) {
        return (Future)Serialization$.MODULE$.withTransportInformation((ExtendedActorSystem)this.system, (Function0 & Serializable)() -> {
            List list;
            Object s2 = snapshot;
            Serializer serializer = this.serialization().findSerializerFor(s2);
            String manifest = Serializers$.MODULE$.manifestFor(serializer, s2);
            String snapshotBytes = Base64.getEncoder().encodeToString(serializer.toBinary(s2));
            List noMetaColumnList = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Value[]{new Value((Value.Kind)new Value.Kind$.StringValue(metadata.persistenceId()), Value$.MODULE$.apply$default$2()), new Value((Value.Kind)new Value.Kind$.StringValue(Long.toString(metadata.sequenceNr())), Value$.MODULE$.apply$default$2()), new Value((Value.Kind)new Value.Kind$.StringValue(SpannerUtils$.MODULE$.unixTimestampMillisToSpanner(metadata.timestamp())), Value$.MODULE$.apply$default$2()), new Value((Value.Kind)new Value.Kind$.StringValue(Integer.toString(serializer.identifier())), Value$.MODULE$.apply$default$2()), new Value((Value.Kind)new Value.Kind$.StringValue(manifest), Value$.MODULE$.apply$default$2()), new Value((Value.Kind)new Value.Kind$.StringValue(snapshotBytes), Value$.MODULE$.apply$default$2())}));
            Option option = metadata.metadata();
            if (option instanceof Some) {
                Object replicationMeta;
                Some some = (Some)option;
                Object rm2 = replicationMeta = some.value();
                Serializer metaSerializer = this.serialization().findSerializerFor(rm2);
                String metaManifest = Serializers$.MODULE$.manifestFor(metaSerializer, rm2);
                String serializedMetaString = Base64.getEncoder().encodeToString(metaSerializer.toBinary(rm2));
                list = (List)noMetaColumnList.$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Value[]{new Value((Value.Kind)new Value.Kind$.StringValue(serializedMetaString), Value$.MODULE$.apply$default$2()), new Value((Value.Kind)new Value.Kind$.StringValue(Integer.toString(metaSerializer.identifier())), Value$.MODULE$.apply$default$2()), new Value((Value.Kind)new Value.Kind$.StringValue(metaManifest), Value$.MODULE$.apply$default$2())})));
            } else if (None$.MODULE$.equals(option)) {
                list = (List)noMetaColumnList.$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Value[]{new Value((Value.Kind)SpannerUtils$.MODULE$.nullValue(), Value$.MODULE$.apply$default$2()), new Value((Value.Kind)SpannerUtils$.MODULE$.nullValue(), Value$.MODULE$.apply$default$2()), new Value((Value.Kind)SpannerUtils$.MODULE$.nullValue(), Value$.MODULE$.apply$default$2())})));
            } else {
                throw new MatchError((Object)option);
            }
            List columnList = list;
            return $this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$spannerGrpcClient.withSession((Function1 & Serializable)session -> {
                if (this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$log().isTraceEnabled()) {
                    package.LoggerOps$.MODULE$.traceN$extension(akka.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$log()), "Writing snapshot, persistenceId [{}], sequenceNr [{}], timestamp: [{}], session: [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{metadata.persistenceId(), BoxesRunTime.boxToLong((long)metadata.sequenceNr()), BoxesRunTime.boxToLong((long)metadata.timestamp()), BoxesRunTime.boxToLong((long)session.id())}));
                }
                return $this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$spannerGrpcClient.write((Seq<Mutation>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Mutation[]{new Mutation(new Mutation.Operation.Insert(new Mutation.Write($this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$settings.snapshotsTable(), (Seq<String>)SpannerSnapshotInteractions$Schema$Snapshots$.MODULE$.Columns(), (Seq<ListValue>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListValue[]{new ListValue((Seq)columnList, ListValue$.MODULE$.apply$default$2())}))), Mutation$Write$.MODULE$.apply$default$4())), Mutation$.MODULE$.apply$default$2())}))), (SessionPool.PooledSession)session).recoverWith((PartialFunction)new Serializable(this, (SessionPool.PooledSession)session, metadata, columnList){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ SpannerSnapshotInteractions $outer;
                    private final SessionPool.PooledSession session$1;
                    private final SnapshotMetadata metadata$1;
                    private final List columnList$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Future<BoxedUnit> future;
                        A1 A1 = x1;
                        if (A1 instanceof StatusRuntimeException) {
                            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)A1;
                            Status.Code code = statusRuntimeException.getStatus().getCode();
                            Status.Code code2 = Status.Code.ALREADY_EXISTS;
                            if (!(code != null ? !code.equals(code2) : code2 != null)) {
                                package.LoggerOps$.MODULE$.debugN$extension(akka.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.$outer.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$log()), "Snapshot already exists, updating. Session: {}, persistenceId: {}, sequenceNr: {}", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.session$1.id()), this.metadata$1.persistenceId(), BoxesRunTime.boxToLong((long)this.metadata$1.sequenceNr())}));
                                future = this.$outer.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$spannerGrpcClient.write((Seq<Mutation>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Mutation[]{new Mutation(new Mutation.Operation.Update(new Mutation.Write(this.$outer.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$settings.snapshotsTable(), (Seq<String>)SpannerSnapshotInteractions$Schema$Snapshots$.MODULE$.Columns(), (Seq<ListValue>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListValue[]{new ListValue((Seq)this.columnList$1, ListValue$.MODULE$.apply$default$2())}))), Mutation$Write$.MODULE$.apply$default$4())), Mutation$.MODULE$.apply$default$2())}))), this.session$1);
                                return (B1)future;
                            }
                        }
                        future = function1.apply(x1);
                        return (B1)future;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        if (!(throwable instanceof StatusRuntimeException)) return false;
                        StatusRuntimeException statusRuntimeException = (StatusRuntimeException)throwable;
                        Status.Code code = statusRuntimeException.getStatus().getCode();
                        Status.Code code2 = Status.Code.ALREADY_EXISTS;
                        if (code != null) {
                            if (!code.equals(code2)) return false;
                            return true;
                        }
                        if (code2 == null) return true;
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.session$1 = session$1;
                        this.metadata$1 = metadata$1;
                        this.columnList$1 = columnList$1;
                    }
                }, $this.ec);
            });
        });
    }

    public Future<BoxedUnit> deleteSnapshots(String persistenceId, SnapshotSelectionCriteria criteria) {
        String query = new StringBuilder(0).append(new StringBuilder(13).append("DELETE FROM ").append(this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$settings.snapshotsTable()).append(" ").toString()).append(this.wherePartFor(criteria)).toString();
        Struct queryParams = this.queryParamsFor(persistenceId, criteria);
        Map<String, Type> queryParamTypes = this.queryParamTypesFor(criteria);
        return this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$spannerGrpcClient.withSession((Function1 & Serializable)session -> {
            if (this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$log().isTraceEnabled()) {
                package.LoggerOps$.MODULE$.traceN$extension(akka.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$log()), "deleteSnapshots: pid: {}, session: {}, criteria: {}, query: {}, params: {}, paramTypes: {}", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{persistenceId, BoxesRunTime.boxToLong((long)session.id()), criteria, query, queryParams, queryParamTypes}));
            }
            return $this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$spannerGrpcClient.executeBatchDml((List<Tuple3<String, Struct, Map<String, Type>>>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)query, (Object)queryParams, (Object)queryParamTypes)}))), (SessionPool.PooledSession)session).map((Function1 & Serializable)x$2 -> {
                SpannerSnapshotInteractions.$anonfun$deleteSnapshots$2(x$2);
                return BoxedUnit.UNIT;
            }, ExecutionContexts$.MODULE$.parasitic());
        });
    }

    private String wherePartFor(SnapshotSelectionCriteria criteria) {
        return new StringBuilder(39).append("WHERE persistence_id = @persistence_id ").append((Object)(criteria.maxSequenceNr() != Long.MAX_VALUE ? "AND sequence_nr <= @max_seq_nr " : "")).append((Object)(criteria.minSequenceNr() > 0L ? "AND sequence_nr >= @min_seq_nr " : "")).append((Object)(criteria.maxTimestamp() != Long.MAX_VALUE ? "AND timestamp <= @max_timestamp " : "")).append((Object)(criteria.minTimestamp() > 0L ? "AND timestamp >= @min_timestamp " : "")).toString();
    }

    private Struct queryParamsFor(String persistenceId, SnapshotSelectionCriteria criteria) {
        return new Struct(((IterableOnceOps)((StrictOptimizedIterableOps)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(SpannerSnapshotInteractions$Schema$Snapshots$.MODULE$.PersistenceId()._1()), (Object)new Value((Value.Kind)new Value.Kind$.StringValue(persistenceId), Value$.MODULE$.apply$default$2()))), criteria.maxSequenceNr() != Long.MAX_VALUE ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_seq_nr"), (Object)new Value((Value.Kind)new Value.Kind$.StringValue(Long.toString(criteria.maxSequenceNr())), Value$.MODULE$.apply$default$2()))) : None$.MODULE$, criteria.minSequenceNr() > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min_seq_nr"), (Object)new Value((Value.Kind)new Value.Kind$.StringValue(Long.toString(criteria.minSequenceNr())), Value$.MODULE$.apply$default$2()))) : None$.MODULE$, criteria.maxTimestamp() != Long.MAX_VALUE ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_timestamp"), (Object)new Value((Value.Kind)new Value.Kind$.StringValue(SpannerUtils$.MODULE$.unixTimestampMillisToSpanner(criteria.maxTimestamp())), Value$.MODULE$.apply$default$2()))) : None$.MODULE$, criteria.minTimestamp() > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min_timestamp"), (Object)new Value((Value.Kind)new Value.Kind$.StringValue(SpannerUtils$.MODULE$.unixTimestampMillisToSpanner(criteria.minTimestamp())), Value$.MODULE$.apply$default$2()))) : None$.MODULE$}))).flatten(Predef$.MODULE$.$conforms())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), Struct$.MODULE$.apply$default$2());
    }

    private Map<String, Type> queryParamTypesFor(SnapshotSelectionCriteria criteria) {
        return ((IterableOnceOps)((StrictOptimizedIterableOps)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"persistence_id"), (Object)new Type(TypeCode$STRING$.MODULE$, Type$.MODULE$.apply$default$2(), Type$.MODULE$.apply$default$3(), Type$.MODULE$.apply$default$4()))), criteria.maxSequenceNr() != Long.MAX_VALUE ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_seq_nr"), (Object)new Type(TypeCode$INT64$.MODULE$, Type$.MODULE$.apply$default$2(), Type$.MODULE$.apply$default$3(), Type$.MODULE$.apply$default$4()))) : None$.MODULE$, criteria.minSequenceNr() > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min_seq_nr"), (Object)new Type(TypeCode$INT64$.MODULE$, Type$.MODULE$.apply$default$2(), Type$.MODULE$.apply$default$3(), Type$.MODULE$.apply$default$4()))) : None$.MODULE$, criteria.maxTimestamp() != Long.MAX_VALUE ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_timestamp"), (Object)new Type(TypeCode$TIMESTAMP$.MODULE$, Type$.MODULE$.apply$default$2(), Type$.MODULE$.apply$default$3(), Type$.MODULE$.apply$default$4()))) : None$.MODULE$, criteria.minTimestamp() > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min_timestamp"), (Object)new Type(TypeCode$TIMESTAMP$.MODULE$, Type$.MODULE$.apply$default$2(), Type$.MODULE$.apply$default$3(), Type$.MODULE$.apply$default$4()))) : None$.MODULE$}))).flatten(Predef$.MODULE$.$conforms())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ void $anonfun$deleteSnapshots$2(ExecuteBatchDmlResponse x$2) {
    }

    public SpannerSnapshotInteractions(SpannerGrpcClient spannerGrpcClient, SpannerSettings settings, ExecutionContext ec, ActorSystem system) {
        this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$spannerGrpcClient = spannerGrpcClient;
        this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$settings = settings;
        this.ec = ec;
        this.system = system;
        this.akka$persistence$spanner$internal$SpannerSnapshotInteractions$$log = LoggerFactory.getLogger(this.getClass());
        this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(system);
    }
}

