/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.spanner.internal;

import akka.Done;
import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorRef$;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.SupervisorStrategy;
import akka.actor.typed.SupervisorStrategy$;
import akka.actor.typed.scaladsl.AskPattern;
import akka.actor.typed.scaladsl.AskPattern$;
import akka.actor.typed.scaladsl.Behaviors;
import akka.actor.typed.scaladsl.Behaviors$;
import akka.actor.typed.scaladsl.package;
import akka.actor.typed.scaladsl.package$;
import akka.annotation.InternalStableApi;
import akka.dispatch.ExecutionContexts$;
import akka.persistence.spanner.SpannerSettings;
import akka.persistence.spanner.internal.RowCollector$;
import akka.persistence.spanner.internal.SessionDeleted$;
import akka.persistence.spanner.internal.SessionPool;
import akka.persistence.spanner.internal.SessionPool$;
import akka.persistence.spanner.internal.SpannerGrpcClient$;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ConstantFun$;
import akka.util.Timeout;
import com.google.protobuf.ByteString;
import com.google.protobuf.struct.Struct;
import com.google.protobuf.struct.Value;
import com.google.rpc.Code$OK$;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.BeginTransactionRequest$;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitRequest$;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest$;
import com.google.spanner.v1.ExecuteBatchDmlRequest$Statement$;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ExecuteSqlRequest$;
import com.google.spanner.v1.Mutation;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.SpannerClient;
import com.google.spanner.v1.TransactionOptions;
import com.google.spanner.v1.TransactionOptions$;
import com.google.spanner.v1.TransactionOptions$ReadWrite$;
import com.google.spanner.v1.TransactionSelector;
import com.google.spanner.v1.TransactionSelector$;
import com.google.spanner.v1.Type;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Deadline;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NoStackTrace;
import scalapb.UnknownFieldSet;

@ScalaSignature(bytes="\u0006\u0005\ruq!\u0002\u00180\u0011\u0003Ad!\u0002\u001e0\u0011\u0003Y\u0004\"\u0002\"\u0002\t\u0003\u0019e\u0001\u0002#\u0002\u0005\u0015C\u0001BU\u0002\u0003\u0002\u0003\u0006Ia\u0015\u0005\t-\u000e\u0011\t\u0011)A\u0005/\"Aql\u0001B\u0001B\u0003%\u0001\rC\u0003C\u0007\u0011\u00051M\u0002\u0003j\u0003\tQ\u0007\"\u0002\"\t\t\u0003\u0019h\u0001B;\u0002\u0005YDQA\u0011\u0006\u0005\u0002]Dq!_\u0001C\u0002\u0013\u0005!\u0010\u0003\u0004|\u0003\u0001\u0006I\u0001\u001e\u0005\by\u0006\u0011\r\u0011\"\u0001~\u0011\u0019q\u0018\u0001)A\u0005q\"Aq0\u0001b\u0001\n\u0013\t\t\u0001\u0003\u0005\u0002\u001a\u0005\u0001\u000b\u0011BA\u0002\u0011\u001d\tY\"\u0001C\u0005\u0003;1QAO\u0018\u0001\u0003kA\u0011\"a\u000e\u0014\u0005\u0003\u0005\u000b\u0011B,\t\u0015\u0005e2C!b\u0001\n\u0003\tY\u0004\u0003\u0006\u0002TM\u0011\t\u0011)A\u0005\u0003{A!\"!\u0016\u0014\u0005\u0003\u0005\u000b\u0011BA,\u0011)\tIh\u0005B\u0001B\u0003%\u00111\u0010\u0005\u0007\u0005N!\t!a!\t\u0013\u0005]5C1A\u0005\f\u0005e\u0005\u0002CAR'\u0001\u0006I!a'\t\u0013\u0005\u00156C1A\u0005\f\u0005\u001d\u0006\u0002CAZ'\u0001\u0006I!!+\t\u0013\u0005U6C1A\u0005\n\u0005]\u0006\u0002CAe'\u0001\u0006I!!/\t\u0013\u0005-7C1A\u0005\n\u00055\u0007\u0002CAz'\u0001\u0006I!a4\t\u000f\u0005U8\u0003\"\u0001\u0002x\"I!\u0011K\n\u0012\u0002\u0013\u0005!1\u000b\u0005\n\u0005O\u001a\u0012\u0013!C\u0001\u0005SBqA!\u001c\u0014\t\u0003\u0011y\u0007C\u0004\u0003\u0012N!\tAa%\t\u000f\tE6\u0003\"\u0001\u00034\"9!qY\n\u0005\u0002\t%\u0007b\u0002Bp'\u0011\u0005!\u0011\u001d\u0005\b\u0005G\u001cB\u0011\u0002Bs\u0011\u001d\u0011)p\u0005C\u0005\u0005oDqa!\u0004\u0014\t#\u0019y\u0001C\u0004\u0004\u0018M!\tb!\u0007\u0002#M\u0003\u0018M\u001c8fe\u001e\u0013\boY\"mS\u0016tGO\u0003\u00021c\u0005A\u0011N\u001c;fe:\fGN\u0003\u00023g\u000591\u000f]1o]\u0016\u0014(B\u0001\u001b6\u0003-\u0001XM]:jgR,gnY3\u000b\u0003Y\nA!Y6lC\u000e\u0001\u0001CA\u001d\u0002\u001b\u0005y#!E*qC:tWM]$sa\u000e\u001cE.[3oiN\u0011\u0011\u0001\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A$!\u0005+sC:\u001c\u0018m\u0019;j_:4\u0015-\u001b7fIN\u00111A\u0012\t\u0003\u000f>s!\u0001S'\u000f\u0005%cU\"\u0001&\u000b\u0005-;\u0014A\u0002\u001fs_>$h(C\u0001@\u0013\tqe(A\u0004qC\u000e\\\u0017mZ3\n\u0005A\u000b&\u0001\u0005*v]RLW.Z#yG\u0016\u0004H/[8o\u0015\tqe(\u0001\u0003d_\u0012,\u0007CA\u001fU\u0013\t)fHA\u0002J]R\fq!\\3tg\u0006<W\r\u0005\u0002Y9:\u0011\u0011L\u0017\t\u0003\u0013zJ!a\u0017 \u0002\rA\u0013X\rZ3g\u0013\tifL\u0001\u0004TiJLgn\u001a\u0006\u00037z\nq\u0001Z3uC&d7\u000f\u0005\u0002>C&\u0011!M\u0010\u0002\u0004\u0003:LH\u0003\u00023gO\"\u0004\"!Z\u0002\u000e\u0003\u0005AQAU\u0004A\u0002MCQAV\u0004A\u0002]CQaX\u0004A\u0002\u0001\u0014\u0011\u0003U8pY\n+8/_#yG\u0016\u0004H/[8o'\rAai\u001b\t\u0003YFl\u0011!\u001c\u0006\u0003]>\fqaY8oiJ|GN\u0003\u0002q}\u0005!Q\u000f^5m\u0013\t\u0011XN\u0001\u0007O_N#\u0018mY6Ue\u0006\u001cW\rF\u0001u!\t)\u0007BA\u000bQ_>d7\u000b[;ui&tw-\u0012=dKB$\u0018n\u001c8\u0014\u0007)15\u000eF\u0001y!\t)'\"A\tQ_>d')^:z\u000bb\u001cW\r\u001d;j_:,\u0012\u0001^\u0001\u0013!>|GNQ;ts\u0016C8-\u001a9uS>t\u0007%A\rQ_>d7\u000b[;ui&tw\rR8x]\u0016C8-\u001a9uS>tW#\u0001=\u00025A{w\u000e\\*ikR$\u0018N\\4E_^tW\t_2faRLwN\u001c\u0011\u0002!M,7o]5p]&#7i\\;oi\u0016\u0014XCAA\u0002!\u0011\t)!!\u0006\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\ta!\u0019;p[&\u001c'\u0002BA\u0007\u0003\u001f\t!bY8oGV\u0014(/\u001a8u\u0015\r\u0001\u0018\u0011\u0003\u0006\u0003\u0003'\tAA[1wC&!\u0011qCA\u0004\u0005)\tEo\\7jG2{gnZ\u0001\u0012g\u0016\u001c8/[8o\u0013\u0012\u001cu.\u001e8uKJ\u0004\u0013!\u00048fqR\u001cVm]:j_:LE\r\u0006\u0002\u0002 A\u0019Q(!\t\n\u0007\u0005\rbH\u0001\u0003M_:<\u0007fA\u0001\u0002(A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.U\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t$a\u000b\u0003#%sG/\u001a:oC2\u001cF/\u00192mK\u0006\u0003\u0018\u000eK\u0002\u0001\u0003O\u0019\"a\u0005\u001f\u0002\t9\fW.Z\u0001\u0007G2LWM\u001c;\u0016\u0005\u0005u\u0002\u0003BA \u0003\u001fj!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0003mFR1AMA$\u0015\u0011\tI%a\u0013\u0002\r\u001d|wn\u001a7f\u0015\t\ti%A\u0002d_6LA!!\u0015\u0002B\ti1\u000b]1o]\u0016\u00148\t\\5f]R\fqa\u00197jK:$\b%\u0001\u0004tsN$X-\u001c\u0019\u0005\u00033\ni\u0007\u0005\u0004\u0002\\\u0005\u0015\u0014\u0011N\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005)A/\u001f9fI*\u0019\u00111M\u001b\u0002\u000b\u0005\u001cGo\u001c:\n\t\u0005\u001d\u0014Q\f\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0005\u0003\u0002l\u00055D\u0002\u0001\u0003\f\u0003_:\u0012\u0011!A\u0001\u0006\u0003\t\tHA\u0002`IE\n2!a\u001da!\ri\u0014QO\u0005\u0004\u0003or$a\u0002(pi\"LgnZ\u0001\tg\u0016$H/\u001b8hgB!\u0011QPA@\u001b\u0005\t\u0014bAAAc\ty1\u000b]1o]\u0016\u00148+\u001a;uS:<7\u000f\u0006\u0006\u0002\u0006\u0006\u001d\u0015\u0011RAF\u0003+\u0003\"!O\n\t\r\u0005]\u0012\u00041\u0001X\u0011\u001d\tI$\u0007a\u0001\u0003{Aq!!\u0016\u001a\u0001\u0004\ti\t\r\u0003\u0002\u0010\u0006M\u0005CBA.\u0003K\n\t\n\u0005\u0003\u0002l\u0005ME\u0001DA8\u0003\u0017\u000b\t\u0011!A\u0003\u0002\u0005E\u0004bBA=3\u0001\u0007\u00111P\u0001\b?NL8\u000f^3n+\t\tY\n\r\u0003\u0002\u001e\u0006\u0005\u0006CBA.\u0003K\ny\n\u0005\u0003\u0002l\u0005\u0005FaCA87\u0005\u0005\t\u0011!B\u0001\u0003c\n\u0001bX:zgR,W\u000eI\u0001\u0003K\u000e,\"!!+\u0011\t\u0005-\u0016qV\u0007\u0003\u0003[S1!!\u0004?\u0013\u0011\t\t,!,\u00031\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'/A\u0002fG\u0002\n1\u0001\\8h+\t\tI\f\u0005\u0003\u0002<\u0006\u0015WBAA_\u0015\u0011\ty,!1\u0002\u000bMdg\r\u000e6\u000b\u0005\u0005\r\u0017aA8sO&!\u0011qYA_\u0005\u0019aunZ4fe\u0006!An\\4!\u0003\u0011\u0001xn\u001c7\u0016\u0005\u0005=\u0007CBA.\u0003#\f).\u0003\u0003\u0002T\u0006u#\u0001C!di>\u0014(+\u001a4\u0011\t\u0005]\u0017Q\u001e\b\u0005\u00033\fIO\u0004\u0003\u0002\\\u0006\u001dh\u0002BAo\u0003KtA!a8\u0002d:\u0019\u0011*!9\n\u0003YJ!\u0001N\u001b\n\u0005I\u001a\u0014B\u0001\u00192\u0013\r\tYoL\u0001\f'\u0016\u001c8/[8o!>|G.\u0003\u0003\u0002p\u0006E(aB\"p[6\fg\u000e\u001a\u0006\u0004\u0003W|\u0013!\u00029p_2\u0004\u0013AD:ue\u0016\fW.\u001b8h#V,'/\u001f\u000b\t\u0003s\u0014iC!\r\u0003BAA\u00111 B\u0003\u0005\u0013\u0011y\"\u0004\u0002\u0002~*!\u0011q B\u0001\u0003!\u00198-\u00197bINd'b\u0001B\u0002k\u000511\u000f\u001e:fC6LAAa\u0002\u0002~\n11k\\;sG\u0016\u0004Ra\u0012B\u0006\u0005\u001fI1A!\u0004R\u0005\r\u0019V-\u001d\t\u0005\u0005#\u0011Y\"\u0004\u0002\u0003\u0014)!!Q\u0003B\f\u0003\u0019\u0019HO];di*!!\u0011DA$\u0003!\u0001(o\u001c;pEV4\u0017\u0002\u0002B\u000f\u0005'\u0011QAV1mk\u0016\u0004b!a+\u0003\"\t\u0015\u0012\u0002\u0002B\u0012\u0003[\u0013aAR;ukJ,\u0007\u0003\u0002B\u0014\u0005Si\u0011!N\u0005\u0004\u0005W)$\u0001\u0002#p]\u0016DaAa\f#\u0001\u00049\u0016aA:rY\"I!1\u0007\u0012\u0011\u0002\u0003\u0007!QG\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u000bu\u00129Da\u000f\n\u0007\tebH\u0001\u0004PaRLwN\u001c\t\u0005\u0005#\u0011i$\u0003\u0003\u0003@\tM!AB*ueV\u001cG\u000fC\u0005\u0003D\t\u0002\n\u00111\u0001\u0003F\u0005Q\u0001/\u0019:b[RK\b/Z:\u0011\ra\u00139e\u0016B&\u0013\r\u0011IE\u0018\u0002\u0004\u001b\u0006\u0004\b\u0003BA \u0005\u001bJAAa\u0014\u0002B\t!A+\u001f9f\u0003a\u0019HO]3b[&tw-U;fef$C-\u001a4bk2$HEM\u000b\u0003\u0005+RCA!\u000e\u0003X-\u0012!\u0011\f\t\u0005\u00057\u0012\u0019'\u0004\u0002\u0003^)!!q\fB1\u0003%)hn\u00195fG.,GMC\u0002\u0002.yJAA!\u001a\u0003^\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00021M$(/Z1nS:<\u0017+^3ss\u0012\"WMZ1vYR$3'\u0006\u0002\u0003l)\"!Q\tB,\u0003\u00159(/\u001b;f)\u0011\u0011\tH!\"\u0015\t\tM$1\u0010\t\u0007\u0003W\u0013\tC!\u001e\u0011\u0007u\u00129(C\u0002\u0003zy\u0012A!\u00168ji\"9!QP\u0013A\u0004\t}\u0014aB:fgNLwN\u001c\t\u0005\u0003/\u0014\t)\u0003\u0003\u0003\u0004\u0006E(!\u0004)p_2,GmU3tg&|g\u000eC\u0004\u0003\b\u0016\u0002\rA!#\u0002\u00135,H/\u0019;j_:\u001c\b#B$\u0003\f\t-\u0005\u0003BA \u0005\u001bKAAa$\u0002B\tAQ*\u001e;bi&|g.A\bfq\u0016\u001cW\u000f^3CCR\u001c\u0007\u000eR7m)\u0011\u0011)J!)\u0015\t\t]%q\u0014\t\u0007\u0003W\u0013\tC!'\u0011\t\u0005}\"1T\u0005\u0005\u0005;\u000b\tEA\fFq\u0016\u001cW\u000f^3CCR\u001c\u0007\u000eR7m%\u0016\u001c\bo\u001c8tK\"9!Q\u0010\u0014A\u0004\t}\u0004b\u0002BRM\u0001\u0007!QU\u0001\u000bgR\fG/Z7f]R\u001c\b#B$\u0003(\n-\u0016b\u0001BU#\n!A*[:u!!i$QV,\u0003<\t\u0015\u0013b\u0001BX}\t1A+\u001e9mKN\nA\"\u001a=fGV$X-U;fef$\u0002B!.\u0003B\n\r'Q\u0019\u000b\u0005\u0005o\u0013y\f\u0005\u0004\u0002,\n\u0005\"\u0011\u0018\t\u0005\u0003\u007f\u0011Y,\u0003\u0003\u0003>\u0006\u0005#!\u0003*fgVdGoU3u\u0011\u001d\u0011ih\na\u0002\u0005\u007fBaAa\f(\u0001\u00049\u0006b\u0002B\u001aO\u0001\u0007!1\b\u0005\b\u0005\u0007:\u0003\u0019\u0001B#\u0003-9\u0018\u000e\u001e5TKN\u001c\u0018n\u001c8\u0016\t\t-'\u0011\u001b\u000b\u0005\u0005\u001b\u0014)\u000e\u0005\u0004\u0002,\n\u0005\"q\u001a\t\u0005\u0003W\u0012\t\u000eB\u0004\u0003T\"\u0012\r!!\u001d\u0003\u0003QCqAa6)\u0001\u0004\u0011I.A\u0001g!\u001di$1\u001cB@\u0005\u001bL1A!8?\u0005%1UO\\2uS>t\u0017'\u0001\u0005tQV$Hm\\<o)\t\u0011y\"\u0001\rsK2,\u0017m]3TKN\u001c\u0018n\u001c8P]\u000e{W\u000e\u001d7fi\u0016,BAa:\u0003nR1!\u0011\u001eBx\u0005c\u0004b!a+\u0003\"\t-\b\u0003BA6\u0005[$qAa5+\u0005\u0004\t\t\bC\u0004\u0003X*\u0002\rA!;\t\u000f\tM(\u00061\u0001\u0002 \u0005I1/Z:tS>t\u0017\nZ\u0001\u0011o&$\bn\u0016:ji\u0016\u0014V\r\u001e:jKN,BA!?\u0004\u0002Q!!1`B\u0003)\u0011\u0011ipa\u0001\u0011\r\u0005-&\u0011\u0005B\u0000!\u0011\tYg!\u0001\u0005\u000f\tM7F1\u0001\u0002r!9!QP\u0016A\u0004\t}\u0004b\u0002BlW\u0001\u00071q\u0001\t\u0006{\r%!Q`\u0005\u0004\u0007\u0017q$!\u0003$v]\u000e$\u0018n\u001c81\u0003)9W\r^*fgNLwN\u001c\u000b\u0005\u0007#\u0019\u0019\u0002\u0005\u0004\u0002,\n\u0005\"q\u0010\u0005\b\u0007+a\u0003\u0019AA\u0010\u0003-\u0019Xm]:j_:,V/\u001b3\u0002\u0015\r\u0014X-\u0019;f!>|G\u000e\u0006\u0002\u0002P\"\u001a1#a\n")
@InternalStableApi
public class SpannerGrpcClient {
    private final String name;
    private final SpannerClient client;
    private final ActorSystem<?> system;
    private final SpannerSettings settings;
    private final ActorSystem<?> _system;
    private final ExecutionContextExecutor ec;
    private final Logger akka$persistence$spanner$internal$SpannerGrpcClient$$log;
    private final ActorRef<SessionPool.Command> pool;

    public static PoolShuttingException PoolShuttingDownException() {
        return SpannerGrpcClient$.MODULE$.PoolShuttingDownException();
    }

    public static PoolBusyException PoolBusyException() {
        return SpannerGrpcClient$.MODULE$.PoolBusyException();
    }

    public SpannerClient client() {
        return this.client;
    }

    private ActorSystem<?> _system() {
        return this._system;
    }

    private ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Logger akka$persistence$spanner$internal$SpannerGrpcClient$$log() {
        return this.akka$persistence$spanner$internal$SpannerGrpcClient$$log;
    }

    private ActorRef<SessionPool.Command> pool() {
        return this.pool;
    }

    public Source<Seq<Value>, Future<Done>> streamingQuery(String sql, Option<Struct> params, Map<String, Type> paramTypes) {
        long sessionId = SpannerGrpcClient$.MODULE$.akka$persistence$spanner$internal$SpannerGrpcClient$$nextSessionId();
        Future result = this.getSession(sessionId).map((Function1 & Serializable)session -> {
            if (this.akka$persistence$spanner$internal$SpannerGrpcClient$$log().isTraceEnabled()) {
                package.LoggerOps$.MODULE$.traceN$extension(package$.MODULE$.LoggerOps(this.akka$persistence$spanner$internal$SpannerGrpcClient$$log()), "streamingQuery, session id [{}], query: [{}], params: [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)session.id()), sql, params}));
            }
            String x$1 = session.session().name();
            String x$2 = sql;
            Option x$3 = params;
            Map x$4 = paramTypes;
            Option<TransactionSelector> x$5 = ExecuteSqlRequest$.MODULE$.apply$default$2();
            ByteString x$6 = ExecuteSqlRequest$.MODULE$.apply$default$6();
            ExecuteSqlRequest.QueryMode x$7 = ExecuteSqlRequest$.MODULE$.apply$default$7();
            ByteString x$8 = ExecuteSqlRequest$.MODULE$.apply$default$8();
            long x$9 = ExecuteSqlRequest$.MODULE$.apply$default$9();
            Option<ExecuteSqlRequest.QueryOptions> x$10 = ExecuteSqlRequest$.MODULE$.apply$default$10();
            UnknownFieldSet x$11 = ExecuteSqlRequest$.MODULE$.apply$default$11();
            return this.client().executeStreamingSql(new ExecuteSqlRequest(x$1, x$5, x$2, (Option<Struct>)x$3, (Map<String, Type>)x$4, x$6, x$7, x$8, x$9, x$10, x$11)).via((Graph)RowCollector$.MODULE$);
        }, (ExecutionContext)this.ec());
        return (Source)Source$.MODULE$.futureSource(result).watchTermination((Function2 & Serializable)(x$1, terminationFuture) -> this.releaseSessionOnComplete((Future)terminationFuture, sessionId));
    }

    public Option<Struct> streamingQuery$default$2() {
        return None$.MODULE$;
    }

    public Map<String, Type> streamingQuery$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public Future<BoxedUnit> write(Seq<Mutation> mutations, SessionPool.PooledSession session) {
        return this.withWriteRetries((Function0 & Serializable)() -> this.client().commit(new CommitRequest(session.session().name(), new CommitRequest.Transaction.SingleUseTransaction(new TransactionOptions(new TransactionOptions.Mode.ReadWrite(new TransactionOptions.ReadWrite(TransactionOptions$ReadWrite$.MODULE$.apply$default$1())), TransactionOptions$.MODULE$.apply$default$2())), mutations, CommitRequest$.MODULE$.apply$default$4())), session).map(ConstantFun$.MODULE$.scalaAnyToUnit(), ExecutionContexts$.MODULE$.parasitic());
    }

    public Future<ExecuteBatchDmlResponse> executeBatchDml(List<Tuple3<String, Struct, Map<String, Type>>> statements, SessionPool.PooledSession session) {
        return this.withWriteRetries((Function0 & Serializable)() -> this.client().beginTransaction(new BeginTransactionRequest(session.session().name(), (Option<TransactionOptions>)new Some((Object)new TransactionOptions(new TransactionOptions.Mode.ReadWrite(new TransactionOptions.ReadWrite(TransactionOptions$ReadWrite$.MODULE$.apply$default$1())), TransactionOptions$.MODULE$.apply$default$2())), BeginTransactionRequest$.MODULE$.apply$default$3())).flatMap((Function1 & Serializable)transaction -> this.client().executeBatchDml(SpannerGrpcClient.createBatchDmlRequest$1(session.session().name(), transaction.id(), statements)).map((Function1 & Serializable)resultSet -> {
            ExecuteBatchDmlResponse executeBatchDmlResponse;
            Some some;
            com.google.rpc.Status status;
            Option<com.google.rpc.Status> option = resultSet.status();
            if (option instanceof Some && (status = (com.google.rpc.Status)(some = (Some)option).value()).code() != Code$OK$.MODULE$.index()) {
                this.akka$persistence$spanner$internal$SpannerGrpcClient$$log().warn("Transaction failed with status {}", resultSet.status());
                throw new TransactionFailed(status.code(), status.message(), status.details());
            }
            if (this.akka$persistence$spanner$internal$SpannerGrpcClient$$log().isTraceEnabled()) {
                package.LoggerOps$.MODULE$.traceN$extension(package$.MODULE$.LoggerOps(this.akka$persistence$spanner$internal$SpannerGrpcClient$$log()), "executeBatchDml, session: [{}] status: [{}], resultSets: [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)session.id()), option, resultSet.resultSets()}));
            }
            ExecuteBatchDmlResponse x$2 = executeBatchDmlResponse = resultSet;
            return new Tuple2(resultSet, (Object)x$2);
        }, (ExecutionContext)this.ec()).flatMap((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ExecuteBatchDmlResponse resultSet = (ExecuteBatchDmlResponse)tuple2._1();
            Future future = this.client().commit(new CommitRequest(session.session().name(), new CommitRequest.Transaction.TransactionId(transaction.id()), CommitRequest$.MODULE$.apply$default$3(), CommitRequest$.MODULE$.apply$default$4())).map((Function1 & Serializable)commitResponse -> {
                this.akka$persistence$spanner$internal$SpannerGrpcClient$$log().trace("Successful commit at {}", (Object)commitResponse.commitTimestamp().map((Function1 & Serializable)t -> new Tuple2.mcJI.sp(t.seconds(), t.nanos())));
                return resultSet;
            }, (ExecutionContext)this.ec());
            return future;
        }, (ExecutionContext)this.ec()), (ExecutionContext)this.ec()), session);
    }

    public Future<ResultSet> executeQuery(String sql, Struct params, Map<String, Type> paramTypes, SessionPool.PooledSession session) {
        String x$1 = session.session().name();
        String x$2 = sql;
        Some x$3 = new Some((Object)params);
        Map<String, Type> x$4 = paramTypes;
        Option<TransactionSelector> x$5 = ExecuteSqlRequest$.MODULE$.apply$default$2();
        ByteString x$6 = ExecuteSqlRequest$.MODULE$.apply$default$6();
        ExecuteSqlRequest.QueryMode x$7 = ExecuteSqlRequest$.MODULE$.apply$default$7();
        ByteString x$8 = ExecuteSqlRequest$.MODULE$.apply$default$8();
        long x$9 = ExecuteSqlRequest$.MODULE$.apply$default$9();
        Option<ExecuteSqlRequest.QueryOptions> x$10 = ExecuteSqlRequest$.MODULE$.apply$default$10();
        UnknownFieldSet x$11 = ExecuteSqlRequest$.MODULE$.apply$default$11();
        return this.client().executeSql(new ExecuteSqlRequest(x$1, x$5, x$2, (Option<Struct>)x$3, x$4, x$6, x$7, x$8, x$9, x$10, x$11));
    }

    public <T> Future<T> withSession(Function1<SessionPool.PooledSession, Future<T>> f) {
        long sessionId = SpannerGrpcClient$.MODULE$.akka$persistence$spanner$internal$SpannerGrpcClient$$nextSessionId();
        Future result = this.getSession(sessionId).flatMap(f, (ExecutionContext)this.ec());
        return this.releaseSessionOnComplete(result, sessionId);
    }

    public Future<Done> shutdown() {
        Promise done = Promise$.MODULE$.apply();
        ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(this.pool()), (Object)new SessionPool.Shutdown((Promise<Done>)done));
        return done.future();
    }

    private <T> Future<T> releaseSessionOnComplete(Future<T> f, long sessionId) {
        f.onComplete((Function1 & Serializable)x0$1 -> {
            SpannerGrpcClient.$anonfun$releaseSessionOnComplete$1(this, sessionId, x0$1);
            return BoxedUnit.UNIT;
        }, ExecutionContexts$.MODULE$.parasitic());
        return f;
    }

    private <T> Future<T> withWriteRetries(Function0<Future<T>> f, SessionPool.PooledSession session) {
        Deadline deadLine = this.settings.maxWriteRetryTimeout().fromNow();
        return this.akka$persistence$spanner$internal$SpannerGrpcClient$$tryWrite$1(this.settings.maxWriteRetries(), f, deadLine, session);
    }

    public Future<SessionPool.PooledSession> getSession(long sessionUuid) {
        Timeout timeout = new Timeout(this.settings.sessionAcquisitionTimeout());
        return AskPattern.Askable$.MODULE$.ask$extension(AskPattern$.MODULE$.Askable(this.pool()), (Function1 & Serializable)replyTo -> new SessionPool.GetSession((ActorRef<SessionPool.Response>)replyTo, sessionUuid), timeout, AskPattern$.MODULE$.schedulerFromActorSystem(this._system())).transform((Function1 & Serializable)x0$1 -> {
            SessionPool.Response response;
            SessionPool.Response response2;
            boolean bl = false;
            Success success = null;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                SessionPool.Response pt = (SessionPool.Response)success.value();
                if (pt instanceof SessionPool.PooledSession) {
                    SessionPool.PooledSession pooledSession = (SessionPool.PooledSession)pt;
                    this.akka$persistence$spanner$internal$SpannerGrpcClient$$log().trace("Acquired session [{}]", (Object)BoxesRunTime.boxToLong((long)pooledSession.id()));
                    return new Success((Object)pooledSession);
                }
            }
            if (bl && (response2 = (SessionPool.Response)success.value()) instanceof SessionPool.PoolBusy) {
                return new Failure((Throwable)SpannerGrpcClient$.MODULE$.PoolBusyException());
            }
            if (bl && (response = (SessionPool.Response)success.value()) instanceof SessionPool.PoolShuttingDown) {
                return new Failure((Throwable)SpannerGrpcClient$.MODULE$.PoolShuttingDownException());
            }
            if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            return new Failure(t);
        }, ExecutionContexts$.MODULE$.parasitic());
    }

    public ActorRef<SessionPool.Command> createPool() {
        return this.system.systemActorOf(Behaviors.Supervise$.MODULE$.onFailure$extension(Behaviors$.MODULE$.supervise(SessionPool$.MODULE$.apply(this.client(), this.settings)), (SupervisorStrategy)SupervisorStrategy$.MODULE$.restartWithBackoff(this.settings.sessionPool().restartMinBackoff(), this.settings.sessionPool().restartMaxBackoff(), 0.1), ClassTag$.MODULE$.Nothing()), new StringBuilder(13).append(this.name).append("-session-pool").toString(), this.system.systemActorOf$default$3());
    }

    private static final ExecuteBatchDmlRequest createBatchDmlRequest$1(String sessionId, ByteString transactionId, List statements$1) {
        List s = statements$1.map((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String sql = (String)tuple3._1();
            Struct params = (Struct)tuple3._2();
            Map types = (Map)tuple3._3();
            ExecuteBatchDmlRequest.Statement statement = new ExecuteBatchDmlRequest.Statement(sql, (Option<Struct>)new Some((Object)params), (Map<String, Type>)types, ExecuteBatchDmlRequest$Statement$.MODULE$.apply$default$4());
            return statement;
        });
        return new ExecuteBatchDmlRequest(sessionId, (Option<TransactionSelector>)new Some((Object)new TransactionSelector(new TransactionSelector.Selector.Id(transactionId), TransactionSelector$.MODULE$.apply$default$2())), (Seq<ExecuteBatchDmlRequest.Statement>)s, ExecuteBatchDmlRequest$.MODULE$.apply$default$4(), ExecuteBatchDmlRequest$.MODULE$.apply$default$5());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$releaseSessionOnComplete$1(SpannerGrpcClient $this, long sessionId$2, Try x0$1) {
        Throwable t;
        Throwable t2;
        boolean bl = false;
        Failure failure = null;
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            $this.akka$persistence$spanner$internal$SpannerGrpcClient$$log().trace("Operation successful, releasing session [{}]", (Object)BoxesRunTime.boxToLong((long)sessionId$2));
            $this.pool().tell((Object)new SessionPool.ReleaseSession(sessionId$2, false));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable throwable = failure.exception();
            PoolBusyException poolBusyException = SpannerGrpcClient$.MODULE$.PoolBusyException();
            Throwable throwable2 = throwable;
            if (!(poolBusyException != null ? !poolBusyException.equals(throwable2) : throwable2 != null)) {
                $this.akka$persistence$spanner$internal$SpannerGrpcClient$$log().debug("Acquiring session, pool busy");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && (t2 = failure.exception()) instanceof TimeoutException) {
            TimeoutException timeoutException = (TimeoutException)t2;
            $this.akka$persistence$spanner$internal$SpannerGrpcClient$$log().debug(new StringBuilder(41).append("Acquiring session timed out. Session id: ").append(sessionId$2).toString(), (Object)timeoutException.getMessage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (bl && (t = failure.exception()) instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)t;
            Status.Code code = statusRuntimeException.getStatus().getCode();
            Status.Code code2 = SessionDeleted$.MODULE$.statusCode();
            if (!(code != null ? !code.equals(code2) : code2 != null)) {
                $this.akka$persistence$spanner$internal$SpannerGrpcClient$$log().warn("User session failed with possible session not found. Re-creating session. Message: {}", (Object)statusRuntimeException.getMessage());
                $this.pool().tell((Object)new SessionPool.ReleaseSession(sessionId$2, true));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable t3 = failure.exception();
        $this.akka$persistence$spanner$internal$SpannerGrpcClient$$log().debug("User query failed: {}. Returning session [{}]", (Object)t3.getMessage(), (Object)BoxesRunTime.boxToLong((long)sessionId$2));
        $this.pool().tell((Object)new SessionPool.ReleaseSession(sessionId$2, false));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public final Future akka$persistence$spanner$internal$SpannerGrpcClient$$tryWrite$1(int retriesLeft, Function0 f$1, Deadline deadLine$1, SessionPool.PooledSession session$3) {
        return ((Future)f$1.apply()).recoverWith((PartialFunction)new Serializable(this, retriesLeft, deadLine$1, session$3, f$1){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SpannerGrpcClient $outer;
            private final int retriesLeft$1;
            private final Deadline deadLine$1;
            private final SessionPool.PooledSession session$3;
            private final Function0 f$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StatusRuntimeException) {
                    StatusRuntimeException statusRuntimeException = (StatusRuntimeException)A1;
                    Status status = statusRuntimeException.getStatus();
                    Status status2 = Status.ABORTED;
                    if (!(status != null ? !status.equals(status2) : status2 != null)) {
                        if (this.retriesLeft$1 > 0 && this.deadLine$1.hasTimeLeft()) {
                            this.$outer.akka$persistence$spanner$internal$SpannerGrpcClient$$log().debug("Write failed for [{}], retrying", (Object)BoxesRunTime.boxToLong((long)this.session$3.id()));
                            object = this.$outer.akka$persistence$spanner$internal$SpannerGrpcClient$$tryWrite$1(this.retriesLeft$1 - 1, this.f$1, this.deadLine$1, this.session$3);
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (!(throwable instanceof StatusRuntimeException)) return false;
                StatusRuntimeException statusRuntimeException = (StatusRuntimeException)throwable;
                Status status = statusRuntimeException.getStatus();
                Status status2 = Status.ABORTED;
                if (status == null) {
                    if (status2 != null) {
                        return false;
                    }
                } else if (!status.equals(status2)) return false;
                if (this.retriesLeft$1 <= 0) return false;
                if (!this.deadLine$1.hasTimeLeft()) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.retriesLeft$1 = retriesLeft$1;
                this.deadLine$1 = deadLine$1;
                this.session$3 = session$3;
                this.f$1 = f$1;
            }
        }, (ExecutionContext)this.ec());
    }

    public SpannerGrpcClient(String name, SpannerClient client, ActorSystem<?> system, SpannerSettings settings) {
        this.name = name;
        this.client = client;
        this.system = system;
        this.settings = settings;
        this._system = system;
        this.ec = system.executionContext();
        this.akka$persistence$spanner$internal$SpannerGrpcClient$$log = LoggerFactory.getLogger(SpannerGrpcClient.class);
        this.pool = this.createPool();
    }

    public static final class PoolBusyException
    extends RuntimeException
    implements NoStackTrace {
        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public PoolBusyException() {
            super("Session pool busy");
            NoStackTrace.$init$((NoStackTrace)this);
        }
    }

    public static final class PoolShuttingException
    extends RuntimeException
    implements NoStackTrace {
        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public PoolShuttingException() {
            super("Session pool shutting down");
            NoStackTrace.$init$((NoStackTrace)this);
        }
    }

    public static final class TransactionFailed
    extends RuntimeException {
        public TransactionFailed(int code, String message, Object details) {
            super(new StringBuilder(26).append("Code ").append(code).append(". Message: ").append(message).append(". Params: ").append(details).toString());
        }
    }
}

