/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.spanner.internal;

import akka.Done;
import akka.Done$;
import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorRef$;
import akka.actor.typed.Behavior;
import akka.actor.typed.scaladsl.ActorContext;
import akka.actor.typed.scaladsl.Behaviors$;
import akka.actor.typed.scaladsl.StashBuffer;
import akka.actor.typed.scaladsl.TimerScheduler;
import akka.annotation.InternalApi;
import akka.persistence.spanner.SpannerSettings;
import akka.persistence.spanner.internal.SessionPool;
import akka.persistence.spanner.internal.SessionPool$KeepAlive$;
import akka.persistence.spanner.internal.SessionPool$ShutdownTimeout$;
import akka.persistence.spanner.internal.SessionPool$Stats$;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BatchCreateSessionsRequest$;
import com.google.spanner.v1.BatchCreateSessionsResponse;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.DeleteSessionRequest$;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.SpannerClient;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scalapb.UnknownFieldSet;

@InternalApi
public final class SessionPool$ {
    public static final SessionPool$ MODULE$ = new SessionPool$();

    public Behavior<SessionPool.Command> apply(SpannerClient client, SpannerSettings settings) {
        return Behaviors$.MODULE$.withStash(settings.sessionPool().maxOutstandingRequests(), (Function1 & Serializable)stash -> Behaviors$.MODULE$.withTimers((Function1 & Serializable)timers -> Behaviors$.MODULE$.setup((Function1 & Serializable)ctx -> {
            ctx.log().info("Creating pool. Max size [{}]. Max outstanding requests [{}].", (Object)BoxesRunTime.boxToInteger((int)settings.sessionPool().maxSize()), (Object)BoxesRunTime.boxToInteger((int)settings.sessionPool().maxOutstandingRequests()));
            SessionPool$.createSessions$1(ctx, settings, client);
            return Behaviors$.MODULE$.receiveMessage((Function1 & Serializable)x0$1 -> {
                Behavior behavior;
                SessionPool.Command command = x0$1;
                if (command instanceof SessionPool.InitialSessions) {
                    SessionPool.InitialSessions initialSessions = (SessionPool.InitialSessions)command;
                    List<Session> sessions = initialSessions.sessions();
                    ctx.log().debug("Sessions created [{}]", sessions);
                    timers.startTimerWithFixedDelay((Object)SessionPool$KeepAlive$.MODULE$, settings.sessionPool().keepAliveInterval());
                    settings.sessionPool().statsInternal().foreach((Function1 & Serializable)duration -> {
                        timers.startTimerWithFixedDelay((Object)SessionPool$Stats$.MODULE$, duration);
                        return BoxedUnit.UNIT;
                    });
                    behavior = stash.unstashAll((Behavior)new SessionPool(client, sessions, (ActorContext<SessionPool.Command>)ctx, (TimerScheduler<SessionPool.Command>)timers, settings));
                } else if (command instanceof SessionPool.RetrySessionCreation) {
                    FiniteDuration when;
                    SessionPool.RetrySessionCreation retrySessionCreation = (SessionPool.RetrySessionCreation)command;
                    FiniteDuration finiteDuration = when = retrySessionCreation.in();
                    FiniteDuration finiteDuration2 = Duration$.MODULE$.Zero();
                    if (!(finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null)) {
                        ctx.log().debug("Retrying session creation");
                        SessionPool$.createSessions$1(ctx, settings, client);
                    } else {
                        timers.startSingleTimer((Object)new SessionPool.RetrySessionCreation(Duration$.MODULE$.Zero()), when);
                    }
                    behavior = Behaviors$.MODULE$.same();
                } else if (command instanceof SessionPool.GetSession) {
                    StashBuffer stashBuffer;
                    SessionPool.GetSession getSession = (SessionPool.GetSession)command;
                    ActorRef<SessionPool.Response> replyTo = getSession.replyTo();
                    long id = getSession.id();
                    if (stash.isFull()) {
                        ctx.log().warn("Session pool request stash full, denying request for pool while starting up");
                        ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(replyTo), (Object)new SessionPool.PoolBusy(id));
                        stashBuffer = BoxedUnit.UNIT;
                    } else {
                        stashBuffer = stash.stash((Object)getSession);
                    }
                    behavior = Behaviors$.MODULE$.same();
                } else {
                    stash.stash((Object)command);
                    behavior = Behaviors$.MODULE$.same();
                }
                return behavior;
            });
        })));
    }

    public Behavior<SessionPool.Command> shuttingDown(Promise<Done> done, SpannerClient client, List<Session> idleSessions, Map<Object, Session> remainingSessions) {
        return Behaviors$.MODULE$.setup((Function1 & Serializable)ctx -> Behaviors$.MODULE$.receiveMessagePartial((PartialFunction)new Serializable((Map)remainingSessions, (List)idleSessions, (ActorContext)ctx, (Promise)done, client){
            private static final long serialVersionUID = 0L;
            private final Map remainingSessions$1;
            private final List idleSessions$1;
            private final ActorContext ctx$2;
            private final Promise done$1;
            private final SpannerClient client$2;

            public final <A1 extends SessionPool.Command, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Behavior behavior;
                A1 A1 = x1;
                if (A1 instanceof SessionPool.GetSession) {
                    SessionPool.GetSession getSession = (SessionPool.GetSession)A1;
                    ActorRef<SessionPool.Response> replyTo = getSession.replyTo();
                    long id = getSession.id();
                    ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(replyTo), (Object)new SessionPool.PoolShuttingDown(id));
                    behavior = Behaviors$.MODULE$.same();
                } else if (A1 instanceof SessionPool.ReleaseSession) {
                    Behavior behavior2;
                    SessionPool.ReleaseSession releaseSession = (SessionPool.ReleaseSession)A1;
                    long id = releaseSession.id();
                    List newSessions = (List)this.remainingSessions$1.get((Object)BoxesRunTime.boxToLong((long)id)).toList().$plus$plus((IterableOnce)this.idleSessions$1);
                    Map newRemaining = (Map)this.remainingSessions$1.$minus((Object)BoxesRunTime.boxToLong((long)id));
                    if (newRemaining.isEmpty()) {
                        if (this.ctx$2.log().isInfoEnabled()) {
                            this.ctx$2.log().info("All sessions returned. Shutting down [{}] sessions.", (Object)BoxesRunTime.boxToInteger((int)newSessions.size()));
                        }
                        this.done$1.completeWith(SessionPool$.MODULE$.akka$persistence$spanner$internal$SessionPool$$cleanupOldSessions(this.client$2, (List<Session>)newSessions, (ExecutionContext)this.ctx$2.executionContext()));
                        behavior2 = Behaviors$.MODULE$.stopped();
                    } else {
                        this.ctx$2.log().info("Still waiting on [{}] sessions to return", (Object)BoxesRunTime.boxToInteger((int)newRemaining.size()));
                        behavior2 = SessionPool$.MODULE$.shuttingDown((Promise<Done>)this.done$1, this.client$2, (List<Session>)newSessions, (Map<Object, Session>)newRemaining);
                    }
                    behavior = behavior2;
                } else if (SessionPool$ShutdownTimeout$.MODULE$.equals(A1)) {
                    List toShutdown = (List)this.idleSessions$1.$plus$plus((IterableOnce)this.remainingSessions$1.values());
                    if (this.ctx$2.log().isInfoEnabled()) {
                        this.ctx$2.log().info("Timed out waiting for sessions to be returned. Shutting down [{}] sessions now. Remaining sessions [{}]", (Object)this.remainingSessions$1.valuesIterator().map((Function1 & Serializable)x$1 -> x$1.name()).mkString(", "));
                    }
                    this.done$1.completeWith(SessionPool$.MODULE$.akka$persistence$spanner$internal$SessionPool$$cleanupOldSessions(this.client$2, (List<Session>)toShutdown, (ExecutionContext)this.ctx$2.executionContext()));
                    behavior = Behaviors$.MODULE$.stopped();
                } else {
                    behavior = function1.apply(x1);
                }
                return (B1)behavior;
            }

            public final boolean isDefinedAt(SessionPool.Command x1) {
                SessionPool.Command command = x1;
                boolean bl = command instanceof SessionPool.GetSession ? true : (command instanceof SessionPool.ReleaseSession ? true : SessionPool$ShutdownTimeout$.MODULE$.equals(command));
                return bl;
            }
            {
                this.remainingSessions$1 = remainingSessions$1;
                this.idleSessions$1 = idleSessions$1;
                this.ctx$2 = ctx$2;
                this.done$1 = done$1;
                this.client$2 = client$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.google.spanner.v1.Session )}, serializedLambda);
            }
        }));
    }

    public Future<Done> akka$persistence$spanner$internal$SessionPool$$cleanupOldSessions(SpannerClient client, List<Session> sessions, ExecutionContext ec) {
        return Future$.MODULE$.sequence((IterableOnce)sessions.map((Function1 & Serializable)session -> client.deleteSession(new DeleteSessionRequest(session.name(), DeleteSessionRequest$.MODULE$.apply$default$2()))), BuildFrom$.MODULE$.buildFromIterableOps(), ec).map((Function1 & Serializable)x$2 -> Done$.MODULE$, ec);
    }

    private static final void createSessions$1(ActorContext ctx$1, SpannerSettings settings$1, SpannerClient client$1) {
        ctx$1.log().debug("Creating sessions, database [{}], pool size [{}]", (Object)settings$1.fullyQualifiedDatabase(), (Object)BoxesRunTime.boxToInteger((int)settings$1.sessionPool().maxSize()));
        String x$1 = settings$1.fullyQualifiedDatabase();
        int x$2 = settings$1.sessionPool().maxSize();
        Option<Session> x$3 = BatchCreateSessionsRequest$.MODULE$.apply$default$2();
        UnknownFieldSet x$4 = BatchCreateSessionsRequest$.MODULE$.apply$default$4();
        ctx$1.pipeToSelf(client$1.batchCreateSessions(new BatchCreateSessionsRequest(x$1, x$3, x$2, x$4)), (Function1 & Serializable)x0$1 -> {
            Product product;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                BatchCreateSessionsResponse response = (BatchCreateSessionsResponse)success.value();
                product = new SessionPool.InitialSessions((List<Session>)response.session().toList());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                ctx$1.log().warn("Session creation failed. Retrying ", t);
                product = new SessionPool.RetrySessionCreation(settings$1.sessionPool().retryCreateInterval());
            } else {
                throw new MatchError((Object)try_);
            }
            return product;
        });
    }

    private SessionPool$() {
    }
}

