/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.spanner.internal;

import akka.actor.typed.scaladsl.package;
import akka.actor.typed.scaladsl.package$;
import akka.annotation.InternalApi;
import akka.stream.Attributes;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import com.google.protobuf.struct.ListValue;
import com.google.protobuf.struct.ListValue$;
import com.google.protobuf.struct.Value;
import com.google.protobuf.struct.Value$;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class RowCollector$
extends GraphStage<FlowShape<PartialResultSet, Seq<Value>>> {
    public static final RowCollector$ MODULE$ = new RowCollector$();
    private static final Logger akka$persistence$spanner$internal$RowCollector$$log = LoggerFactory.getLogger((Class)MODULE$.getClass());
    private static final Inlet<PartialResultSet> in = Inlet$.MODULE$.apply("RowCollector.in");
    private static final Outlet<Seq<Value>> out = Outlet$.MODULE$.apply("RowCollector.out");
    private static final int akka$persistence$spanner$internal$RowCollector$$MetadataNotSeenYet = -1;
    private static final FlowShape<PartialResultSet, Seq<Value>> shape = new FlowShape(MODULE$.in(), MODULE$.out());

    public Logger akka$persistence$spanner$internal$RowCollector$$log() {
        return akka$persistence$spanner$internal$RowCollector$$log;
    }

    public Inlet<PartialResultSet> in() {
        return in;
    }

    public Outlet<Seq<Value>> out() {
        return out;
    }

    public int akka$persistence$spanner$internal$RowCollector$$MetadataNotSeenYet() {
        return akka$persistence$spanner$internal$RowCollector$$MetadataNotSeenYet;
    }

    public FlowShape<PartialResultSet, Seq<Value>> shape() {
        return shape;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(){
            private Seq<Value> incompleteRow;
            private boolean incompleteChunked;
            private int columnsPerRow;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
            }

            public void onUpstreamFinish() throws Exception {
                InHandler.onUpstreamFinish$((InHandler)this);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
            }

            private Seq<Value> incompleteRow() {
                return this.incompleteRow;
            }

            private void incompleteRow_$eq(Seq<Value> x$1) {
                this.incompleteRow = x$1;
            }

            private boolean incompleteChunked() {
                return this.incompleteChunked;
            }

            private void incompleteChunked_$eq(boolean x$1) {
                this.incompleteChunked = x$1;
            }

            private int columnsPerRow() {
                return this.columnsPerRow;
            }

            private void columnsPerRow_$eq(int x$1) {
                this.columnsPerRow = x$1;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onPush() {
                PartialResultSet currentSet = (PartialResultSet)this.grab(RowCollector$.MODULE$.in());
                if (RowCollector$.MODULE$.akka$persistence$spanner$internal$RowCollector$$log().isTraceEnabled()) {
                    package.LoggerOps$.MODULE$.traceN$extension(package$.MODULE$.LoggerOps(RowCollector$.MODULE$.akka$persistence$spanner$internal$RowCollector$$log()), "Chunk push, metadata seen: [{}], incompleteRows: [{}], incompleteChunked: [{}], columnsPerRow: [{}], result set metadata: [{}], result set values [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((this.columnsPerRow() != RowCollector$.MODULE$.akka$persistence$spanner$internal$RowCollector$$MetadataNotSeenYet() ? 1 : 0) != 0), new OptionVal(this.incompleteRow()), BoxesRunTime.boxToBoolean((boolean)this.incompleteChunked()), BoxesRunTime.boxToInteger((int)this.columnsPerRow()), currentSet.metadata(), currentSet.values()}));
                }
                if (this.columnsPerRow() == RowCollector$.MODULE$.akka$persistence$spanner$internal$RowCollector$$MetadataNotSeenYet()) {
                    this.columnsPerRow_$eq(((StructType)((ResultSetMetadata)currentSet.metadata().get()).rowType().get()).fields().size());
                }
                if (currentSet.values().nonEmpty()) {
                    Seq<Value> seq = this.incompleteRow();
                    OptionVal$.MODULE$.None();
                    Seq<Value> seq2 = seq;
                    if (!(null != null ? !((Object)null).equals(seq2) : seq2 != null)) {
                        BoxedUnit boxedUnit;
                        Seq rows = currentSet.values().grouped(this.columnsPerRow()).toSeq();
                        if (((SeqOps)rows.last()).size() == this.columnsPerRow() && !currentSet.chunkedValue()) {
                            this.emitMultiple(RowCollector$.MODULE$.out(), rows.iterator());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.incompleteChunked_$eq(currentSet.chunkedValue());
                            this.incompleteRow_$eq((Seq<Value>)((Seq)OptionVal.Some$.MODULE$.apply(rows.last())));
                            Seq initial = (Seq)rows.init();
                            if (initial.nonEmpty()) {
                                this.emitMultiple(RowCollector$.MODULE$.out(), initial.iterator());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.pull(RowCollector$.MODULE$.in());
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    } else {
                        BoxedUnit boxedUnit;
                        Seq seq3;
                        if (new OptionVal(seq) == null || OptionVal$.MODULE$.isEmpty$extension((Object)(seq3 = (Seq)OptionVal.Some$.MODULE$.unapply(seq)))) throw new MatchError((Object)new OptionVal(seq));
                        Seq incomplete = (Seq)OptionVal$.MODULE$.get$extension((Object)seq3);
                        if (this.incompleteChunked()) {
                            Seq<Value> combined = RowCollector$.MODULE$.recombine((Seq<Value>)incomplete, currentSet.values());
                            Seq rows = combined.grouped(this.columnsPerRow()).toSeq();
                            if (((SeqOps)rows.last()).size() == this.columnsPerRow() && !currentSet.chunkedValue()) {
                                OptionVal$.MODULE$.None();
                                this.incompleteRow_$eq(null);
                                this.emitMultiple(RowCollector$.MODULE$.out(), rows.iterator());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.incompleteChunked_$eq(currentSet.chunkedValue());
                                this.incompleteRow_$eq((Seq<Value>)((Seq)OptionVal.Some$.MODULE$.apply(rows.last())));
                                Seq initial = (Seq)rows.init();
                                if (initial.nonEmpty()) {
                                    this.emitMultiple(RowCollector$.MODULE$.out(), initial.iterator());
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    this.pull(RowCollector$.MODULE$.in());
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                        } else {
                            Seq rows = ((IterableOps)incomplete.$plus$plus(currentSet.values())).grouped(this.columnsPerRow()).toSeq();
                            if (((SeqOps)rows.last()).size() == this.columnsPerRow() && !currentSet.chunkedValue()) {
                                OptionVal$.MODULE$.None();
                                this.incompleteRow_$eq(null);
                                this.emitMultiple(RowCollector$.MODULE$.out(), rows.iterator());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.incompleteChunked_$eq(currentSet.chunkedValue());
                                this.incompleteRow_$eq((Seq<Value>)((Seq)OptionVal.Some$.MODULE$.apply(rows.last())));
                                Seq initial = (Seq)rows.init();
                                if (initial.nonEmpty()) {
                                    this.emitMultiple(RowCollector$.MODULE$.out(), initial.iterator());
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    this.pull(RowCollector$.MODULE$.in());
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                    }
                    return;
                } else {
                    RowCollector$.MODULE$.akka$persistence$spanner$internal$RowCollector$$log().trace("Pulling and waiting for next result");
                    this.pull(RowCollector$.MODULE$.in());
                }
            }

            public void onPull() {
                this.pull(RowCollector$.MODULE$.in());
            }

            public void postStop() {
                block0: {
                    if (!OptionVal$.MODULE$.isDefined$extension(this.incompleteRow())) break block0;
                    RowCollector$.MODULE$.akka$persistence$spanner$internal$RowCollector$$log().warn("Stream stopped with incomplete result in buffer {}", (Object)new OptionVal(this.incompleteRow()));
                }
            }
            {
                InHandler.$init$((InHandler)this);
                OutHandler.$init$((OutHandler)this);
                OptionVal$.MODULE$.None();
                this.incompleteRow = null;
                this.incompleteChunked = false;
                this.columnsPerRow = RowCollector$.MODULE$.akka$persistence$spanner$internal$RowCollector$$MetadataNotSeenYet();
                this.setHandlers(RowCollector$.MODULE$.in(), RowCollector$.MODULE$.out(), this);
            }
        };
    }

    public Seq<Value> recombine(Seq<Value> firstChunk, Seq<Value> secondChunk) {
        return (Seq)((IterableOps)((SeqOps)firstChunk.init()).$colon$plus((Object)this.recombine((Value)firstChunk.last(), (Value)secondChunk.head()))).$plus$plus((IterableOnce)secondChunk.tail());
    }

    public Value recombine(Value part1, Value part2) {
        Value.Kind$.StringValue stringValue;
        Value.Kind kind = part1.kind();
        if (kind instanceof Value.Kind$.StringValue) {
            String end;
            Value.Kind$.StringValue stringValue2 = (Value.Kind$.StringValue)kind;
            String beginning = stringValue2.value();
            Value.Kind kind2 = part2.kind();
            if (!(kind2 instanceof Value.Kind$.StringValue)) {
                throw new MatchError((Object)kind2);
            }
            Value.Kind$.StringValue stringValue3 = (Value.Kind$.StringValue)kind2;
            String string = end = stringValue3.value();
            String end2 = string;
            stringValue = new Value.Kind$.StringValue(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(beginning), end2));
        } else if (kind instanceof Value.Kind$.ListValue) {
            ListValue end;
            Value.Kind$.ListValue listValue = (Value.Kind$.ListValue)kind;
            ListValue beginning = listValue.value();
            Value.Kind kind3 = part2.kind();
            if (!(kind3 instanceof Value.Kind$.ListValue)) {
                throw new MatchError((Object)kind3);
            }
            Value.Kind$.ListValue listValue2 = (Value.Kind$.ListValue)kind3;
            ListValue listValue3 = end = listValue2.value();
            ListValue end3 = listValue3;
            Value beginningLast = (Value)beginning.values().last();
            Value.Kind kind4 = beginningLast.kind();
            boolean bl = kind4 instanceof Value.Kind$.NumberValue ? true : kind4 instanceof Value.Kind$.BoolValue;
            Value.Kind$.ListValue listValue4 = bl ? new Value.Kind$.ListValue(new ListValue((Seq)beginning.values().$plus$plus((IterableOnce)end3.values()), ListValue$.MODULE$.apply$default$2())) : new Value.Kind$.ListValue(new ListValue((Seq)((IterableOps)((SeqOps)beginning.values().init()).$colon$plus((Object)this.recombine((Value)beginning.values().last(), (Value)end3.values().head()))).$plus$plus((IterableOnce)end3.values().tail()), ListValue$.MODULE$.apply$default$2()));
            stringValue = listValue4;
        } else {
            if (kind instanceof Value.Kind$.StructValue) {
                throw new IllegalArgumentException(new StringBuilder(47).append("Got a chunked ").append(part1.kind()).append(" value but that is not supported.").toString());
            }
            boolean bl = kind instanceof Value.Kind$.BoolValue ? true : (kind instanceof Value.Kind$.NumberValue ? true : (kind instanceof Value.Kind$.NullValue ? true : Value.Kind$.Empty$.MODULE$.equals(kind)));
            if (bl) {
                throw new IllegalArgumentException(new StringBuilder(45).append("Got a chunked ").append(part1.kind()).append(" value but that is not allowed.").toString());
            }
            throw new MatchError((Object)kind);
        }
        return new Value((Value.Kind)stringValue, Value$.MODULE$.apply$default$2());
    }

    private RowCollector$() {
    }
}

