/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.spanner;

import akka.annotation.InternalStableApi;
import akka.persistence.spanner.QuerySettings;
import akka.util.JavaDurationConverters;
import akka.util.JavaDurationConverters$;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005w!B!C\u0011\u0003Ie!B&C\u0011\u0003a\u0005\"B*\u0002\t\u0003!f\u0001B+\u0002\u0005YC\u0001bV\u0002\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\u0006'\u000e!\t!\u0019\u0005\bK\u000e\u0011\r\u0011\"\u0001g\u0011\u0019Q7\u0001)A\u0005O\"91n\u0001b\u0001\n\u0003a\u0007BB;\u0004A\u0003%Q\u000eC\u0004w\u0007\t\u0007I\u0011\u00014\t\r]\u001c\u0001\u0015!\u0003h\u0011\u001dA8A1A\u0005\u00021Da!_\u0002!\u0002\u0013i\u0007b\u0002>\u0004\u0005\u0004%\t\u0001\u001c\u0005\u0007w\u000e\u0001\u000b\u0011B7\t\u000fq\u001c!\u0019!C\u0001Y\"1Qp\u0001Q\u0001\n5DqA`\u0002C\u0002\u0013\u0005q\u0010\u0003\u0005\u0002\b\r\u0001\u000b\u0011BA\u0001\u0011%\tIa\u0001b\u0001\n\u0003\tY\u0001\u0003\u0005\u0002\u001e\r\u0001\u000b\u0011BA\u0007\u0011!\tyb\u0001b\u0001\n\u0003a\u0007bBA\u0011\u0007\u0001\u0006I!\u001c\u0004\u0006\u0017\n\u0013\u00111\u0007\u0005\t/b\u0011\t\u0011)A\u00051\"11\u000b\u0007C\u0001\u0003kA\u0011\"a\u000f\u0019\u0005\u0004%\t!a\u0003\t\u0011\u0005u\u0002\u0004)A\u0005\u0003\u001bA\u0011\"a\u0010\u0019\u0005\u0004%\t!a\u0003\t\u0011\u0005\u0005\u0003\u0004)A\u0005\u0003\u001bA\u0011\"a\u0011\u0019\u0005\u0004%\t!a\u0003\t\u0011\u0005\u0015\u0003\u0004)A\u0005\u0003\u001bA\u0011\"a\u0012\u0019\u0005\u0004%\t!!\u0013\t\u0011\u0005}\u0003\u0004)A\u0005\u0003\u0017B\u0011\"!\u0019\u0019\u0005\u0004%\t!!\u0013\t\u0011\u0005\r\u0004\u0004)A\u0005\u0003\u0017B\u0011\"!\u001a\u0019\u0005\u0004%\t!!\u0013\t\u0011\u0005\u001d\u0004\u0004)A\u0005\u0003\u0017B\u0011\"!\u001b\u0019\u0005\u0004%\t!a\u001b\t\u0011\u0005M\u0004\u0004)A\u0005\u0003[B\u0011\"!\u001e\u0019\u0005\u0004%\t!a\u0003\t\u0011\u0005]\u0004\u0004)A\u0005\u0003\u001bA\u0011\"!\u001f\u0019\u0005\u0004%\t!a\u0003\t\u0011\u0005m\u0004\u0004)A\u0005\u0003\u001bA\u0011\"! \u0019\u0005\u0004%\t!a\u0003\t\u0011\u0005}\u0004\u0004)A\u0005\u0003\u001bA\u0011\"!!\u0019\u0005\u0004%\t!a\u0003\t\u0011\u0005\r\u0005\u0004)A\u0005\u0003\u001bA\u0001\"!\"\u0019\u0005\u0004%\tA\u001a\u0005\b\u0003\u000fC\u0002\u0015!\u0003h\u0011!\tI\t\u0007b\u0001\n\u0003a\u0007bBAF1\u0001\u0006I!\u001c\u0005\n\u0003\u001bC\"\u0019!C\u0001\u0003\u0017A\u0001\"a$\u0019A\u0003%\u0011Q\u0002\u0005\n\u0003#C\"\u0019!C\u0001\u0003\u0017A\u0001\"a%\u0019A\u0003%\u0011Q\u0002\u0005\n\u0003+C\"\u0019!C\u0001\u0003\u0017A\u0001\"a&\u0019A\u0003%\u0011Q\u0002\u0005\n\u00033C\"\u0019!C\u0001\u00037C\u0001\"!,\u0019A\u0003%\u0011Q\u0014\u0005\t\u0003_C\"\u0019!C\u0001Y\"9\u0011\u0011\u0017\r!\u0002\u0013i\u0007\"CAZ1\t\u0007I\u0011AA[\u0011!\ti\f\u0007Q\u0001\n\u0005]\u0016aD*qC:tWM]*fiRLgnZ:\u000b\u0005\r#\u0015aB:qC:tWM\u001d\u0006\u0003\u000b\u001a\u000b1\u0002]3sg&\u001cH/\u001a8dK*\tq)\u0001\u0003bW.\f7\u0001\u0001\t\u0003\u0015\u0006i\u0011A\u0011\u0002\u0010'B\fgN\\3s'\u0016$H/\u001b8hgN\u0011\u0011!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0002!\u0006)1oY1mC&\u0011!k\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I%aE*fgNLwN\u001c)p_2\u001cV\r\u001e;j]\u001e\u001c8CA\u0002N\u0003\u0019\u0019wN\u001c4jOB\u0011\u0011lX\u0007\u00025*\u0011qk\u0017\u0006\u00039v\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002=\u0006\u00191m\\7\n\u0005\u0001T&AB\"p]\u001aLw\r\u0006\u0002cIB\u00111mA\u0007\u0002\u0003!)q+\u0002a\u00011\u00069Q.\u0019=TSj,W#A4\u0011\u00059C\u0017BA5P\u0005\rIe\u000e^\u0001\t[\u0006D8+\u001b>fA\u0005\u0019\"/\u001a;ss\u000e\u0013X-\u0019;f\u0013:$XM\u001d<bYV\tQ\u000e\u0005\u0002og6\tqN\u0003\u0002qc\u0006AA-\u001e:bi&|gN\u0003\u0002s\u001f\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005Q|'A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0015e\u0016$(/_\"sK\u0006$X-\u00138uKJ4\u0018\r\u001c\u0011\u0002-5\f\u0007pT;ugR\fg\u000eZ5oOJ+\u0017/^3tiN\fq#\\1y\u001fV$8\u000f^1oI&twMU3rk\u0016\u001cHo\u001d\u0011\u0002#I,7\u000f^1si6KgNQ1dW>4g-\u0001\nsKN$\u0018M\u001d;NS:\u0014\u0015mY6pM\u001a\u0004\u0013!\u0005:fgR\f'\u000f^'bq\n\u000b7m[8gM\u0006\u0011\"/Z:uCJ$X*\u0019=CC\u000e\\wN\u001a4!\u0003EYW-\u001a9BY&4X-\u00138uKJ4\u0018\r\\\u0001\u0013W\u0016,\u0007/\u00117jm\u0016Le\u000e^3sm\u0006d\u0007%A\u0007ti\u0006$8/\u00138uKJt\u0017\r\\\u000b\u0003\u0003\u0003\u0001BATA\u0002[&\u0019\u0011QA(\u0003\r=\u0003H/[8o\u00039\u0019H/\u0019;t\u0013:$XM\u001d8bY\u0002\n1b\u001d;biNdunZ4feV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\tI\"\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0011\u0001\u00026bm\u0006LA!a\u0007\u0002\u0012\t11\u000b\u001e:j]\u001e\fAb\u001d;biNdunZ4fe\u0002\nqb\u001d5vi\u0012|wO\u001c+j[\u0016|W\u000f^\u0001\u0011g\",H\u000fZ8x]RKW.Z8vi\u0002B3!AA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016\r\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0012\u0011\u0006\u0002\u0012\u0013:$XM\u001d8bYN#\u0018M\u00197f\u0003BL\u0007f\u0001\u0001\u0002&M\u0011\u0001$\u0014\u000b\u0005\u0003o\tI\u0004\u0005\u0002K1!)qK\u0007a\u00011\u00069\u0001O]8kK\u000e$\u0018\u0001\u00039s_*,7\r\u001e\u0011\u0002\u0011%t7\u000f^1oG\u0016\f\u0011\"\u001b8ti\u0006t7-\u001a\u0011\u0002\u0011\u0011\fG/\u00192bg\u0016\f\u0011\u0002Z1uC\n\f7/\u001a\u0011\u0002+\u0019,H\u000e\\=Rk\u0006d\u0017NZ5fIB\u0013xN[3diV\u0011\u00111\n\t\u0005\u0003\u001b\nYF\u0004\u0003\u0002P\u0005]\u0003cAA)\u001f6\u0011\u00111\u000b\u0006\u0004\u0003+B\u0015A\u0002\u001fs_>$h(C\u0002\u0002Z=\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u000e\u0003;R1!!\u0017P\u0003Y1W\u000f\u001c7z#V\fG.\u001b4jK\u0012\u0004&o\u001c6fGR\u0004\u0013A\u00029be\u0016tG/A\u0004qCJ,g\u000e\u001e\u0011\u0002-\u0019,H\u000e\\=Rk\u0006d\u0017NZ5fI\u0012\u000bG/\u00192bg\u0016\fqCZ;mYf\fV/\u00197jM&,G\rR1uC\n\f7/\u001a\u0011\u0002\u000fU\u001cX-Q;uQV\u0011\u0011Q\u000e\t\u0004\u001d\u0006=\u0014bAA9\u001f\n9!i\\8mK\u0006t\u0017\u0001C;tK\u0006+H\u000f\u001b\u0011\u0002\u0019)|WO\u001d8bYR\u000b'\r\\3\u0002\u001b)|WO\u001d8bYR\u000b'\r\\3!\u00035)g/\u001a8u)\u0006<G+\u00192mK\u0006qQM^3oiR\u000bw\rV1cY\u0016\u0004\u0013A\u00043fY\u0016$\u0018n\u001c8t)\u0006\u0014G.Z\u0001\u0010I\u0016dW\r^5p]N$\u0016M\u00197fA\u0005QqM\u001d9d\u00072LWM\u001c;\u0002\u0017\u001d\u0014\boY\"mS\u0016tG\u000fI\u0001\u0010[\u0006DxK]5uKJ+GO]5fg\u0006\u0001R.\u0019=Xe&$XMU3ue&,7\u000fI\u0001\u0015[\u0006DxK]5uKJ+GO]=US6,w.\u001e;\u0002+5\f\u0007p\u0016:ji\u0016\u0014V\r\u001e:z)&lWm\\;uA\u0005q1O\\1qg\"|Go\u001d+bE2,\u0017aD:oCB\u001c\bn\u001c;t)\u0006\u0014G.\u001a\u0011\u0002\u0017=\u0014'.Z2u)\u0006\u0014G.Z\u0001\r_\nTWm\u0019;UC\ndW\rI\u0001\u0015_\nTWm\u0019;UC\ndW\rV1h\u0007>dW/\u001c8\u0002+=\u0014'.Z2u)\u0006\u0014G.\u001a+bO\u000e{G.^7oA\u0005Y1/Z:tS>t\u0007k\\8m+\t\ti\nE\u0002\u0002 \u000eq1!!)\u0001\u001d\u0011\t\u0019+a+\u000f\t\u0005\u0015\u0016\u0011\u0016\b\u0005\u0003#\n9+C\u0001H\u0013\t)e)\u0003\u0002D\t\u0006a1/Z:tS>t\u0007k\\8mA\u0005I2/Z:tS>t\u0017iY9vSNLG/[8o)&lWm\\;u\u0003i\u0019Xm]:j_:\f5-];jg&$\u0018n\u001c8US6,w.\u001e;!\u00035\tX/\u001a:z'\u0016$H/\u001b8hgV\u0011\u0011q\u0017\t\u0004\u0015\u0006e\u0016bAA^\u0005\ni\u0011+^3ssN+G\u000f^5oON\fa\"];fef\u001cV\r\u001e;j]\u001e\u001c\b\u0005K\u0002\u0019\u0003K\u0001")
@InternalStableApi
public final class SpannerSettings {
    private final String project;
    private final String instance;
    private final String database;
    private final String fullyQualifiedProject;
    private final String parent;
    private final String fullyQualifiedDatabase;
    private final boolean useAuth;
    private final String journalTable;
    private final String eventTagTable;
    private final String deletionsTable;
    private final String grpcClient;
    private final int maxWriteRetries;
    private final FiniteDuration maxWriteRetryTimeout;
    private final String snapshotsTable;
    private final String objectTable;
    private final String objectTableTagColumn;
    private final SessionPoolSettings sessionPool;
    private final FiniteDuration sessionAcquisitionTimeout;
    private final QuerySettings querySettings;

    public String project() {
        return this.project;
    }

    public String instance() {
        return this.instance;
    }

    public String database() {
        return this.database;
    }

    public String fullyQualifiedProject() {
        return this.fullyQualifiedProject;
    }

    public String parent() {
        return this.parent;
    }

    public String fullyQualifiedDatabase() {
        return this.fullyQualifiedDatabase;
    }

    public boolean useAuth() {
        return this.useAuth;
    }

    public String journalTable() {
        return this.journalTable;
    }

    public String eventTagTable() {
        return this.eventTagTable;
    }

    public String deletionsTable() {
        return this.deletionsTable;
    }

    public String grpcClient() {
        return this.grpcClient;
    }

    public int maxWriteRetries() {
        return this.maxWriteRetries;
    }

    public FiniteDuration maxWriteRetryTimeout() {
        return this.maxWriteRetryTimeout;
    }

    public String snapshotsTable() {
        return this.snapshotsTable;
    }

    public String objectTable() {
        return this.objectTable;
    }

    public String objectTableTagColumn() {
        return this.objectTableTagColumn;
    }

    public SessionPoolSettings sessionPool() {
        return this.sessionPool;
    }

    public FiniteDuration sessionAcquisitionTimeout() {
        return this.sessionAcquisitionTimeout;
    }

    public QuerySettings querySettings() {
        return this.querySettings;
    }

    public SpannerSettings(Config config) {
        this.project = config.getString("project");
        this.instance = config.getString("instance");
        this.database = config.getString("database");
        this.fullyQualifiedProject = new StringBuilder(9).append("projects/").append(this.project()).toString();
        this.parent = new StringBuilder(11).append(this.fullyQualifiedProject()).append("/instances/").append(this.instance()).toString();
        this.fullyQualifiedDatabase = new StringBuilder(11).append(this.parent()).append("/databases/").append(this.database()).toString();
        this.useAuth = config.getBoolean("use-auth");
        this.journalTable = config.getString("journal.table");
        this.eventTagTable = config.getString("journal.event-tag-table");
        this.deletionsTable = config.getString("journal.deletions-table");
        this.grpcClient = config.getString("grpc-client");
        this.maxWriteRetries = config.getInt("max-write-retries");
        this.maxWriteRetryTimeout = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("max-write-retry-timeout")));
        this.snapshotsTable = config.getString("snapshot.table");
        this.objectTable = config.getString("durable-state-store.table");
        this.objectTableTagColumn = config.getString("durable-state-store.tag-column");
        this.sessionPool = new SessionPoolSettings(config.getConfig("session-pool"));
        this.sessionAcquisitionTimeout = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("session-acquisition-timeout")));
        this.querySettings = new QuerySettings(config.getConfig("query"));
    }

    public static final class SessionPoolSettings {
        private final int maxSize;
        private final FiniteDuration retryCreateInterval;
        private final int maxOutstandingRequests;
        private final FiniteDuration restartMinBackoff;
        private final FiniteDuration restartMaxBackoff;
        private final FiniteDuration keepAliveInterval;
        private final Option<FiniteDuration> statsInternal;
        private final String statsLogger;
        private final FiniteDuration shutdownTimeout;

        public int maxSize() {
            return this.maxSize;
        }

        public FiniteDuration retryCreateInterval() {
            return this.retryCreateInterval;
        }

        public int maxOutstandingRequests() {
            return this.maxOutstandingRequests;
        }

        public FiniteDuration restartMinBackoff() {
            return this.restartMinBackoff;
        }

        public FiniteDuration restartMaxBackoff() {
            return this.restartMaxBackoff;
        }

        public FiniteDuration keepAliveInterval() {
            return this.keepAliveInterval;
        }

        public Option<FiniteDuration> statsInternal() {
            return this.statsInternal;
        }

        public String statsLogger() {
            return this.statsLogger;
        }

        public FiniteDuration shutdownTimeout() {
            return this.shutdownTimeout;
        }

        public SessionPoolSettings(Config config) {
            None$ none$;
            block3: {
                this.maxSize = config.getInt("max-size");
                Predef$.MODULE$.require(this.maxSize() <= 100, (Function0 & Serializable)() -> "session-pool.max-size must be <= 100");
                this.retryCreateInterval = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("retry-create-interval")));
                this.maxOutstandingRequests = config.getInt("max-outstanding-requests");
                this.restartMinBackoff = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("restart-min-backoff")));
                this.restartMaxBackoff = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("restart-max-backoff")));
                this.keepAliveInterval = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("keep-alive-interval")));
                String string = config.getString("stats-interval").toLowerCase();
                switch (string == null ? 0 : string.hashCode()) {
                    case 109935: {
                        if (!"off".equals(string)) break;
                        none$ = None$.MODULE$;
                        break block3;
                    }
                }
                none$ = new Some((Object)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("stats-interval"))));
            }
            this.statsInternal = none$;
            this.statsLogger = config.getString("stats-logger");
            this.shutdownTimeout = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("shutdown-timeout")));
        }
    }
}

