/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.migration;

import akka.Done;
import akka.Done$;
import akka.actor.typed.ActorSystem;
import akka.annotation.InternalApi;
import akka.dispatch.ExecutionContexts$;
import akka.persistence.r2dbc.internal.R2dbcExecutor;
import akka.persistence.r2dbc.internal.Sql;
import akka.persistence.r2dbc.internal.Sql$;
import akka.persistence.r2dbc.journal.JournalDao$;
import io.r2dbc.spi.ConnectionFactory;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t5tA\u0002\u0017.\u0011\u0003ySG\u0002\u00048[!\u0005q\u0006\u000f\u0005\u0006\u007f\u0005!\t!\u0011\u0004\u0005\u0005\u0006\u00115\t\u0003\u0005T\u0007\tU\r\u0011\"\u0001U\u0011!i6A!E!\u0002\u0013)\u0006\u0002\u00030\u0004\u0005+\u0007I\u0011A0\t\u0011\r\u001c!\u0011#Q\u0001\n\u0001D\u0001\u0002Z\u0002\u0003\u0016\u0004%\ta\u0018\u0005\tK\u000e\u0011\t\u0012)A\u0005A\")qh\u0001C\u0001M\"9AnAA\u0001\n\u0003i\u0007bB9\u0004#\u0003%\tA\u001d\u0005\b{\u000e\t\n\u0011\"\u0001\u007f\u0011!\t\taAI\u0001\n\u0003q\b\"CA\u0002\u0007\u0005\u0005I\u0011IA\u0003\u0011%\t)bAA\u0001\n\u0003\t9\u0002C\u0005\u0002 \r\t\t\u0011\"\u0001\u0002\"!I\u0011QF\u0002\u0002\u0002\u0013\u0005\u0013q\u0006\u0005\n\u0003{\u0019\u0011\u0011!C\u0001\u0003\u007fA\u0011\"!\u0013\u0004\u0003\u0003%\t%a\u0013\t\u0013\u0005=3!!A\u0005B\u0005E\u0003\"CA*\u0007\u0005\u0005I\u0011IA+\u0011%\t9fAA\u0001\n\u0003\nIfB\u0005\u0002^\u0005\t\t\u0011#\u0001\u0002`\u0019A!)AA\u0001\u0012\u0003\t\t\u0007\u0003\u0004@3\u0011\u0005\u0011\u0011\u0010\u0005\n\u0003'J\u0012\u0011!C#\u0003+B\u0011\"a\u001f\u001a\u0003\u0003%\t)! \t\u0013\u0005\u0015\u0015$!A\u0005\u0002\u0006\u001d\u0005\"CAM3\u0005\u0005I\u0011BAN\r\u00199T\u0006A\u0018\u00022\"Q\u00111W\u0010\u0003\u0002\u0003\u0006I!!.\t\u0015\u0005\u0015wD!A!\u0002\u0013\t9\r\u0003\u0006\u0002X~\u0011\t\u0011)A\u0006\u00033D!\"!9 \u0005\u0003\u0005\u000b1BAr\u0011\u0019yt\u0004\"\u0001\u0003\u0006!I!1D\u0010C\u0002\u0013%!Q\u0004\u0005\t\u0005Wy\u0002\u0015!\u0003\u0003 !9!QF\u0010\u0005\u0002\t=\u0002b\u0002B ?\u0011\u0005!\u0011\t\u0005\b\u0005\u0013zB\u0011\u0001B&\u0011\u001d\u0011\tf\bC\u0001\u0005'BqAa\u0018 \t\u0013\u0011\t'\u0001\tNS\u001e\u0014\u0018\r^5p]R{w\u000e\u001c#b_*\u0011afL\u0001\n[&<'/\u0019;j_:T!\u0001M\u0019\u0002\u000bI\u0014DMY2\u000b\u0005I\u001a\u0014a\u00039feNL7\u000f^3oG\u0016T\u0011\u0001N\u0001\u0005C.\\\u0017\r\u0005\u00027\u00035\tQF\u0001\tNS\u001e\u0014\u0018\r^5p]R{w\u000e\u001c#b_N\u0011\u0011!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\u000e\u0002\u0010\u0007V\u0014(/\u001a8u!J|wM]3tgN!1!\u000f#H!\tQT)\u0003\u0002Gw\t9\u0001K]8ek\u000e$\bC\u0001%Q\u001d\tIeJ\u0004\u0002K\u001b6\t1J\u0003\u0002M\u0001\u00061AH]8pizJ\u0011\u0001P\u0005\u0003\u001fn\nq\u0001]1dW\u0006<W-\u0003\u0002R%\na1+\u001a:jC2L'0\u00192mK*\u0011qjO\u0001\u000ea\u0016\u00148/[:uK:\u001cW-\u00133\u0016\u0003U\u0003\"A\u0016.\u000f\u0005]C\u0006C\u0001&<\u0013\tI6(\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-<\u00039\u0001XM]:jgR,gnY3JI\u0002\n!\"\u001a<f]R\u001cV-\u001d(s+\u0005\u0001\u0007C\u0001\u001eb\u0013\t\u00117H\u0001\u0003M_:<\u0017aC3wK:$8+Z9Oe\u0002\nQb\u001d8baNDw\u000e^*fc:\u0013\u0018AD:oCB\u001c\bn\u001c;TKFt%\u000f\t\u000b\u0005O&T7\u000e\u0005\u0002i\u00075\t\u0011\u0001C\u0003T\u0015\u0001\u0007Q\u000bC\u0003_\u0015\u0001\u0007\u0001\rC\u0003e\u0015\u0001\u0007\u0001-\u0001\u0003d_BLH\u0003B4o_BDqaU\u0006\u0011\u0002\u0003\u0007Q\u000bC\u0004_\u0017A\u0005\t\u0019\u00011\t\u000f\u0011\\\u0001\u0013!a\u0001A\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A:+\u0005U#8&A;\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018!C;oG\",7m[3e\u0015\tQ8(\u0001\u0006b]:|G/\u0019;j_:L!\u0001`<\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003}T#\u0001\u0019;\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0002\u0011\t\u0005%\u00111C\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005!A.\u00198h\u0015\t\t\t\"\u0001\u0003kCZ\f\u0017bA.\u0002\f\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0004\t\u0004u\u0005m\u0011bAA\u000fw\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111EA\u0015!\rQ\u0014QE\u0005\u0004\u0003OY$aA!os\"I\u00111F\t\u0002\u0002\u0003\u0007\u0011\u0011D\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\u0002CBA\u001a\u0003s\t\u0019#\u0004\u0002\u00026)\u0019\u0011qG\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002<\u0005U\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0011\u0002HA\u0019!(a\u0011\n\u0007\u0005\u00153HA\u0004C_>dW-\u00198\t\u0013\u0005-2#!AA\u0002\u0005\r\u0012A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0002\u0002N!I\u00111\u0006\u000b\u0002\u0002\u0003\u0007\u0011\u0011D\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011D\u0001\ti>\u001cFO]5oOR\u0011\u0011qA\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0005\u00131\f\u0005\n\u0003W9\u0012\u0011!a\u0001\u0003G\tqbQ;se\u0016tG\u000f\u0015:pOJ,7o\u001d\t\u0003Qf\u0019R!GA2\u0003_\u0002\u0002\"!\u001a\u0002lU\u0003\u0007mZ\u0007\u0003\u0003OR1!!\u001b<\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\u001c\u0002h\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u0005E\u0014qO\u0007\u0003\u0003gRA!!\u001e\u0002\u0010\u0005\u0011\u0011n\\\u0005\u0004#\u0006MDCAA0\u0003\u0015\t\u0007\u000f\u001d7z)\u001d9\u0017qPAA\u0003\u0007CQa\u0015\u000fA\u0002UCQA\u0018\u000fA\u0002\u0001DQ\u0001\u001a\u000fA\u0002\u0001\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\n\u0006U\u0005#\u0002\u001e\u0002\f\u0006=\u0015bAAGw\t1q\n\u001d;j_:\u0004bAOAI+\u0002\u0004\u0017bAAJw\t1A+\u001e9mKNB\u0001\"a&\u001e\u0003\u0003\u0005\raZ\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAO!\u0011\tI!a(\n\t\u0005\u0005\u00161\u0002\u0002\u0007\u001f\nTWm\u0019;)\u0007\u0005\t)\u000b\u0005\u0003\u0002(\u0006-VBAAU\u0015\tQ8'\u0003\u0003\u0002.\u0006%&aC%oi\u0016\u0014h.\u00197Ba&D3\u0001AAS'\ty\u0012(A\td_:tWm\u0019;j_:4\u0015m\u0019;pef\u0004B!a.\u0002B6\u0011\u0011\u0011\u0018\u0006\u0005\u0003w\u000bi,A\u0002ta&T1\u0001MA`\u0015\t\t)(\u0003\u0003\u0002D\u0006e&!E\"p]:,7\r^5p]\u001a\u000b7\r^8ss\u0006\u0019Bn\\4EE\u000e\u000bG\u000e\\:Fq\u000e,W\rZ5oOB!\u0011\u0011ZAj\u001b\t\tYM\u0003\u0003\u0002N\u0006=\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0007\u0005E7(\u0001\u0006d_:\u001cWO\u001d:f]RLA!!6\u0002L\nqa)\u001b8ji\u0016$UO]1uS>t\u0017AA3d!\u0011\tY.!8\u000e\u0005\u0005=\u0017\u0002BAp\u0003\u001f\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rML8\u000f^3na\u0011\t)/!?\u0011\r\u0005\u001d\u0018\u0011_A{\u001b\t\tIO\u0003\u0003\u0002l\u00065\u0018!\u0002;za\u0016$'bAAxg\u0005)\u0011m\u0019;pe&!\u00111_Au\u0005-\t5\r^8s'f\u001cH/Z7\u0011\t\u0005]\u0018\u0011 \u0007\u0001\t-\tYpIA\u0001\u0002\u0003\u0015\t!!@\u0003\u0007}#\u0013'\u0005\u0003\u0002\u0000\u0006\r\u0002c\u0001\u001e\u0003\u0002%\u0019!1A\u001e\u0003\u000f9{G\u000f[5oOR1!q\u0001B\f\u00053!bA!\u0003\u0003\f\t5\u0001C\u0001\u001c \u0011\u001d\t9\u000e\na\u0002\u00033Dq!!9%\u0001\b\u0011y\u0001\r\u0003\u0003\u0012\tU\u0001CBAt\u0003c\u0014\u0019\u0002\u0005\u0003\u0002x\nUA\u0001DA~\u0005\u001b\t\t\u0011!A\u0003\u0002\u0005u\bbBAZI\u0001\u0007\u0011Q\u0017\u0005\b\u0003\u000b$\u0003\u0019AAd\u00035\u0011(\u0007\u001a2d\u000bb,7-\u001e;peV\u0011!q\u0004\t\u0005\u0005C\u00119#\u0004\u0002\u0003$)\u0019!QE\u0018\u0002\u0011%tG/\u001a:oC2LAA!\u000b\u0003$\ti!K\r3cG\u0016CXmY;u_J\faB\u001d\u001aeE\u000e,\u00050Z2vi>\u0014\b%A\nde\u0016\fG/\u001a)s_\u001e\u0014Xm]:UC\ndW\r\u0006\u0002\u00032A1\u00111\u001cB\u001a\u0005oIAA!\u000e\u0002P\n1a)\u001e;ve\u0016\u0004BA!\u000f\u0003<5\t1'C\u0002\u0003>M\u0012A\u0001R8oK\u0006\u0019R\u000f\u001d3bi\u0016,e/\u001a8u!J|wM]3tgR1!\u0011\u0007B\"\u0005\u000bBQa\u0015\u0015A\u0002UCaAa\u0012)\u0001\u0004\u0001\u0017!B:fc:\u0013\u0018AF;qI\u0006$Xm\u00158baNDw\u000e\u001e)s_\u001e\u0014Xm]:\u0015\r\tE\"Q\nB(\u0011\u0015\u0019\u0016\u00061\u0001V\u0011\u0019\u00119%\u000ba\u0001A\u0006y1-\u001e:sK:$\bK]8he\u0016\u001c8\u000f\u0006\u0003\u0003V\tu\u0003CBAn\u0005g\u00119\u0006E\u0003;\u0003\u0017\u0013I\u0006E\u0002\u0003\\\rq!A\u000e\u0001\t\u000bMS\u0003\u0019A+\u0002\u0015i,'o\\%g\u001dVdG\u000eF\u0002a\u0005GBqA!\u001a,\u0001\u0004\u00119'A\u0001o!\u0011\tIA!\u001b\n\u0007\t\fY\u0001K\u0002 \u0003K\u0003")
@InternalApi
public class MigrationToolDao {
    private final R2dbcExecutor r2dbcExecutor;

    private R2dbcExecutor r2dbcExecutor() {
        return this.r2dbcExecutor;
    }

    public Future<Done> createProgressTable() {
        return this.r2dbcExecutor().executeDdl("create migration progress table", (Function1 & Serializable)connection -> connection.createStatement(Sql.Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        CREATE TABLE IF NOT EXISTS migration_progress(\n          persistence_id VARCHAR(255) NOT NULL,\n          event_seq_nr BIGINT,\n          snapshot_seq_nr BIGINT,\n          PRIMARY KEY(persistence_id)\n        )"}))), (Seq)Nil$.MODULE$)));
    }

    public Future<Done> updateEventProgress(String persistenceId, long seqNr) {
        return this.r2dbcExecutor().updateOne(new StringBuilder(28).append("upsert migration progress [").append(persistenceId).append("]").toString(), (Function1 & Serializable)connection -> connection.createStatement(Sql.Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n              INSERT INTO migration_progress\n              (persistence_id, event_seq_nr)\n              VALUES (?, ?)\n              ON CONFLICT (persistence_id)\n              DO UPDATE SET\n              event_seq_nr = excluded.event_seq_nr"}))), (Seq)Nil$.MODULE$)).bind(0, (Object)persistenceId).bind(1, (Object)BoxesRunTime.boxToLong((long)seqNr))).map((Function1 & Serializable)x$1 -> MigrationToolDao.$anonfun$updateEventProgress$2(BoxesRunTime.unboxToLong((Object)x$1)), ExecutionContexts$.MODULE$.parasitic());
    }

    public Future<Done> updateSnapshotProgress(String persistenceId, long seqNr) {
        return this.r2dbcExecutor().updateOne(new StringBuilder(28).append("upsert migration progress [").append(persistenceId).append("]").toString(), (Function1 & Serializable)connection -> connection.createStatement(Sql.Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n              INSERT INTO migration_progress\n              (persistence_id, snapshot_seq_nr)\n              VALUES (?, ?)\n              ON CONFLICT (persistence_id)\n              DO UPDATE SET\n              snapshot_seq_nr = excluded.snapshot_seq_nr"}))), (Seq)Nil$.MODULE$)).bind(0, (Object)persistenceId).bind(1, (Object)BoxesRunTime.boxToLong((long)seqNr))).map((Function1 & Serializable)x$2 -> MigrationToolDao.$anonfun$updateSnapshotProgress$2(BoxesRunTime.unboxToLong((Object)x$2)), ExecutionContexts$.MODULE$.parasitic());
    }

    public Future<Option<CurrentProgress>> currentProgress(String persistenceId) {
        return this.r2dbcExecutor().selectOne(new StringBuilder(26).append("read migration progress [").append(persistenceId).append("]").toString(), (Function1 & Serializable)x$3 -> x$3.createStatement(Sql.Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM migration_progress WHERE persistence_id = ?"}))), (Seq)Nil$.MODULE$)).bind(0, (Object)persistenceId), (Function1 & Serializable)row -> new CurrentProgress(persistenceId, this.zeroIfNull((Long)row.get("event_seq_nr", Long.class)), this.zeroIfNull((Long)row.get("snapshot_seq_nr", Long.class))));
    }

    private long zeroIfNull(Long n) {
        if (n == null) {
            return 0L;
        }
        return Predef$.MODULE$.Long2long(n);
    }

    public static final /* synthetic */ Done$ $anonfun$updateEventProgress$2(long x$1) {
        return Done$.MODULE$;
    }

    public static final /* synthetic */ Done$ $anonfun$updateSnapshotProgress$2(long x$2) {
        return Done$.MODULE$;
    }

    public MigrationToolDao(ConnectionFactory connectionFactory, FiniteDuration logDbCallsExceeding, ExecutionContext ec, ActorSystem<?> system) {
        this.r2dbcExecutor = new R2dbcExecutor(connectionFactory, JournalDao$.MODULE$.log(), logDbCallsExceeding, ec, system);
    }

    public static final class CurrentProgress
    implements Product,
    Serializable {
        private final String persistenceId;
        private final long eventSeqNr;
        private final long snapshotSeqNr;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String persistenceId() {
            return this.persistenceId;
        }

        public long eventSeqNr() {
            return this.eventSeqNr;
        }

        public long snapshotSeqNr() {
            return this.snapshotSeqNr;
        }

        public CurrentProgress copy(String persistenceId, long eventSeqNr, long snapshotSeqNr) {
            return new CurrentProgress(persistenceId, eventSeqNr, snapshotSeqNr);
        }

        public String copy$default$1() {
            return this.persistenceId();
        }

        public long copy$default$2() {
            return this.eventSeqNr();
        }

        public long copy$default$3() {
            return this.snapshotSeqNr();
        }

        public String productPrefix() {
            return "CurrentProgress";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.persistenceId();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.eventSeqNr());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.snapshotSeqNr());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CurrentProgress;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "persistenceId";
                }
                case 1: {
                    return "eventSeqNr";
                }
                case 2: {
                    return "snapshotSeqNr";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.persistenceId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.eventSeqNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.snapshotSeqNr()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CurrentProgress)) return false;
            boolean bl = true;
            if (!bl) return false;
            CurrentProgress currentProgress = (CurrentProgress)x$1;
            if (this.eventSeqNr() != currentProgress.eventSeqNr()) return false;
            if (this.snapshotSeqNr() != currentProgress.snapshotSeqNr()) return false;
            String string = this.persistenceId();
            String string2 = currentProgress.persistenceId();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public CurrentProgress(String persistenceId, long eventSeqNr, long snapshotSeqNr) {
            this.persistenceId = persistenceId;
            this.eventSeqNr = eventSeqNr;
            this.snapshotSeqNr = snapshotSeqNr;
            Product.$init$((Product)this);
        }
    }
}

