/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.migration;

import akka.Done;
import akka.actor.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.scaladsl.package;
import akka.dispatch.ExecutionContexts$;
import akka.pattern.AskableActorRef$;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import akka.persistence.SelectedSnapshot;
import akka.persistence.SnapshotMetadata;
import akka.persistence.SnapshotProtocol;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.SnapshotSelectionCriteria$;
import akka.persistence.query.EventEnvelope;
import akka.persistence.query.PersistenceQuery;
import akka.persistence.query.PersistenceQuery$;
import akka.persistence.query.scaladsl.CurrentEventsByPersistenceIdQuery;
import akka.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import akka.persistence.query.scaladsl.ReadJournal;
import akka.persistence.r2dbc.ConnectionFactoryProvider;
import akka.persistence.r2dbc.ConnectionFactoryProvider$;
import akka.persistence.r2dbc.R2dbcSettings;
import akka.persistence.r2dbc.R2dbcSettings$;
import akka.persistence.r2dbc.journal.JournalDao;
import akka.persistence.r2dbc.journal.JournalDao$;
import akka.persistence.r2dbc.migration.MigrationTool$;
import akka.persistence.r2dbc.migration.MigrationTool$$anonfun$;
import akka.persistence.r2dbc.migration.MigrationTool$Result$;
import akka.persistence.r2dbc.migration.MigrationToolDao;
import akka.persistence.r2dbc.snapshot.SnapshotDao;
import akka.persistence.typed.PersistenceId$;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.Serializers$;
import akka.stream.Graph;
import akka.stream.Materializer$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.config.Config;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\rMx!B*U\u0011\u0003if!B0U\u0011\u0003\u0001\u0007\"B4\u0002\t\u0003A\u0007\"B5\u0002\t\u0003Qw!\u0002@\u0002\u0011\u0003yhaBA\u0002\u0003!\u0005\u0011Q\u0001\u0005\u0007O\u0016!\t!a\u0006\t\u0013\u0005eQA1A\u0005\u0002\u0005m\u0001\u0002CAh\u000b\u0001\u0006I!!\b\t\u0013\u0005EW!!A\u0005\u0002\u0006M\u0007\"CAn\u000b\u0005\u0005I\u0011QAo\u0011%\ty/BA\u0001\n\u0013\t\tP\u0002\u0004\u0002\u0004\u0005\u0011\u0015q\u0004\u0005\u000b\u0003oa!Q3A\u0005\u0002\u0005e\u0002BCA!\u0019\tE\t\u0015!\u0003\u0002<!Q\u00111\t\u0007\u0003\u0016\u0004%\t!!\u000f\t\u0015\u0005\u0015CB!E!\u0002\u0013\tY\u0004\u0003\u0006\u0002H1\u0011)\u001a!C\u0001\u0003sA!\"!\u0013\r\u0005#\u0005\u000b\u0011BA\u001e\u0011\u00199G\u0002\"\u0001\u0002L!I\u00111\u000b\u0007\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003;b\u0011\u0013!C\u0001\u0003?B\u0011\"!\u001e\r#\u0003%\t!a\u0018\t\u0013\u0005]D\"%A\u0005\u0002\u0005}\u0003\"CA=\u0019\u0005\u0005I\u0011IA>\u0011%\t9\tDA\u0001\n\u0003\tI\tC\u0005\u0002\u00122\t\t\u0011\"\u0001\u0002\u0014\"I\u0011q\u0014\u0007\u0002\u0002\u0013\u0005\u0013\u0011\u0015\u0005\n\u0003_c\u0011\u0011!C\u0001\u0003cC\u0011\"a/\r\u0003\u0003%\t%!0\t\u0013\u0005\u0005G\"!A\u0005B\u0005\r\u0007\"CAc\u0019\u0005\u0005I\u0011IAd\u0011%\tI\rDA\u0001\n\u0003\nY\rC\u0004\u0002R\u0006!I!!?\u0007\u000b}#\u0006Aa\u0006\t\u0015\te!E!A!\u0002\u0013\u0011Y\u0002\u0003\u0004hE\u0011\u0005!1\u0007\u0005\n\u0005\u0003\u0012#\u0019!C\u0006\u0005\u0007B\u0001Ba\u0014#A\u0003%!Q\t\u0005\n\u0005#\u0012#\u0019!C\u0005\u0005'B\u0001B!\u001a#A\u0003%!Q\u000b\u0005\n\u0005O\u0012#\u0019!C\u0005\u0005SB\u0001Ba\u001d#A\u0003%!1\u000e\u0005\n\u0005k\u0012#\u0019!C\u0005\u0005oB\u0001B!$#A\u0003%!\u0011\u0010\u0005\n\u0005\u001f\u0013#\u0019!C\u0005\u0003\u0013C\u0001B!%#A\u0003%\u00111\u0012\u0005\n\u0005'\u0013#\u0019!C\u0005\u0003wB\u0001B!&#A\u0003%\u0011Q\u0010\u0005\n\u0005/\u0013#\u0019!C\u0005\u00053C\u0001Ba)#A\u0003%!1\u0014\u0005\n\u0005K\u0013#\u0019!C\u0005\u0005OC\u0001Ba-#A\u0003%!\u0011\u0016\u0005\n\u0005k\u0013#\u0019!C\u0005\u0005oC\u0001B!3#A\u0003%!\u0011\u0018\u0005\n\u0005\u0017\u0014#\u0019!C\u0005\u0005\u001bD\u0001Ba7#A\u0003%!q\u001a\u0005\n\u0005;\u0014#\u0019!C\u0005\u0005?D\u0001B!<#A\u0003%!\u0011\u001d\u0005\n\u0005_\u0014#\u0019!C\u0005\u0003\u0013C\u0001B!=#A\u0003%\u00111\u0012\u0005\n\u0005g\u0014#\u0019!C\u0005\u0003wB\u0001B!>#A\u0003%\u0011Q\u0010\u0005\n\u0005o\u0014#\u0019!C\u0005\u0005sD\u0001ba\u0003#A\u0003%!1 \u0005\n\u0007\u001b\u0011#\u0019!C\u0005\u0007\u001fA\u0001ba\u0006#A\u0003%1\u0011\u0003\u0005\n\u00073\u0011#\u0019!C\u0005\u00077A\u0001ba\t#A\u0003%1Q\u0004\u0005\n\u0007K\u0011#\u0019!C\u0005\u0003wB\u0001ba\n#A\u0003%\u0011Q\u0010\u0005\u000b\u0007S\u0011\u0003R1A\u0005\n\r-\u0002BCB\u001bE\t\u0007I\u0011\u0001,\u00048!A1q\b\u0012!\u0002\u0013\u0019I\u0004\u0003\u0006\u0004B\tB)\u0019!C\u0005\u0007\u0007Bqa!\u0017#\t\u0003\u0019Y\u0006C\u0004\u0004d\t\"\ta!\u001a\t\u000f\r\r$\u0005\"\u0003\u0004n!91Q\u0013\u0012\u0005\n\r]\u0005bBB\\E\u0011\u00051\u0011\u0018\u0005\b\u0007o\u0013C\u0011BB`\u0011\u001d\u0019)M\tC\u0005\u0007\u000fDqa!:#\t\u0013\u00199/A\u0007NS\u001e\u0014\u0018\r^5p]R{w\u000e\u001c\u0006\u0003+Z\u000b\u0011\"\\5he\u0006$\u0018n\u001c8\u000b\u0005]C\u0016!\u0002:3I\n\u001c'BA-[\u0003-\u0001XM]:jgR,gnY3\u000b\u0003m\u000bA!Y6lC\u000e\u0001\u0001C\u00010\u0002\u001b\u0005!&!D'jOJ\fG/[8o)>|Gn\u0005\u0002\u0002CB\u0011!-Z\u0007\u0002G*\tA-A\u0003tG\u0006d\u0017-\u0003\u0002gG\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A/\u0002\t5\f\u0017N\u001c\u000b\u0003W:\u0004\"A\u00197\n\u00055\u001c'\u0001B+oSRDQa\\\u0002A\u0002A\fA!\u0019:hgB\u0019!-]:\n\u0005I\u001c'!B!se\u0006L\bC\u0001;|\u001d\t)\u0018\u0010\u0005\u0002wG6\tqO\u0003\u0002y9\u00061AH]8pizJ!A_2\u0002\rA\u0013X\rZ3g\u0013\taXP\u0001\u0004TiJLgn\u001a\u0006\u0003u\u000e\faAU3tk2$\bcAA\u0001\u000b5\t\u0011A\u0001\u0004SKN,H\u000e^\n\u0005\u000b\u0005\f9\u0001\u0005\u0003\u0002\n\u0005MQBAA\u0006\u0015\u0011\ti!a\u0004\u0002\u0005%|'BAA\t\u0003\u0011Q\u0017M^1\n\t\u0005U\u00111\u0002\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0002\u007f\u0006)Q-\u001c9usV\u0011\u0011Q\u0004\t\u0004\u0003\u0003a1C\u0002\u0007b\u0003C\t9\u0003E\u0002c\u0003GI1!!\nd\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u000b\u000249!\u00111FA\u0018\u001d\r1\u0018QF\u0005\u0002I&\u0019\u0011\u0011G2\u0002\u000fA\f7m[1hK&!\u0011QCA\u001b\u0015\r\t\tdY\u0001\u000fa\u0016\u00148/[:uK:\u001cW-\u00133t+\t\tY\u0004E\u0002c\u0003{I1!a\u0010d\u0005\u0011auN\\4\u0002\u001fA,'o]5ti\u0016t7-Z%eg\u0002\na!\u001a<f]R\u001c\u0018aB3wK:$8\u000fI\u0001\ng:\f\u0007o\u001d5piN\f!b\u001d8baNDw\u000e^:!)!\ti\"!\u0014\u0002P\u0005E\u0003bBA\u001c'\u0001\u0007\u00111\b\u0005\b\u0003\u0007\u001a\u0002\u0019AA\u001e\u0011\u001d\t9e\u0005a\u0001\u0003w\tAaY8qsRA\u0011QDA,\u00033\nY\u0006C\u0005\u00028Q\u0001\n\u00111\u0001\u0002<!I\u00111\t\u000b\u0011\u0002\u0003\u0007\u00111\b\u0005\n\u0003\u000f\"\u0002\u0013!a\u0001\u0003w\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002b)\"\u00111HA2W\t\t)\u0007\u0005\u0003\u0002h\u0005ETBAA5\u0015\u0011\tY'!\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA8G\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0014\u0011\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0010\t\u0005\u0003\u007f\n))\u0004\u0002\u0002\u0002*!\u00111QA\b\u0003\u0011a\u0017M\\4\n\u0007q\f\t)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\fB\u0019!-!$\n\u0007\u0005=5MA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0016\u0006m\u0005c\u00012\u0002\u0018&\u0019\u0011\u0011T2\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u001ej\t\t\u00111\u0001\u0002\f\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a)\u0011\r\u0005\u0015\u00161VAK\u001b\t\t9KC\u0002\u0002*\u000e\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti+a*\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003g\u000bI\fE\u0002c\u0003kK1!a.d\u0005\u001d\u0011un\u001c7fC:D\u0011\"!(\u001d\u0003\u0003\u0005\r!!&\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003{\ny\fC\u0005\u0002\u001ev\t\t\u00111\u0001\u0002\f\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\f\u0006AAo\\*ue&tw\r\u0006\u0002\u0002~\u00051Q-];bYN$B!a-\u0002N\"I\u0011Q\u0014\u0011\u0002\u0002\u0003\u0007\u0011QS\u0001\u0007K6\u0004H/\u001f\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\u0005u\u0011Q[Al\u00033Dq!a\u000e\n\u0001\u0004\tY\u0004C\u0004\u0002D%\u0001\r!a\u000f\t\u000f\u0005\u001d\u0013\u00021\u0001\u0002<\u00059QO\\1qa2LH\u0003BAp\u0003W\u0004RAYAq\u0003KL1!a9d\u0005\u0019y\u0005\u000f^5p]BI!-a:\u0002<\u0005m\u00121H\u0005\u0004\u0003S\u001c'A\u0002+va2,7\u0007C\u0005\u0002n*\t\t\u00111\u0001\u0002\u001e\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005M\b\u0003BA@\u0003kLA!a>\u0002\u0002\n1qJ\u00196fGR$\"!a?\u0011\r\u0005u(q\u0001B\u0006\u001b\t\tyP\u0003\u0003\u0003\u0002\t\r\u0011!\u0002;za\u0016$'b\u0001B\u00035\u0006)\u0011m\u0019;pe&!!\u0011BA\u0000\u0005!\u0011U\r[1wS>\u0014\bC\u0002B\u0007\u0005'\ti\"\u0004\u0002\u0003\u0010)\u0019!\u0011C2\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005+\u0011yAA\u0002Uef\u001c\"AI1\u0002\rML8\u000f^3na\u0011\u0011iBa\n\u0011\r\u0005u(q\u0004B\u0012\u0013\u0011\u0011\t#a@\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\t\u0005\u0005K\u00119\u0003\u0004\u0001\u0005\u0017\t%2%!A\u0001\u0002\u000b\u0005!1\u0006\u0002\u0004?\u0012\n\u0014\u0003\u0002B\u0017\u0003+\u00032A\u0019B\u0018\u0013\r\u0011\td\u0019\u0002\b\u001d>$\b.\u001b8h)\u0011\u0011)Da\u000e\u0011\u0005y\u0013\u0003b\u0002B\rI\u0001\u0007!\u0011\b\u0019\u0005\u0005w\u0011y\u0004\u0005\u0004\u0002~\n}!Q\b\t\u0005\u0005K\u0011y\u0004\u0002\u0007\u0003*\t]\u0012\u0011!A\u0001\u0006\u0003\u0011Y#A\u0002tsN,\"A!\u00121\t\t\u001d#1\n\t\u0007\u0003{\u0014yB!\u0013\u0011\t\t\u0015\"1\n\u0003\f\u0005\u001b2\u0013\u0011!A\u0001\u0006\u0003\u0011YCA\u0002`II\nAa]=tA\u0005\u0019An\\4\u0016\u0005\tU\u0003\u0003\u0002B,\u0005Cj!A!\u0017\u000b\t\tm#QL\u0001\u0006g24GG\u001b\u0006\u0003\u0005?\n1a\u001c:h\u0013\u0011\u0011\u0019G!\u0017\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002\u001dA,'o]5ti\u0016t7-Z#yiV\u0011!1\u000e\t\u0005\u0005[\u0012y'D\u0001Y\u0013\r\u0011\t\b\u0017\u0002\f!\u0016\u00148/[:uK:\u001cW-A\bqKJ\u001c\u0018n\u001d;f]\u000e,W\t\u001f;!\u0003=i\u0017n\u001a:bi&|gnQ8oM&<WC\u0001B=!\u0011\u0011YH!#\u000e\u0005\tu$\u0002\u0002B@\u0005\u0003\u000baaY8oM&<'\u0002\u0002BB\u0005\u000b\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0005\u000f\u000b1aY8n\u0013\u0011\u0011YI! \u0003\r\r{gNZ5h\u0003Ai\u0017n\u001a:bi&|gnQ8oM&<\u0007%A\u0006qCJ\fG\u000e\\3mSNl\u0017\u0001\u00049be\u0006dG.\u001a7jg6\u0004\u0013A\u0004;be\u001e,G\u000f\u00157vO&t\u0017\nZ\u0001\u0010i\u0006\u0014x-\u001a;QYV<\u0017N\\%eA\u0005\u0019B/\u0019:hKR\u0014&\u0007\u001a2d'\u0016$H/\u001b8hgV\u0011!1\u0014\t\u0005\u0005;\u0013y*D\u0001W\u0013\r\u0011\tK\u0016\u0002\u000e%J\"'mY*fiRLgnZ:\u0002)Q\f'oZ3u%J\"'mY*fiRLgnZ:!\u00035\u0019XM]5bY&T\u0018\r^5p]V\u0011!\u0011\u0016\t\u0005\u0005W\u0013y+\u0004\u0002\u0003.*\u0019!Q\u0015.\n\t\tE&Q\u0016\u0002\u000e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u0002\u001dM,'/[1mSj\fG/[8oA\u00059B/\u0019:hKR\u001cuN\u001c8fGRLwN\u001c$bGR|'/_\u000b\u0003\u0005s\u0003BAa/\u0003F6\u0011!Q\u0018\u0006\u0005\u0005\u007f\u0013\t-A\u0002ta&T1a\u0016Bb\u0015\t\ti!\u0003\u0003\u0003H\nu&!E\"p]:,7\r^5p]\u001a\u000b7\r^8ss\u0006AB/\u0019:hKR\u001cuN\u001c8fGRLwN\u001c$bGR|'/\u001f\u0011\u0002!Q\f'oZ3u\u0015>,(O\\1m\t\u0006|WC\u0001Bh!\u0011\u0011\tNa6\u000e\u0005\tM'b\u0001Bk-\u00069!n\\;s]\u0006d\u0017\u0002\u0002Bm\u0005'\u0014!BS8ve:\fG\u000eR1p\u0003E!\u0018M]4fi*{WO\u001d8bY\u0012\u000bw\u000eI\u0001\u0012i\u0006\u0014x-\u001a;T]\u0006\u00048\u000f[8u\t\u0006|WC\u0001Bq!\u0011\u0011\u0019O!;\u000e\u0005\t\u0015(b\u0001Bt-\u0006A1O\\1qg\"|G/\u0003\u0003\u0003l\n\u0015(aC*oCB\u001c\bn\u001c;EC>\f!\u0003^1sO\u0016$8K\\1qg\"|G\u000fR1pA\u0005YA/\u0019:hKR\u0014\u0015\r^2i\u00031!\u0018M]4fi\n\u000bGo\u00195!\u0003M\u0019x.\u001e:dKF+XM]=QYV<\u0017N\\%e\u0003Q\u0019x.\u001e:dKF+XM]=QYV<\u0017N\\%eA\u0005\t2o\\;sG\u0016\u0014V-\u00193K_V\u0014h.\u00197\u0016\u0005\tm\b\u0003\u0002B\u007f\u0007\u000fi!Aa@\u000b\t\r\u000511A\u0001\tg\u000e\fG.\u00193tY*\u00191Q\u0001-\u0002\u000bE,XM]=\n\t\r%!q \u0002\f%\u0016\fGMS8ve:\fG.\u0001\nt_V\u00148-\u001a*fC\u0012Tu.\u001e:oC2\u0004\u0013!G:pkJ\u001cW\rU3sg&\u001cH/\u001a8dK&#7/U;fef,\"a!\u0005\u0011\t\tu81C\u0005\u0005\u0007+\u0011yP\u0001\u000eDkJ\u0014XM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ:Rk\u0016\u0014\u00180\u0001\u000et_V\u00148-\u001a)feNL7\u000f^3oG\u0016LEm])vKJL\b%\u0001\u0011t_V\u00148-Z#wK:$8OQ=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ)vKJLXCAB\u000f!\u0011\u0011ipa\b\n\t\r\u0005\"q \u0002\"\u0007V\u0014(/\u001a8u\u000bZ,g\u000e^:CsB+'o]5ti\u0016t7-Z%e#V,'/_\u0001\"g>,(oY3Fm\u0016tGo\u001d\"z!\u0016\u00148/[:uK:\u001cW-\u00133Rk\u0016\u0014\u0018\u0010I\u0001\u0017g>,(oY3T]\u0006\u00048\u000f[8u!2,x-\u001b8JI\u000692o\\;sG\u0016\u001cf.\u00199tQ>$\b\u000b\\;hS:LE\rI\u0001\u0014g>,(oY3T]\u0006\u00048\u000f[8u'R|'/Z\u000b\u0003\u0007[\u0001Baa\f\u000425\u0011!1A\u0005\u0005\u0007g\u0011\u0019A\u0001\u0005BGR|'OU3g\u00031i\u0017n\u001a:bi&|g\u000eR1p+\t\u0019I\u0004E\u0002_\u0007wI1a!\u0010U\u0005Ai\u0015n\u001a:bi&|g\u000eV8pY\u0012\u000bw.A\u0007nS\u001e\u0014\u0018\r^5p]\u0012\u000bw\u000eI\u0001\u0014GJ,\u0017\r^3Qe><'/Z:t)\u0006\u0014G.Z\u000b\u0003\u0007\u000b\u0002baa\u0012\u0004N\rESBAB%\u0015\r\u0019YeY\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BB(\u0007\u0013\u0012aAR;ukJ,\u0007\u0003BB*\u0007+j\u0011AW\u0005\u0004\u0007/R&\u0001\u0002#p]\u0016\f!\"\\5he\u0006$X-\u00117m)\t\u0019i\u0006\u0005\u0004\u0004H\r53q\f\t\u0004\u0007CbaB\u00010\u0001\u00035i\u0017n\u001a:bi\u0016,e/\u001a8ugR!1qMB5!\u0019\u00199e!\u0014\u0002<!111\u000e'A\u0002M\fQ\u0002]3sg&\u001cH/\u001a8dK&#GCBB4\u0007_\u001a\t\b\u0003\u0004\u0004l5\u0003\ra\u001d\u0005\b\u0007gj\u0005\u0019AB;\u0003=\u0019WO\u001d:f]R\u0004&o\\4sKN\u001c\b#\u00022\u0002b\u000e]\u0004\u0003BB=\u0007\u001fsAaa\u001f\u0004\f:!1QPBE\u001d\u0011\u0019yha\"\u000f\t\r\u00055Q\u0011\b\u0004m\u000e\r\u0015\"A.\n\u0005eS\u0016BA,Y\u0013\t)f+C\u0002\u0004\u000eR\u000b\u0001#T5he\u0006$\u0018n\u001c8U_>dG)Y8\n\t\rE51\u0013\u0002\u0010\u0007V\u0014(/\u001a8u!J|wM]3tg*\u00191Q\u0012+\u0002)M,'/[1mSj,GMS8ve:\fGNU8x)\u0011\u0019Ija+\u0011\t\rm5Q\u0015\b\u0005\u0007;\u001b\tK\u0004\u0003\u0004~\r}\u0015b\u0001Bk-&!11\u0015Bj\u0003)Qu.\u001e:oC2$\u0015m\\\u0005\u0005\u0007O\u001bIK\u0001\u000bTKJL\u0017\r\\5{K\u0012Tu.\u001e:oC2\u0014vn\u001e\u0006\u0005\u0007G\u0013\u0019\u000eC\u0004\u0004.:\u0003\raa,\u0002\u0007\u0015tg\u000f\u0005\u0003\u00042\u000eMVBAB\u0002\u0013\u0011\u0019)la\u0001\u0003\u001b\u00153XM\u001c;F]Z,Gn\u001c9f\u0003=i\u0017n\u001a:bi\u0016\u001cf.\u00199tQ>$H\u0003BB^\u0007{\u0003baa\u0012\u0004N\u0005-\u0005BBB6\u001f\u0002\u00071\u000f\u0006\u0004\u0004<\u000e\u000571\u0019\u0005\u0007\u0007W\u0002\u0006\u0019A:\t\u000f\rM\u0004\u000b1\u0001\u0004v\u0005\u00192/\u001a:jC2L'0\u001a3T]\u0006\u0004x\u000e\u001e*poR!1\u0011ZBn!\u0011\u0019Ym!6\u000f\t\r57\u0011\u001b\b\u0005\u0007{\u001ay-C\u0002\u0003hZKAaa5\u0003f\u0006Y1K\\1qg\"|G\u000fR1p\u0013\u0011\u00199n!7\u0003+M+'/[1mSj,Gm\u00158baNDw\u000e\u001e*po*!11\u001bBs\u0011\u001d\u0019i.\u0015a\u0001\u0007?\f\u0001c]3mK\u000e$X\rZ*oCB\u001c\bn\u001c;\u0011\t\t54\u0011]\u0005\u0004\u0007GD&\u0001E*fY\u0016\u001cG/\u001a3T]\u0006\u00048\u000f[8u\u0003Iaw.\u00193T_V\u00148-Z*oCB\u001c\bn\u001c;\u0015\r\r%8Q^Bx!\u0019\u00199e!\u0014\u0004lB)!-!9\u0004`\"111\u000e*A\u0002MDqa!=S\u0001\u0004\tY$A\u0007nS:\u001cV-];f]\u000e,gJ\u001d")
public class MigrationTool {
    private ActorRef sourceSnapshotStore;
    private Future<Done> createProgressTable;
    public final ActorSystem<?> akka$persistence$r2dbc$migration$MigrationTool$$system;
    private final ActorSystem<?> sys;
    private final Logger akka$persistence$r2dbc$migration$MigrationTool$$log;
    private final Persistence persistenceExt;
    private final Config migrationConfig;
    private final int parallelism;
    private final String targetPluginId;
    private final R2dbcSettings targetR2dbcSettings;
    private final Serialization serialization;
    private final ConnectionFactory targetConnectionFactory;
    private final JournalDao akka$persistence$r2dbc$migration$MigrationTool$$targetJournalDao;
    private final SnapshotDao targetSnapshotDao;
    private final int targetBatch;
    private final String sourceQueryPluginId;
    private final ReadJournal sourceReadJournal;
    private final CurrentPersistenceIdsQuery sourcePersistenceIdsQuery;
    private final CurrentEventsByPersistenceIdQuery sourceEventsByPersistenceIdQuery;
    private final String sourceSnapshotPluginId;
    private final MigrationToolDao migrationDao;
    private volatile byte bitmap$0;

    public static void main(String[] args) {
        MigrationTool$.MODULE$.main(args);
    }

    private ActorSystem<?> sys() {
        return this.sys;
    }

    public Logger akka$persistence$r2dbc$migration$MigrationTool$$log() {
        return this.akka$persistence$r2dbc$migration$MigrationTool$$log;
    }

    private Persistence persistenceExt() {
        return this.persistenceExt;
    }

    private Config migrationConfig() {
        return this.migrationConfig;
    }

    private int parallelism() {
        return this.parallelism;
    }

    private String targetPluginId() {
        return this.targetPluginId;
    }

    private R2dbcSettings targetR2dbcSettings() {
        return this.targetR2dbcSettings;
    }

    private Serialization serialization() {
        return this.serialization;
    }

    private ConnectionFactory targetConnectionFactory() {
        return this.targetConnectionFactory;
    }

    public JournalDao akka$persistence$r2dbc$migration$MigrationTool$$targetJournalDao() {
        return this.akka$persistence$r2dbc$migration$MigrationTool$$targetJournalDao;
    }

    private SnapshotDao targetSnapshotDao() {
        return this.targetSnapshotDao;
    }

    private int targetBatch() {
        return this.targetBatch;
    }

    private String sourceQueryPluginId() {
        return this.sourceQueryPluginId;
    }

    private ReadJournal sourceReadJournal() {
        return this.sourceReadJournal;
    }

    private CurrentPersistenceIdsQuery sourcePersistenceIdsQuery() {
        return this.sourcePersistenceIdsQuery;
    }

    private CurrentEventsByPersistenceIdQuery sourceEventsByPersistenceIdQuery() {
        return this.sourceEventsByPersistenceIdQuery;
    }

    private String sourceSnapshotPluginId() {
        return this.sourceSnapshotPluginId;
    }

    private ActorRef sourceSnapshotStore$lzycompute() {
        MigrationTool migrationTool = this;
        synchronized (migrationTool) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Persistence qual$1 = (Persistence)Persistence$.MODULE$.apply(this.akka$persistence$r2dbc$migration$MigrationTool$$system);
                String x$1 = this.sourceSnapshotPluginId();
                Config x$2 = qual$1.snapshotStoreFor$default$2();
                this.sourceSnapshotStore = qual$1.snapshotStoreFor(x$1, x$2);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sourceSnapshotStore;
    }

    private ActorRef sourceSnapshotStore() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.sourceSnapshotStore$lzycompute();
        }
        return this.sourceSnapshotStore;
    }

    public MigrationToolDao migrationDao() {
        return this.migrationDao;
    }

    private Future<Done> createProgressTable$lzycompute() {
        MigrationTool migrationTool = this;
        synchronized (migrationTool) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.createProgressTable = this.migrationDao().createProgressTable();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.createProgressTable;
    }

    private Future<Done> createProgressTable() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.createProgressTable$lzycompute();
        }
        return this.createProgressTable;
    }

    public Future<Result> migrateAll() {
        this.akka$persistence$r2dbc$migration$MigrationTool$$log().info("Migration started.");
        Future result = (Future)((Source)this.sourcePersistenceIdsQuery().currentPersistenceIds().mapAsyncUnordered(this.parallelism(), (Function1 & Serializable)persistenceId -> this.createProgressTable().flatMap((Function1 & Serializable)x$1 -> {
            Done done = x$1;
            return this.migrationDao().currentProgress((String)persistenceId).flatMap((Function1 & Serializable)currentProgress -> this.migrateEvents((String)persistenceId, (Option<MigrationToolDao.CurrentProgress>)currentProgress).flatMap((Function1 & Serializable)eventCount -> MigrationTool.$anonfun$migrateAll$4(this, persistenceId, currentProgress, BoxesRunTime.unboxToLong((Object)eventCount)), (ExecutionContext)$this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext()), (ExecutionContext)$this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
        }, (ExecutionContext)$this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String pid = (String)tuple2._1();
                Result result = (Result)tuple2._2();
                if (result != null) {
                    long events = result.events();
                    long snapshots = result.snapshots();
                    package.LoggerOps$.MODULE$.debugN$extension(akka.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.akka$persistence$r2dbc$migration$MigrationTool$$log()), "Migrated persistenceId [{}] with [{}] events{}.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{pid, BoxesRunTime.boxToLong((long)events), snapshots == 0L ? "" : " and snapshot"}));
                    return result;
                }
            }
            throw new MatchError((Object)tuple2);
        })).runWith((Graph)Sink$.MODULE$.fold((Object)MigrationTool$Result$.MODULE$.empty(), (Function2 & Serializable)(x0$2, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 != null) {
                Result acc = (Result)tuple2._1();
                Result result = (Result)tuple2._2();
                if (result != null) {
                    long events = result.events();
                    long snapshots = result.snapshots();
                    Result result2 = new Result(acc.persistenceIds() + 1L, acc.events() + events, acc.snapshots() + snapshots);
                    if (result2.persistenceIds() % 100L == 0L) {
                        package.LoggerOps$.MODULE$.infoN$extension(akka.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.akka$persistence$r2dbc$migration$MigrationTool$$log()), "Migrated [{}] persistenceIds with [{}] events and [{}] snapshots.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)result2.persistenceIds()), BoxesRunTime.boxToLong((long)result2.events()), BoxesRunTime.boxToLong((long)result2.snapshots())}));
                    }
                    return result2;
                }
            }
            throw new MatchError((Object)tuple2);
        }), Materializer$.MODULE$.matFromSystem(this.sys()));
        return result.transform((Function1 & Serializable)x0$3 -> {
            Success success;
            Result result;
            Try try_ = x0$3;
            if (try_ instanceof Success && (result = (Result)(success = (Success)try_).value()) != null) {
                long persistenceIds = result.persistenceIds();
                long events = result.events();
                long snapshots = result.snapshots();
                package.LoggerOps$.MODULE$.infoN$extension(akka.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.akka$persistence$r2dbc$migration$MigrationTool$$log()), "Migration successful. Migrated [{}] persistenceIds with [{}] events and [{}] snapshots.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)persistenceIds), BoxesRunTime.boxToLong((long)events), BoxesRunTime.boxToLong((long)snapshots)}));
                return success;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exc = failure.exception();
                this.akka$persistence$r2dbc$migration$MigrationTool$$log().error("Migration failed.", exc);
                return failure;
            }
            throw new MatchError((Object)try_);
        }, (ExecutionContext)this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
    }

    public Future<Object> migrateEvents(String persistenceId) {
        return this.createProgressTable().flatMap((Function1 & Serializable)x$2 -> {
            Done done = x$2;
            return this.migrationDao().currentProgress(persistenceId).flatMap((Function1 & Serializable)currentProgress -> this.migrateEvents(persistenceId, (Option<MigrationToolDao.CurrentProgress>)currentProgress).map((Function1)(JFunction1.mcJJ.sp & Serializable)eventCount -> eventCount, (ExecutionContext)$this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext()), (ExecutionContext)$this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
        }, (ExecutionContext)this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
    }

    private Future<Object> migrateEvents(String persistenceId, Option<MigrationToolDao.CurrentProgress> currentProgress) {
        long progressSeqNr = BoxesRunTime.unboxToLong((Object)currentProgress.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.eventSeqNr())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        return (Future)((Source)this.sourceEventsByPersistenceIdQuery().currentEventsByPersistenceId(persistenceId, progressSeqNr + 1L, Long.MAX_VALUE).map((Function1 & Serializable)env -> this.serializedJournalRow((EventEnvelope)env)).grouped(this.targetBatch()).mapAsync(1, (Function1 & Serializable)events -> this.akka$persistence$r2dbc$migration$MigrationTool$$targetJournalDao().writeEvents(events).recoverWith((PartialFunction)new Serializable(this, (Seq)events){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ MigrationTool $outer;
            private final Seq events$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof R2dbcDataIntegrityViolationException) {
                    return (B1)Future$.MODULE$.sequence((IterableOnce)this.events$1.map((Function1 & Serializable)event -> $this.$outer.akka$persistence$r2dbc$migration$MigrationTool$$targetJournalDao().writeEvents((Seq)new .colon.colon(event, (List)Nil$.MODULE$)).recoverWith((PartialFunction)new Serializable(this, (JournalDao.SerializedJournalRow)event){
                        private static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$$nestedInanonfun$migrateEvents$7$1 $outer;
                        private final JournalDao.SerializedJournalRow event$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 instanceof R2dbcDataIntegrityViolationException) {
                                this.$outer.akka$persistence$r2dbc$migration$MigrationTool$$anonfun$$$outer().akka$persistence$r2dbc$migration$MigrationTool$$log().debug("event already exists, persistenceId [{}], seqNr [{}]", (Object)this.event$1.persistenceId(), (Object)BoxesRunTime.boxToLong((long)this.event$1.seqNr()));
                                return (B1)Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            return throwable instanceof R2dbcDataIntegrityViolationException;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.event$1 = event$1;
                        }
                    }, (ExecutionContext)$this.$outer.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext())), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.$outer.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof R2dbcDataIntegrityViolationException;
            }

            public /* synthetic */ MigrationTool akka$persistence$r2dbc$migration$MigrationTool$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.events$1 = events$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(akka.persistence.r2dbc.migration.MigrationTool$$anonfun$$nestedInanonfun$migrateEvents$7$1 akka.persistence.r2dbc.journal.JournalDao$SerializedJournalRow )}, serializedLambda);
            }
        }, (ExecutionContext)$this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext()).map((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)((JournalDao.SerializedJournalRow)events.last()).seqNr())), (Object)BoxesRunTime.boxToInteger((int)events.size())), (ExecutionContext)$this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext())).mapAsync(1, (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long seqNr = tuple2._1$mcJ$sp();
                int count = tuple2._2$mcI$sp();
                return this.migrationDao().updateEventProgress(persistenceId, seqNr).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)count), (ExecutionContext)$this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
            }
            throw new MatchError((Object)tuple2);
        })).runWith((Graph)Sink$.MODULE$.fold((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJI.sp & Serializable)(x0$2, x1$1) -> {
            Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(x0$2, x1$1);
            if (sp2 != null) {
                long acc = sp2._1$mcJ$sp();
                int count = sp2._2$mcI$sp();
                return acc + (long)count;
            }
            throw new MatchError((Object)sp2);
        }), Materializer$.MODULE$.matFromSystem(this.sys()));
    }

    private JournalDao.SerializedJournalRow serializedJournalRow(EventEnvelope env) {
        String entityType = PersistenceId$.MODULE$.extractEntityType(env.persistenceId());
        int slice = this.persistenceExt().sliceForPersistenceId(env.persistenceId());
        Object event = env.event();
        byte[] serialized = (byte[])this.serialization().serialize(event).get();
        Serializer serializer = this.serialization().findSerializerFor(event);
        String manifest = Serializers$.MODULE$.manifestFor(serializer, event);
        Option metadata = env.eventMetadata().map((Function1 & Serializable)meta -> {
            Object m = meta;
            byte[] serializedMeta = (byte[])this.serialization().serialize(m).get();
            Serializer metaSerializer = this.serialization().findSerializerFor(m);
            String metaManifest = Serializers$.MODULE$.manifestFor(metaSerializer, m);
            return new JournalDao.SerializedEventMetadata(metaSerializer.identifier(), metaManifest, serializedMeta);
        });
        return new JournalDao.SerializedJournalRow(slice, entityType, env.persistenceId(), env.sequenceNr(), Instant.ofEpochMilli(env.timestamp()), JournalDao$.MODULE$.EmptyDbTimestamp(), (Option)new Some((Object)serialized), serializer.identifier(), manifest, "", Predef$.MODULE$.Set().empty(), metadata);
    }

    public Future<Object> migrateSnapshot(String persistenceId) {
        return this.createProgressTable().flatMap((Function1 & Serializable)x$6 -> {
            Done done = x$6;
            return this.migrationDao().currentProgress(persistenceId).flatMap((Function1 & Serializable)currentProgress -> this.migrateSnapshot(persistenceId, (Option<MigrationToolDao.CurrentProgress>)currentProgress).map((Function1)(JFunction1.mcII.sp & Serializable)snapCount -> snapCount, (ExecutionContext)$this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext()), (ExecutionContext)$this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
        }, (ExecutionContext)this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
    }

    private Future<Object> migrateSnapshot(String persistenceId, Option<MigrationToolDao.CurrentProgress> currentProgress) {
        long progressSeqNr = BoxesRunTime.unboxToLong((Object)currentProgress.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.snapshotSeqNr())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        return this.loadSourceSnapshot(persistenceId, progressSeqNr + 1L).flatMap((Function1 & Serializable)x0$1 -> {
            Some some;
            SelectedSnapshot selectedSnapshot;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                return Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)0));
            }
            if (option instanceof Some && (selectedSnapshot = (SelectedSnapshot)(some = (Some)option).value()) != null) {
                SnapshotMetadata snapshotMetadata = selectedSnapshot.metadata();
                SnapshotDao.SerializedSnapshotRow serializedRow = this.serializedSnapotRow(selectedSnapshot);
                return this.targetSnapshotDao().store(serializedRow).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)snapshotMetadata.sequenceNr()), ExecutionContexts$.MODULE$.parasitic()).flatMap((Function1 & Serializable)seqNr -> MigrationTool.$anonfun$migrateSnapshot$8(this, persistenceId, BoxesRunTime.unboxToLong((Object)seqNr)), (ExecutionContext)$this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
            }
            throw new MatchError((Object)option);
        }, (ExecutionContext)this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
    }

    private SnapshotDao.SerializedSnapshotRow serializedSnapotRow(SelectedSnapshot selectedSnapshot) {
        SnapshotMetadata snapshotMetadata = selectedSnapshot.metadata();
        Object snapshotAnyRef = selectedSnapshot.snapshot();
        byte[] serializedSnapshot = (byte[])this.serialization().serialize(snapshotAnyRef).get();
        Serializer snapshotSerializer = this.serialization().findSerializerFor(snapshotAnyRef);
        String snapshotManifest = Serializers$.MODULE$.manifestFor(snapshotSerializer, snapshotAnyRef);
        Option serializedMeta = snapshotMetadata.metadata().map((Function1 & Serializable)meta -> {
            Object metaRef = meta;
            byte[] serializedMeta = (byte[])this.serialization().serialize(metaRef).get();
            Serializer metaSerializer = this.serialization().findSerializerFor(metaRef);
            String metaManifest = Serializers$.MODULE$.manifestFor(metaSerializer, metaRef);
            return new SnapshotDao.SerializedSnapshotMetadata(serializedMeta, metaSerializer.identifier(), metaManifest);
        });
        SnapshotDao.SerializedSnapshotRow serializedRow = new SnapshotDao.SerializedSnapshotRow(snapshotMetadata.persistenceId(), snapshotMetadata.sequenceNr(), snapshotMetadata.timestamp(), serializedSnapshot, snapshotSerializer.identifier(), snapshotManifest, serializedMeta);
        return serializedRow;
    }

    private Future<Option<SelectedSnapshot>> loadSourceSnapshot(String persistenceId, long minSequenceNr) {
        String string = this.sourceSnapshotPluginId();
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Future$.MODULE$.successful((Object)None$.MODULE$);
        }
        Timeout timeout = Timeout$.MODULE$.durationToTimeout(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        SnapshotSelectionCriteria criteria = SnapshotSelectionCriteria$.MODULE$.Latest();
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.sourceSnapshotStore());
        SnapshotProtocol.LoadSnapshot x$1 = new SnapshotProtocol.LoadSnapshot(persistenceId, criteria, Long.MAX_VALUE);
        Timeout x$2 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(SnapshotProtocol.LoadSnapshotResult.class)).map((Function1 & Serializable)result -> result.snapshot().flatMap((Function1 & Serializable)s -> {
            if (s.metadata().sequenceNr() >= minSequenceNr) {
                return new Some(s);
            }
            return None$.MODULE$;
        }), (ExecutionContext)this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$migrateAll$4(MigrationTool $this, String persistenceId$1, Option currentProgress$1, long eventCount) {
        return $this.migrateSnapshot(persistenceId$1, (Option<MigrationToolDao.CurrentProgress>)currentProgress$1).map((Function1 & Serializable)snapshotCount -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)persistenceId$1), (Object)new Result(1L, eventCount, BoxesRunTime.unboxToInt((Object)snapshotCount))), (ExecutionContext)$this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
    }

    public static final /* synthetic */ int $anonfun$migrateSnapshot$9(Done x$9) {
        Done done = x$9;
        return 1;
    }

    public static final /* synthetic */ Future $anonfun$migrateSnapshot$8(MigrationTool $this, String persistenceId$5, long seqNr) {
        return $this.migrationDao().updateSnapshotProgress(persistenceId$5, seqNr).map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)MigrationTool.$anonfun$migrateSnapshot$9(x$9)), (ExecutionContext)$this.akka$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
    }

    public MigrationTool(ActorSystem<?> system) {
        this.akka$persistence$r2dbc$migration$MigrationTool$$system = system;
        this.sys = system;
        this.akka$persistence$r2dbc$migration$MigrationTool$$log = LoggerFactory.getLogger(this.getClass());
        this.persistenceExt = (Persistence)Persistence$.MODULE$.apply(system);
        this.migrationConfig = system.settings().config().getConfig("akka.persistence.r2dbc.migration");
        this.parallelism = this.migrationConfig().getInt("parallelism");
        this.targetPluginId = this.migrationConfig().getString("target.persistence-plugin-id");
        this.targetR2dbcSettings = R2dbcSettings$.MODULE$.apply(system.settings().config().getConfig(this.targetPluginId()));
        this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(system);
        this.targetConnectionFactory = ((ConnectionFactoryProvider)ConnectionFactoryProvider$.MODULE$.apply(system)).connectionFactoryFor(new StringBuilder(19).append(this.targetPluginId()).append(".connection-factory").toString());
        this.akka$persistence$r2dbc$migration$MigrationTool$$targetJournalDao = new JournalDao(this.targetR2dbcSettings(), this.targetConnectionFactory(), (ExecutionContext)system.executionContext(), this.sys());
        this.targetSnapshotDao = new SnapshotDao(this.targetR2dbcSettings(), this.targetConnectionFactory(), (ExecutionContext)system.executionContext(), this.sys());
        this.targetBatch = this.migrationConfig().getInt("target.batch");
        this.sourceQueryPluginId = this.migrationConfig().getString("source.query-plugin-id");
        this.sourceReadJournal = ((PersistenceQuery)PersistenceQuery$.MODULE$.apply(system)).readJournalFor(this.sourceQueryPluginId());
        this.sourcePersistenceIdsQuery = (CurrentPersistenceIdsQuery)this.sourceReadJournal();
        this.sourceEventsByPersistenceIdQuery = (CurrentEventsByPersistenceIdQuery)this.sourceReadJournal();
        this.sourceSnapshotPluginId = this.migrationConfig().getString("source.snapshot-plugin-id");
        this.migrationDao = new MigrationToolDao(this.targetConnectionFactory(), this.targetR2dbcSettings().logDbCallsExceeding(), (ExecutionContext)system.executionContext(), this.sys());
    }

    public static final class Result
    implements Product,
    Serializable {
        private final long persistenceIds;
        private final long events;
        private final long snapshots;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long persistenceIds() {
            return this.persistenceIds;
        }

        public long events() {
            return this.events;
        }

        public long snapshots() {
            return this.snapshots;
        }

        public Result copy(long persistenceIds, long events, long snapshots) {
            return new Result(persistenceIds, events, snapshots);
        }

        public long copy$default$1() {
            return this.persistenceIds();
        }

        public long copy$default$2() {
            return this.events();
        }

        public long copy$default$3() {
            return this.snapshots();
        }

        public String productPrefix() {
            return "Result";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.persistenceIds());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.events());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.snapshots());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Result;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "persistenceIds";
                }
                case 1: {
                    return "events";
                }
                case 2: {
                    return "snapshots";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.persistenceIds()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.events()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.snapshots()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Result)) return false;
            boolean bl = true;
            if (!bl) return false;
            Result result = (Result)x$1;
            if (this.persistenceIds() != result.persistenceIds()) return false;
            if (this.events() != result.events()) return false;
            if (this.snapshots() != result.snapshots()) return false;
            return true;
        }

        public Result(long persistenceIds, long events, long snapshots) {
            this.persistenceIds = persistenceIds;
            this.events = events;
            this.snapshots = snapshots;
            Product.$init$((Product)this);
        }
    }
}

