/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.tasks;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;

public abstract class FailOnErrorTask
extends Task {
    private boolean _failOnError;

    public boolean isFailOnError() {
        return this._failOnError;
    }

    public final void setFailOnError(boolean failOnError) {
        this._failOnError = failOnError;
    }

    public void fatal(String message) {
        this.fatal(message, null, 0);
    }

    public void fatal(String message, int logLevel) {
        this.fatal(message, null, logLevel);
    }

    public void fatal(Throwable throwable) {
        this.fatal(null, throwable);
    }

    public void fatal(String message, Throwable throwable) {
        this.fatal(message, throwable, 0);
    }

    public void fatal(String message, Throwable throwable, int logLevel) {
        FailOnErrorTask.fatal(this, message, throwable, this._failOnError, logLevel);
    }

    public static void fatal(Task task, String message, Throwable throwable, boolean failOnError, int logLevel) {
        if (failOnError && message == null) {
            FailOnErrorTask.toss(null, throwable, task.getLocation());
        }
        StringBuilder buffer = new StringBuilder();
        if (failOnError) {
            buffer.append(task.getTaskName());
            buffer.append(" aborted");
        }
        if (message != null) {
            if (buffer.length() > 0) {
                buffer.append(": ");
            }
            buffer.append(message);
            if (throwable != null && throwable.getMessage() != null && !failOnError) {
                buffer.append(" (");
                buffer.append(throwable.getMessage());
                buffer.append(')');
            }
        } else if (throwable.getMessage() != null) {
            buffer.append(throwable.getMessage());
        }
        if (failOnError) {
            FailOnErrorTask.toss(buffer.toString(), throwable, task.getLocation());
        }
        task.log(buffer.toString(), logLevel);
    }

    private static void toss(String message, Throwable cause, Location location) {
        if (cause instanceof BuildException) {
            throw (BuildException)cause;
        }
        if (message == null || message.length() == 0) {
            throw new BuildException(cause, location);
        }
        throw new BuildException(message, cause, location);
    }
}

