/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls.types.validators;

import com.ibm.mantis.nls.MessageFile;
import com.ibm.mantis.nls.MessageTriplet;
import com.ibm.mantis.nls.types.validators.Validator;

public class MetadataValidator
extends Validator {
    @Override
    public void validate(MessageFile file) {
        if (!file.isMessageFileSet()) {
            this.fatal("ISMESSAGEFILE is unset");
        }
        if (file.getSourcePath() == null) {
            this.error("CMVCPATHNAME is unset");
        }
        if (file.getEncoding() == null) {
            this.fatal("NLS_ENCODING is unset");
        } else if (!file.getEncoding().equals("UNICODE")) {
            this.error("NLS_ENCODING is other than UNICODE");
        }
        if (file.getFormat() == null) {
            this.error("NLS_MESSAGEFORMAT unset or has an unsupported value");
        }
        if (file.isMessageFile()) {
            if (file.getComponentPrefixes().isEmpty()) {
                this.error("message files must have at least one registered component prefix");
            }
            for (MessageTriplet triplet : file.getTriplets().values()) {
                if (file.getComponentPrefixes().contains(triplet.getComponent())) continue;
                this.fatal(triplet.getKey(), " uses an unregistered component prefix (", triplet.getComponent(), ")");
            }
        }
    }
}

