/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls.types.validators;

import com.ibm.mantis.nls.MessageFile;
import com.ibm.mantis.nls.types.validators.Validator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;

public class DuplicateKeyValidator
extends Validator {
    private static final Pattern KEY_FINDER = Pattern.compile("^([a-zA-Z0-9\\._\\-]+)[ \\t]*=", 8);

    @Override
    public void validate(MessageFile file) {
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(file.getSource());
                MappedByteBuffer buffer = in.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.getSource().length());
                CharsetDecoder decoder = Charset.forName("ISO-8859-1").newDecoder();
                HashSet<String> uniqueKeys = new HashSet<String>();
                Matcher matcher = KEY_FINDER.matcher(decoder.decode(buffer));
                while (matcher.find()) {
                    String key = matcher.group(1);
                    if (uniqueKeys.contains(key)) {
                        this.error(key, " is duplicate key");
                        continue;
                    }
                    uniqueKeys.add(key);
                }
            }
            catch (IOException exp) {
                throw new BuildException((Throwable)exp);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            throw throwable;
        }
        FileUtils.close((InputStream)in);
    }
}

