/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls.types.validators;

import com.ibm.mantis.nls.MessageFile;
import com.ibm.mantis.nls.types.validators.Validator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public class ContentValidator
extends Validator {
    private Constraint _constraint;
    private Pattern _pattern;
    private String _message;
    private PatternSet _keyFilter;
    private Validator.LogLevel _logLevel = Validator.LogLevel.WARNING;
    private boolean _initialized;
    private String[] _includes;
    private String[] _excludes;

    public ContentValidator() {
        this._constraint = Constraint.disallowed;
    }

    public void setConstraint(Constraint constraint) {
        this._constraint = constraint;
    }

    public void setPattern(String pattern) {
        this._pattern = Pattern.compile(pattern);
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public void setLogLevel(String logLevel) {
        this._logLevel = Validator.LogLevel.valueOf(logLevel.toUpperCase(Locale.US));
    }

    public PatternSet createKeyFilter() {
        if (this._keyFilter != null) {
            throw new BuildException("only one key filter is allowed");
        }
        this._keyFilter = new PatternSet();
        return this._keyFilter;
    }

    @Override
    public void validate(MessageFile file) {
        if (this._pattern == null) {
            return;
        }
        for (Object key : file.getProperties().keySet()) {
            if (!this.acceptKey(key.toString())) continue;
            boolean found = this._pattern.matcher(file.getProperty(key.toString())).find();
            if (found && this._constraint == Constraint.disallowed) {
                this.log(this._logLevel, key.toString(), " ", this._message != null ? this._message : "disallowed content found");
                continue;
            }
            if (found || this._constraint != Constraint.required) continue;
            this.log(this._logLevel, key.toString(), " ", this._message != null ? this._message : "required content not found");
        }
    }

    private boolean acceptKey(String key) {
        if (this._keyFilter == null) {
            return true;
        }
        if (!this._initialized) {
            this._includes = this._keyFilter.getIncludePatterns(this.getProject());
            this._excludes = this._keyFilter.getExcludePatterns(this.getProject());
            this._initialized = true;
        }
        boolean result = this._includes == null;
        int i = 0;
        while (!result && this._includes != null && i < this._includes.length) {
            if (SelectorUtils.match((String)this._includes[i], (String)key)) {
                result = true;
            }
            ++i;
        }
        i = 0;
        while (result && this._excludes != null && i < this._excludes.length) {
            if (SelectorUtils.match((String)this._excludes[i], (String)key)) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public static enum Constraint {
        disallowed,
        required;

    }
}

