/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls.types.validators;

import com.ibm.mantis.nls.MessageFile;
import com.ibm.mantis.nls.types.validators.Validator;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class CompletenessValidator
extends Validator {
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("([A-Z0-9]{4,5})(\\d{4})([IWE]): .*");
    private boolean _messagesOnly = true;

    public void setMessagesOnly(boolean messagesOnly) {
        this._messagesOnly = messagesOnly;
    }

    @Override
    public void validate(MessageFile file) {
        if (!file.isMessageFile()) {
            this.validateNonMessageFile(file);
        } else {
            this.validateMessageFile(file);
        }
    }

    private void validateMessageFile(MessageFile file) {
        TreeSet<String> potentialKeys = new TreeSet<String>();
        for (Object o : file.getProperties().keySet()) {
            String key = o.toString();
            if (key.endsWith(".explanation") || key.endsWith(".useraction")) {
                potentialKeys.add(key.substring(0, key.lastIndexOf(46)));
                continue;
            }
            if (MESSAGE_PATTERN.matcher(file.getProperty(key)).matches()) {
                potentialKeys.add(key);
                continue;
            }
            if (!this._messagesOnly) continue;
            this.warning(key, " does not appear to be part of a message");
        }
        for (String key : potentialKeys) {
            String message = file.getProperty(key);
            String explanation = file.getProperty(key.concat(".explanation"));
            String userAction = file.getProperty(key.concat(".useraction"));
            if (message != null) {
                if (explanation == null && userAction == null) {
                    this.fatal(key, " message content found for base key but explanation and useraction are missing");
                    continue;
                }
                if (explanation == null) {
                    this.fatal(key, " message content found for base key but explanation is missing");
                    continue;
                }
                if (userAction != null) continue;
                this.fatal(key, " message content found for base key but useraction is missing");
                continue;
            }
            this.fatal(key, explanation == null ? " useraction" : (userAction == null ? " explanation" : " explanation and useraction"), " found for base key but message content is missing");
        }
    }

    private void validateNonMessageFile(MessageFile file) {
        for (Object o : file.getProperties().keySet()) {
            String key = o.toString();
            if (key.endsWith(".explanation")) {
                this.warning(key, " explanation key found in non-message file");
                continue;
            }
            if (key.endsWith(".useraction")) {
                this.warning(key, " useraction key found in non-message file");
                continue;
            }
            if (!MESSAGE_PATTERN.matcher(file.getProperty(key)).matches()) continue;
            this.warning(key, " message content found in a non-message file");
        }
    }
}

