/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls.types.transformers;

import com.ibm.mantis.nls.MessageFile;
import com.ibm.mantis.nls.MessageTriplet;
import com.ibm.mantis.nls.types.transformers.Transformer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class TMSTransformer
extends Transformer {
    private static final Pattern SPLIT = Pattern.compile("(.*)_([a-z]+(_[A-Z]+)?)(\\..+)?");
    private FileNameMapper _mapper;

    @Override
    public boolean transform(MessageFile file, String destPath) throws IOException {
        if (!file.isMessageFile()) {
            return false;
        }
        File destination = new File(this.getDest(), destPath);
        File parent = destination.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        PrintWriter writer = null;
        try {
            FileOutputStream fout = new FileOutputStream(destination);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fout, "UTF-8");
            writer = new PrintWriter(osw);
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<?xml-stylesheet type=\"text/css\" href=\"../../resources/stylesheets/wasmsgxml.css\"?>");
            writer.println("<TMSSource name=\"TivoliMessages\" tmsVersion=\"1.0\" xml:lang=\"en\">");
            writer.print("<!-- CMVC MSG File Name = ");
            writer.print(file.getSourcePath());
            writer.println(" -->");
            writer.println("<!-- DO NOT EDIT THIS FILE - This file was generated by the XML/Html & Property emitter -->");
            writer.println("<!-- BEGIN MESSAGES -->");
            for (MessageTriplet triplet : file.getTriplets().values()) {
                writer.print("<Message ID=\"");
                writer.print(triplet.getID());
                writer.print("\" severity=\"");
                writer.print(triplet.getSeverity());
                writer.println("\" prefix=\"yes\">");
                writer.print("  <MsgText pgmKey=\"");
                writer.print(StringEscapeUtils.escapeXml((String)triplet.getKey()));
                writer.println("\" varFormat=\"Java\">");
                writer.print("    ");
                writer.print(StringEscapeUtils.escapeXml((String)triplet.getKey()));
                writer.print('=');
                writer.println(StringEscapeUtils.escapeXml((String)triplet.getMessage()));
                writer.println("  </MsgText>");
                writer.println("  <Explanation>");
                writer.print("    ");
                writer.println(StringEscapeUtils.escapeXml((String)triplet.getExplanation()));
                writer.println("  </Explanation>");
                writer.println("  <UserResponse>");
                writer.print("    ");
                writer.println(StringEscapeUtils.escapeXml((String)triplet.getUserAction()));
                writer.println("  </UserResponse>");
                writer.println("</Message>");
            }
            writer.println("<!-- END MESSAGES -->");
            writer.println("</TMSSource>");
        }
        catch (Throwable throwable) {
            FileUtils.close(writer);
            throw throwable;
        }
        FileUtils.close((Writer)writer);
        return true;
    }

    @Override
    public FileNameMapper getMapper() {
        if (this._mapper == null) {
            this._mapper = new TMSMapper();
        }
        return this._mapper;
    }

    private static final class TMSMapper
    implements FileNameMapper {
        private TMSMapper() {
        }

        public void setFrom(String from) {
        }

        public void setTo(String to) {
        }

        public String[] mapFileName(String sourceFileName) {
            Matcher matcher = SPLIT.matcher(sourceFileName);
            if (!matcher.matches()) {
                return null;
            }
            StringBuilder result = new StringBuilder();
            result.append(matcher.group(2));
            result.append('/');
            result.append(matcher.group(1).replace('/', '.').replace('\\', '.'));
            result.append(".xml");
            return new String[]{result.toString()};
        }
    }
}

