/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls.types.transformers;

import com.ibm.mantis.io.EncodingPrintWriter;
import com.ibm.mantis.nls.MessageFile;
import com.ibm.mantis.nls.types.transformers.FilteringTransformer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.RegexpPatternMapper;

public class PropertiesTransformer
extends FilteringTransformer {
    private RegexpPatternMapper _mapper;

    @Override
    public boolean transform(MessageFile file, String destPath) throws IOException {
        File destination = new File(this.getDest(), destPath);
        File parent = destination.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (Object key : file.getProperties().keySet()) {
            if (!this.acceptKey(key.toString())) continue;
            keys.add(key.toString());
        }
        Collections.sort(keys);
        EncodingPrintWriter writer = null;
        try {
            writer = new EncodingPrintWriter(new FileWriter(destination));
            for (String key : keys) {
                writer.setPropertyEncoding(true);
                writer.print(key);
                writer.setEncoding(false);
                writer.print('=');
                writer.setEncoding(true);
                writer.print(file.getProperty(key));
                writer.setEncoding(false);
                writer.println();
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(writer);
            throw throwable;
        }
        FileUtils.close((Writer)writer);
        return true;
    }

    @Override
    public FileNameMapper getMapper() {
        if (this._mapper == null) {
            this._mapper = new RegexpPatternMapper();
            this._mapper.setFrom("^(.+)\\..*?$");
            this._mapper.setTo("\\1.properties");
        }
        return this._mapper;
    }
}

