/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls.types.transformers;

import com.ibm.mantis.io.EncodingPrintWriter;
import com.ibm.mantis.nls.MessageFile;
import com.ibm.mantis.nls.types.transformers.FilteringTransformer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.RegexpPatternMapper;

public class JavaTransformer
extends FilteringTransformer {
    private RegexpPatternMapper _mapper;

    @Override
    public boolean transform(MessageFile file, String destPath) throws IOException {
        File destination = new File(this.getDest(), destPath);
        File parent = destination.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        String packageName = destPath.replace('\\', '/');
        packageName = packageName.substring(0, packageName.lastIndexOf(47));
        packageName = packageName.replace('/', '.');
        String className = destination.getName();
        className = className.substring(0, className.lastIndexOf(46));
        ArrayList<String> keys = new ArrayList<String>();
        for (Object key : file.getProperties().keySet()) {
            if (!this.acceptKey(key.toString())) continue;
            keys.add(key.toString());
        }
        Collections.sort(keys);
        EncodingPrintWriter writer = null;
        try {
            writer = new EncodingPrintWriter(new FileWriter(destination));
            writer.setEncoding(false);
            writer.println("/**");
            writer.println(" * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED!  DO NOT MODIFY IT!");
            writer.print(" * Generated on ");
            writer.println(new Date());
            writer.println(" */");
            writer.println();
            writer.print("package ");
            writer.print(packageName);
            writer.println(";");
            writer.println();
            writer.print("public class ");
            writer.print(className);
            writer.println(" extends java.util.ListResourceBundle");
            writer.println('{');
            writer.println("   public Object[][] getContents() {");
            writer.println("       return resources;");
            writer.println("   }");
            writer.println("   private final static Object[][] resources= {");
            Iterator k = keys.iterator();
            while (k.hasNext()) {
                String key = (String)k.next();
                writer.write("      { \"");
                writer.setJavaEncoding(true);
                writer.write(key);
                writer.setEncoding(false);
                writer.write("\", \"");
                writer.setJavaEncoding(true);
                writer.write(file.getProperty(key));
                writer.setEncoding(false);
                writer.print("\" }");
                if (k.hasNext()) {
                    writer.println(',');
                    continue;
                }
                writer.println();
            }
            writer.println("   };");
            writer.println("}");
        }
        catch (Throwable throwable) {
            FileUtils.close(writer);
            throw throwable;
        }
        FileUtils.close((Writer)writer);
        return true;
    }

    @Override
    public FileNameMapper getMapper() {
        if (this._mapper == null) {
            this._mapper = new RegexpPatternMapper();
            this._mapper.setFrom("^(.+)\\..*?$");
            this._mapper.setTo("\\1.java");
        }
        return this._mapper;
    }
}

