/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls.types.transformers;

import com.ibm.mantis.nls.types.transformers.Transformer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public abstract class FilteringTransformer
extends Transformer {
    private PatternSet _keyFilter;
    private boolean _initialized;
    private String[] _includes;
    private String[] _excludes;

    public PatternSet createKeyFilter() {
        if (this._keyFilter != null) {
            throw new BuildException("only one key filter is allowed");
        }
        this._keyFilter = new PatternSet();
        return this._keyFilter;
    }

    protected boolean acceptKey(String key) {
        if (this._keyFilter == null) {
            return true;
        }
        if (!this._initialized) {
            this._includes = this._keyFilter.getIncludePatterns(this.getProject());
            this._excludes = this._keyFilter.getExcludePatterns(this.getProject());
            this._initialized = true;
        }
        boolean result = this._includes == null;
        int i = 0;
        while (!result && this._includes != null && i < this._includes.length) {
            if (SelectorUtils.match((String)this._includes[i], (String)key)) {
                result = true;
            }
            ++i;
        }
        i = 0;
        while (result && this._excludes != null && i < this._excludes.length) {
            if (SelectorUtils.match((String)this._excludes[i], (String)key)) {
                result = false;
            }
            ++i;
        }
        return result;
    }
}

