/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.util.FileUtils;

public class EncodingTable
extends DataType {
    protected Properties _encodings;

    public EncodingTable() {
        this._encodings = new Properties();
    }

    public EncodingTable(Properties encodings) {
        this._encodings = encodings;
    }

    public void setEncodings(File encodingsFile) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(encodingsFile);
                Properties temp = new Properties();
                temp.load(in);
                for (Object locale : temp.keySet()) {
                    this.map(locale.toString(), temp.getProperty(locale.toString()));
                }
            }
            catch (IOException exp) {
                throw new BuildException((Throwable)exp);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            throw throwable;
        }
        FileUtils.close((InputStream)in);
    }

    public void addConfiguredEncoding(LocaleEncoding encoding) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.map(encoding._locale, encoding._encoding);
    }

    public Properties getEncodings() {
        if (this.isReference()) {
            return this.getRef().getEncodings();
        }
        return this._encodings;
    }

    public String findEncodingFor(String fileName) {
        for (Object key : this.getEncodings().keySet()) {
            if (!fileName.endsWith(key.toString())) continue;
            return this.getEncodings().getProperty(key.toString());
        }
        return null;
    }

    protected void map(String locale, String encoding) {
        if (locale == null) {
            throw new BuildException("locale must not be null");
        }
        if (encoding == null) {
            throw new BuildException("encoding must not be null");
        }
        if (this._encodings.contains(locale) && !this._encodings.getProperty(locale).equals(encoding)) {
            this.log(String.valueOf(locale) + " will not be remapped to " + encoding + " as it is already mapped to " + this._encodings.getProperty(locale), 1);
            return;
        }
        this._encodings.setProperty(locale, encoding);
    }

    protected EncodingTable getRef() {
        Object o;
        if (!this.isChecked()) {
            Stack<EncodingTable> stack = new Stack<EncodingTable>();
            stack.push(this);
            this.dieOnCircularReference(stack, this.getProject());
        }
        if (!((o = this.getRefid().getReferencedObject(this.getProject())) instanceof EncodingTable)) {
            throw new BuildException(String.valueOf(this.getRefid().getRefId()) + " doesn't denote an encodingtable");
        }
        return (EncodingTable)((Object)o);
    }

    public static class LocaleEncoding {
        protected String _locale;
        protected String _encoding;

        public void setEncoding(String encoding) {
            this._encoding = encoding;
        }

        public void setLocale(String locale) {
            this._locale = locale;
        }
    }
}

