/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls.tasks;

import com.ibm.mantis.nls.MessageFile;
import com.ibm.mantis.nls.types.validators.Validator;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class Validate
extends Task {
    private List<FileSet> _filesets = new LinkedList<FileSet>();
    private List<Validator> _validators = new LinkedList<Validator>();
    private List<String> _warnings = new LinkedList<String>();
    private List<String> _errors = new LinkedList<String>();
    private List<String> _fatals = new LinkedList<String>();
    private int _totalProblems;
    private int _fatalCount;

    public void add(FileSet set) {
        this._filesets.add(set);
    }

    public void addConfigured(Validator validator) {
        if (!validator.isDisabled()) {
            validator.setOwningTask(this);
            this._validators.add(validator);
        }
    }

    public void log(String msg, int msgLevel) {
        if (msgLevel == Validator.LogLevel.WARNING.getLevel()) {
            ++this._totalProblems;
            this._warnings.add(msg);
        } else if (msgLevel == Validator.LogLevel.ERROR.getLevel()) {
            ++this._totalProblems;
            this._errors.add(msg);
        } else if (msgLevel == Validator.LogLevel.FATAL.getLevel()) {
            ++this._totalProblems;
            ++this._fatalCount;
            this._fatals.add(msg);
        } else {
            super.log(msg, msgLevel);
        }
    }

    public void execute() {
        for (FileSet fs : this._filesets) {
            LinkedList<MessageFile> files = new LinkedList<MessageFile>();
            try {
                String[] stringArray = fs.getDirectoryScanner().getIncludedFiles();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    files.add(new MessageFile(new File(fs.getDir(), string)));
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
            this.log("validating " + files.size() + " file(s) from " + fs.getDir(), 3);
            for (MessageFile messageFile : files) {
                this._warnings.clear();
                this._errors.clear();
                this._fatals.clear();
                for (Validator validator : this._validators) {
                    try {
                        validator.validate(messageFile);
                    }
                    catch (BuildException exp) {
                        this.log(exp.getMessage(), -1);
                    }
                }
                if (this._warnings.size() + this._errors.size() + this._fatals.size() <= 0) continue;
                StringBuilder temp = new StringBuilder();
                if (!this._warnings.isEmpty()) {
                    temp.append(this._warnings.size());
                    temp.append(this._warnings.size() == 1 ? " warning" : " warnings");
                }
                if (!this._errors.isEmpty()) {
                    if (temp.length() > 0) {
                        temp.append(", ");
                    }
                    temp.append(this._errors.size());
                    temp.append(this._errors.size() == 1 ? " error" : " errors");
                }
                if (!this._fatals.isEmpty()) {
                    if (temp.length() > 0) {
                        temp.append(", ");
                    }
                    temp.append(this._fatals.size());
                    temp.append(this._fatals.size() == 1 ? " fatal error" : " fatal errors");
                }
                temp.insert(0, ": ");
                temp.insert(0, messageFile.getSource().getAbsolutePath());
                super.log(temp.toString());
                for (String warning : this._warnings) {
                    super.log("  (warning) " + warning, 1);
                }
                for (String error : this._errors) {
                    super.log("  (error) " + error, 0);
                }
                for (String fatal : this._fatals) {
                    super.log("  (fatal) " + fatal, 0);
                }
            }
        }
        if (this._totalProblems > 0) {
            this.log("found " + this._totalProblems + " validation problem(s)");
        }
        if (this._fatalCount > 0) {
            throw new BuildException("found " + this._fatalCount + " fatal validation problem(s)");
        }
        this._filesets.clear();
        this._filesets = null;
        this._validators.clear();
        this._validators = null;
    }
}

