/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls.tasks;

import com.ibm.mantis.nls.MessageFile;
import com.ibm.mantis.nls.types.transformers.Transformer;
import com.ibm.mantis.tasks.FailOnErrorTask;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Transform
extends FailOnErrorTask {
    private List<FileSet> _filesets = new LinkedList<FileSet>();
    private List<Transformer> _transformers = new LinkedList<Transformer>();

    public void add(FileSet fileset) {
        this._filesets.add(fileset);
    }

    public void addConfigured(Transformer transformer) {
        if (!transformer.isDisabled()) {
            transformer.setOwningTask(this);
            this._transformers.add(transformer);
        }
    }

    public void execute() {
        for (Transformer transformer : this._transformers) {
            SourceFileScanner scanner = new SourceFileScanner((Task)this);
            FileNameMapper mapper = transformer.getMapper();
            for (FileSet fs : this._filesets) {
                String[] files = scanner.restrict(fs.getDirectoryScanner().getIncludedFiles(), fs.getDir(), transformer.getDest(), mapper);
                this.log("transforming " + files.length + " file(s) from " + fs.getDir().getAbsolutePath(), 3);
                int transformCount = 0;
                String[] stringArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    try {
                        MessageFile messages = new MessageFile(new File(fs.getDir(), file));
                        String[] stringArray2 = mapper.mapFileName(file);
                        int n3 = stringArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String dest = stringArray2[n4];
                            this.log("transforming " + file + " to " + dest + " with " + transformer.getClass().getCanonicalName(), 3);
                            if (transformer.transform(messages, dest)) {
                                ++transformCount;
                            } else {
                                this.log("tranform aborted by transformer", 3);
                            }
                            ++n4;
                        }
                    }
                    catch (IOException exp) {
                        this.fatal("error transforming " + file, exp);
                    }
                    ++n2;
                }
                if (transformCount <= 0) continue;
                this.log("transformed " + transformCount + " file(s)");
            }
        }
        this._transformers.clear();
        this._transformers = null;
        this._filesets.clear();
        this._filesets = null;
    }
}

