/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls.tasks;

import com.ibm.mantis.nls.io.UnicodeEscapedASCIIWriter;
import com.ibm.mantis.nls.types.EncodingTable;
import com.ibm.mantis.tasks.FailOnErrorTask;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Normalize
extends FailOnErrorTask {
    private static final int BUFFER_SIZE = 128;
    private List<FileSet> _filesets = new LinkedList<FileSet>();
    private File _dest;
    private String _defaultEncoding = System.getProperty("file.encoding");
    private Mapper _mapper;
    private EncodingTable _encodingTable;

    public void add(FileSet fileset) {
        this._filesets.add(fileset);
    }

    public void setDest(File dest) {
        this._dest = dest;
    }

    public void setDefaultEncoding(String defaultCodePage) {
        this._defaultEncoding = defaultCodePage;
    }

    public Mapper createMapper() {
        if (this._mapper != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this._mapper = new Mapper(this.getProject());
        return this._mapper;
    }

    public void add(FileNameMapper mapper) {
        this.createMapper().add(mapper);
    }

    public void add(EncodingTable encodingTable) {
        if (this._encodingTable != null) {
            throw new BuildException("Cannot provide more than one encoding table", this.getLocation());
        }
        this._encodingTable = encodingTable;
    }

    public void execute() {
        this.validateAttributes();
        SourceFileScanner scanner = new SourceFileScanner((Task)this);
        for (FileSet fs : this._filesets) {
            String[] files = scanner.restrict(fs.getDirectoryScanner().getIncludedFiles(), fs.getDir(), this._dest, this.getFileNameMapper());
            this.log("processing " + files.length + " file(s) from " + fs.getDir().getAbsolutePath(), 3);
            int i = 0;
            while (i < files.length) {
                this.process(fs.getDir(), files[i]);
                ++i;
            }
            if (files.length <= 0) continue;
            this.log("normalized " + files.length + " file(s)");
        }
    }

    private void validateAttributes() {
        if (this._dest == null) {
            throw new BuildException("The dest attribute must be set", this.getLocation());
        }
        if (this._dest.exists() && !this._dest.isDirectory()) {
            throw new BuildException(String.valueOf(this._dest.getAbsolutePath()) + " is not a directory", this.getLocation());
        }
    }

    private FileNameMapper getFileNameMapper() {
        if (this._mapper == null) {
            this.createMapper().add((FileNameMapper)new IdentityMapper());
        }
        return this._mapper.getImplementation();
    }

    private void process(File src, String sourceFilePath) {
        block8: {
            File destinationDir;
            File sourceFile = new File(src, sourceFilePath);
            String sourceEncoding = this.determineEncoding(sourceFilePath);
            File destinationFile = this.determineTarget(sourceFilePath);
            if (sourceEncoding == null) {
                sourceEncoding = this._defaultEncoding;
                this.log("couldn't determine encoding for " + sourceEncoding + "; defaulting to " + sourceEncoding, 3);
            }
            if (!(destinationDir = destinationFile.getParentFile()).exists()) {
                destinationDir.mkdirs();
            }
            Reader reader = null;
            Writer writer = null;
            try {
                try {
                    this.log("normalizing " + sourceFile.getAbsolutePath() + " from encoding " + sourceEncoding, 3);
                    reader = this.getReader(sourceFile, sourceEncoding);
                    writer = this.getWriter(destinationFile);
                    char[] buffer = new char[128];
                    int read = reader.read(buffer);
                    while (read != -1) {
                        writer.write(buffer, 0, read);
                        read = reader.read(buffer);
                    }
                }
                catch (Exception exp) {
                    this.fatal("error normalizing " + sourceFile.getAbsolutePath(), exp);
                    FileUtils.close(reader);
                    FileUtils.close(writer);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(reader);
                FileUtils.close(writer);
                throw throwable;
            }
            FileUtils.close((Reader)reader);
            FileUtils.close((Writer)writer);
        }
    }

    private File determineTarget(String sourceFilePath) {
        String[] mapped = this.getFileNameMapper().mapFileName(sourceFilePath);
        if (mapped == null || mapped.length == 0) {
            throw new BuildException("Failed to map " + sourceFilePath + " to a corresponding target path", this.getLocation());
        }
        return new File(this._dest, mapped[0]);
    }

    private String determineEncoding(String sourceFilePath) {
        if (this._encodingTable == null) {
            return null;
        }
        int lastPeriod = sourceFilePath.lastIndexOf(".");
        if (lastPeriod > 0) {
            sourceFilePath = sourceFilePath.substring(0, lastPeriod);
        }
        return this._encodingTable.findEncodingFor(sourceFilePath);
    }

    private Reader getReader(File source, String encoding) throws IOException {
        FileInputStream fis = new FileInputStream(source);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, encoding);
        return new BufferedReader(isr);
    }

    private Writer getWriter(File destination) throws IOException {
        FileOutputStream fout = new FileOutputStream(destination);
        OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fout, "ISO-8859-1");
        return new BufferedWriter(new UnicodeEscapedASCIIWriter(osr));
    }
}

