/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls.tasks;

import com.ibm.mantis.collections.Bucket;
import com.ibm.mantis.collections.BucketClassifier;
import com.ibm.mantis.collections.ListSieve;
import com.ibm.mantis.tasks.helpers.QuietCopy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.filters.TokenFilter;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Commonize
extends Task {
    private static final String ENCODING = "ISO-8859-1";
    private static final Pattern LOCALE_PATTERN = Pattern.compile("(.*)_([a-z]+(_[A-Z]+)?)(\\.(.+))?");
    private static final LocaleClassifier CLASSIFIER = new LocaleClassifier();
    private List<FileSet> _filesets = new LinkedList<FileSet>();
    private File _dest;
    private File _commonMessageFile;
    private Mapper _mapper;
    private boolean _firstOnly = true;

    private static final String escape(String s) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c < ' ' || c > '~') {
                result.append("\\u");
                String hex = Integer.toHexString(c);
                int p = hex.length();
                while (p < 4) {
                    result.append('0');
                    ++p;
                }
                result.append(hex);
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public void add(FileSet fileset) {
        this._filesets.add(fileset);
    }

    public void setDest(File dest) {
        this._dest = dest;
    }

    public void setFirstOnly(boolean firstOnly) {
        this._firstOnly = firstOnly;
    }

    public void setCommonMessageFile(File commonMessageFile) {
        this._commonMessageFile = commonMessageFile;
    }

    public Mapper createMapper() throws BuildException {
        if (this._mapper != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this._mapper = new Mapper(this.getProject());
        return this._mapper;
    }

    public void add(FileNameMapper mapper) {
        this.createMapper().add(mapper);
    }

    public void execute() {
        this.validateAttributes();
        SourceFileScanner scanner = new SourceFileScanner((Task)this);
        for (FileSet fs : this._filesets) {
            String[] files = scanner.restrict(fs.getDirectoryScanner().getIncludedFiles(), fs.getDir(), this._dest, this.getFileNameMapper());
            ListSieve localeFiles = new ListSieve((BucketClassifier)CLASSIFIER);
            localeFiles.addAll(Arrays.asList(files));
            this.log(String.valueOf(localeFiles.size()) + " total buckets", 4);
            for (Bucket bucket : localeFiles.getBuckets()) {
                String locale = (String)bucket.getKey();
                this.log("processing " + locale, 4);
                FileList filelist = new FileList();
                filelist.setProject(this.getProject());
                filelist.setDir(fs.getDir());
                for (String path : bucket) {
                    FileList.FileName fn = new FileList.FileName();
                    fn.setName(path);
                    filelist.addConfiguredFile(fn);
                }
                QuietCopy copy = new QuietCopy(this);
                copy.setTodir(this._dest);
                copy.setEncoding(ENCODING);
                copy.setOutputEncoding(ENCODING);
                copy.add((ResourceCollection)filelist);
                copy.add(this.getFileNameMapper());
                Properties commonMessages = this.loadCommonMessages(locale);
                if (!commonMessages.isEmpty()) {
                    FilterChain filters = copy.createFilterChain();
                    for (Object k : commonMessages.keySet()) {
                        String key = k.toString();
                        String message = Commonize.escape(commonMessages.getProperty(key));
                        TokenFilter.ReplaceString replace = new TokenFilter.ReplaceString();
                        replace.setProject(this.getProject());
                        if (this._firstOnly) {
                            replace.setFrom("=".concat(key));
                            replace.setTo("=".concat(message));
                        } else {
                            replace.setFrom(key);
                            replace.setTo(message);
                        }
                        filters.add((ChainableReader)replace);
                    }
                }
                copy.execute();
            }
        }
    }

    private void validateAttributes() {
        if (this._dest == null) {
            throw new BuildException("The dest attribute must be set", this.getLocation());
        }
        if (this._dest.exists() && !this._dest.isDirectory()) {
            throw new BuildException(String.valueOf(this._dest.getAbsolutePath()) + " is not a directory", this.getLocation());
        }
        if (this._commonMessageFile == null) {
            throw new BuildException("The commonmessagefile attribute must be set", this.getLocation());
        }
        if (!this._commonMessageFile.exists()) {
            throw new BuildException(String.valueOf(this._commonMessageFile.getAbsolutePath()) + " does not exist", this.getLocation());
        }
        if (!this._commonMessageFile.isFile()) {
            throw new BuildException(String.valueOf(this._commonMessageFile.getAbsolutePath()) + " is not a file", this.getLocation());
        }
    }

    private FileNameMapper getFileNameMapper() {
        if (this._mapper == null) {
            this.createMapper().add((FileNameMapper)new IdentityMapper());
        }
        return this._mapper.getImplementation();
    }

    private Properties loadCommonMessages(String locale) {
        File parent = this._commonMessageFile.getParentFile();
        String name = this._commonMessageFile.getName();
        int extIndex = name.lastIndexOf(46);
        String basename = extIndex < 0 ? name : name.substring(0, extIndex);
        String extension = extIndex < 0 ? "" : name.substring(extIndex);
        File file = null;
        while (file == null) {
            if (locale == null || locale.length() == 0) {
                file = this._commonMessageFile;
            } else {
                StringBuilder temp = new StringBuilder();
                temp.append(basename);
                temp.append('_');
                temp.append(locale);
                temp.append(extension);
                file = new File(parent, temp.toString());
            }
            if (file.exists()) continue;
            file = null;
            if (locale == null) continue;
            int uIndex = locale.lastIndexOf(95);
            locale = uIndex < 0 ? null : locale.substring(0, uIndex);
        }
        Properties result = new Properties();
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(file);
                result.load(in);
            }
            catch (IOException exp) {
                throw new BuildException("failed to open common message file " + file.getAbsolutePath(), (Throwable)exp, this.getLocation());
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            throw throwable;
        }
        FileUtils.close((InputStream)in);
        return result;
    }

    private static final class LocaleClassifier
    implements BucketClassifier<String> {
        private LocaleClassifier() {
        }

        public Object getBucketKey(String e) {
            Matcher matcher = LOCALE_PATTERN.matcher(e);
            if (matcher.matches()) {
                return matcher.group(2);
            }
            return null;
        }
    }
}

