/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public final class UnicodeEscapedASCIIWriter
extends FilterWriter {
    public UnicodeEscapedASCIIWriter(Writer writer) {
        super(writer);
    }

    @Override
    public void write(int c) throws IOException {
        if (c > 126) {
            super.write("\\u");
            String hex = Integer.toHexString(c);
            int i = hex.length();
            while (i < 4) {
                super.write(48);
                ++i;
            }
            super.write(hex);
        } else {
            super.write(c);
        }
    }

    @Override
    public void write(char[] chars, int offset, int length) throws IOException {
        int i = offset;
        while (i < length) {
            this.write(chars[i]);
            ++i;
        }
    }

    @Override
    public void write(String str, int offset, int length) throws IOException {
        int i = offset;
        while (i < length) {
            this.write(str.charAt(i));
            ++i;
        }
    }
}

