/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageTriplet {
    public static final String USER_ACTION = ".useraction";
    public static final String EXPLANATION = ".explanation";
    private static final Pattern PARSER = Pattern.compile("^(([A-Z0-9]{4,5})\\d{4}([IWEA])): .*\\z", 40);
    private final String _key;
    private final String _component;
    private final String _id;
    private final String _severity;
    private final String _message;
    private final String _explanation;
    private final String _userAction;
    private final boolean _valid;

    public MessageTriplet(String key, String message, String explanation, String userAction) {
        this._key = key;
        this._message = message;
        this._explanation = explanation;
        this._userAction = userAction;
        Matcher matcher = null;
        if (message != null) {
            matcher = PARSER.matcher(message);
        }
        if (matcher != null && matcher.matches()) {
            this._component = matcher.group(2);
            this._id = matcher.group(1);
            this._severity = matcher.group(3);
        } else {
            this._component = null;
            this._id = null;
            this._severity = null;
        }
        this._valid = this._key != null && this._id != null && this._severity != null && this._message != null && this._explanation != null && this._userAction != null;
    }

    public boolean isValid() {
        return this._valid;
    }

    public String getKey() {
        return this._key;
    }

    public boolean hasExplanation() {
        return this._explanation != null;
    }

    public String getExplanation() {
        return this._explanation;
    }

    public boolean hasMessage() {
        return this._message != null;
    }

    public String getMessage() {
        return this._message;
    }

    public String getComponent() {
        return this._component;
    }

    public String getID() {
        return this._id;
    }

    public String getBaseID() {
        if (this._id != null) {
            return this._id.substring(0, this._id.length() - 1);
        }
        return null;
    }

    public String getSeverity() {
        return this._severity;
    }

    public boolean hasUserAction() {
        return this._userAction != null;
    }

    public String getUserAction() {
        return this._userAction;
    }
}

