/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls;

import com.ibm.mantis.nls.MessageFile;
import com.ibm.mantis.nls.MessageTriplet;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Set;
import junit.framework.TestCase;

public class MessageFileTest
extends TestCase {
    public MessageFileTest(String name) {
        super(name);
    }

    public void testStress() {
        LinkedList<File> queue = new LinkedList<File>();
        queue.addLast(new File("tests/nlsprops"));
        while (!queue.isEmpty()) {
            File current = (File)queue.removeFirst();
            if (current.isDirectory()) {
                File[] fileArray = current.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    queue.addLast(child);
                    ++n2;
                }
                continue;
            }
            try {
                new MessageFile(current);
            }
            catch (IOException exp) {
                MessageFileTest.fail((String)current.getAbsolutePath());
            }
        }
    }

    public void testValidOrNull() throws IOException {
        MessageFile file = this.getMessageFile("admin.appmgmt/AppDeploymentMessages.nlsprops");
        MessageFileTest.assertNull((Object)file.getTriplet("ADMA0508E"));
        MessageFileTest.assertNull((Object)file.getTriplet("ADMA0508I"));
        MessageFileTest.assertTrue((boolean)file.getTriplet("ADMA5016I").isValid());
        MessageFileTest.assertTrue((boolean)file.containsKey("ADMA0508I"));
        MessageFileTest.assertFalse((boolean)file.containsKey("ADMA0508E"));
        MessageFileTest.assertTrue((boolean)file.containsKey("ADMA0508E.explanation"));
        MessageFileTest.assertTrue((boolean)file.containsKey("ADMA0508E.useraction"));
    }

    public void testMetadata() throws IOException {
        MessageFile file = this.getMessageFile("admin.appmgmt/BindEarCmd.nlsprops");
        MessageFileTest.assertEquals((String)"SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/resources/BindEarCmd.nlsprops", (String)file.getSourcePath());
        MessageFileTest.assertTrue((boolean)file.isMessageFile());
        MessageFileTest.assertEquals((String)"UNICODE", (String)file.getEncoding());
        MessageFileTest.assertEquals((Object)((Object)MessageFile.MessageFormat.VAR), (Object)((Object)file.getFormat()));
        Set<String> prefixes = file.getComponentPrefixes();
        MessageFileTest.assertEquals((int)1, (int)prefixes.size());
        MessageFileTest.assertTrue((boolean)prefixes.contains("BNDE"));
        MessageFileTest.assertEquals((String)"WebSphere Management Subsystem", (String)file.getComponentDescription("BNDE"));
    }

    public void testMultiplePrefixes() throws IOException {
        MessageFile file = this.getMessageFile("resources/seriousMessages.nlsprops");
        Set<String> prefixes = file.getComponentPrefixes();
        MessageFileTest.assertEquals((int)4, (int)prefixes.size());
        MessageFileTest.assertTrue((boolean)prefixes.contains("WTRN"));
        MessageFileTest.assertTrue((boolean)prefixes.contains("NMSV"));
        MessageFileTest.assertTrue((boolean)prefixes.contains("PLGN"));
        MessageFileTest.assertTrue((boolean)prefixes.contains("SRVE"));
        MessageFileTest.assertEquals((String)"JNDI Name Services", (String)file.getComponentDescription("NMSV"));
        MessageFileTest.assertEquals((String)"Webserver Plugins and Native Code", (String)file.getComponentDescription("PLGN"));
        MessageFileTest.assertEquals((String)"Servlet Engine", (String)file.getComponentDescription("SRVE"));
        MessageFileTest.assertEquals((String)"WebSphere Transactions", (String)file.getComponentDescription("WTRN"));
    }

    public void testWhitespace() throws IOException {
        MessageFile file = this.getMessageFile("webservices/enablerMessages.nlsprops");
        String property = file.getProperty("enabler.usage_syntax");
        MessageTriplet triplet = file.getTriplet("enabler.usage_syntax");
        MessageFileTest.assertNotNull((Object)triplet);
        MessageFileTest.assertEquals((String)property, (String)triplet.getMessage());
    }

    public void testJ2C() throws IOException {
        MessageFile file = this.getMessageFile("j2c/J2CAMessages.nlsprops");
        MessageFileTest.assertTrue((boolean)file.isMessageFileSet());
        MessageFileTest.assertTrue((boolean)file.isMessageFile());
        MessageFileTest.assertEquals((int)256, (int)file.getTriplets().size());
    }

    private File getFile(String path) {
        return new File("tests/nlsprops", path);
    }

    private MessageFile getMessageFile(String path) throws IOException {
        return new MessageFile(this.getFile(path));
    }
}

