/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.nls;

import com.ibm.mantis.nls.MessageTriplet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.util.FileUtils;

public class MessageFile {
    private static final Comparator<MessageTriplet> BY_KEY = new KeyComparator();
    private static final Comparator<MessageTriplet> BY_ID = new IDComparator();
    private static final Pattern METAPATTERN;
    private File _source;
    private Map<String, MessageTriplet> _triplets;
    private Properties _properties;
    private MessageFormat _format;
    private String _sourcePath;
    private boolean _messageFile;
    private boolean _messageFileSet;
    private Set<String> _componentPrefixes;
    private Map<String, String> _componentDescriptions;
    private String _encoding;

    static {
        StringBuilder temp = new StringBuilder();
        temp.append('^');
        temp.append("[ \\t]*");
        temp.append("#+");
        temp.append("[ \\t]*");
        temp.append("(CMVCPATHNAME[ \\t]+(\\S+))");
        temp.append("|(ISMESSAGEFILE[ \\t]+(\\w+))");
        temp.append("|(COMPONENTPREFIX[ \\t]+(.+$))");
        temp.append("|(COMPONENTNAMEFOR[ \\t]+(\\w{4,5})[ \\t]+(.+))");
        temp.append("|(NLS_ENCODING=(\\w+))");
        temp.append("|(NLS_MESSAGEFORMAT_ALL)");
        temp.append("|(NLS_MESSAGEFORMAT_VAR)");
        temp.append("|(NLS_MESSAGEFORMAT_NONE)");
        METAPATTERN = Pattern.compile(temp.toString(), 8);
    }

    public MessageFile(File source) throws IOException {
        this._source = source;
        this._triplets = new LinkedHashMap<String, MessageTriplet>();
        this._properties = new Properties();
        this._componentPrefixes = new LinkedHashSet<String>();
        this._componentDescriptions = new HashMap<String, String>();
        FileInputStream in = null;
        try {
            in = new FileInputStream(source);
            MappedByteBuffer buffer = in.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, source.length());
            CharsetDecoder decoder = Charset.forName("ISO-8859-1").newDecoder();
            Matcher matcher = METAPATTERN.matcher(decoder.decode(buffer));
            while (matcher.find()) {
                if (matcher.group(1) != null) {
                    this._sourcePath = matcher.group(2);
                    continue;
                }
                if (matcher.group(3) != null) {
                    this._messageFile = BooleanUtils.toBoolean((String)matcher.group(4));
                    this._messageFileSet = true;
                    continue;
                }
                if (matcher.group(5) != null) {
                    String[] stringArray = matcher.group(6).split("[ \\t]+");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String prefix = stringArray[n2];
                        this._componentPrefixes.add(prefix);
                        ++n2;
                    }
                    continue;
                }
                if (matcher.group(7) != null) {
                    this._componentDescriptions.put(matcher.group(8), matcher.group(9));
                    continue;
                }
                if (matcher.group(10) != null) {
                    this._encoding = matcher.group(11);
                    continue;
                }
                if (matcher.group(12) != null) {
                    this._format = MessageFormat.ALL;
                    continue;
                }
                if (matcher.group(13) != null) {
                    this._format = MessageFormat.VAR;
                    continue;
                }
                if (matcher.group(14) == null) continue;
                this._format = MessageFormat.NONE;
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            throw throwable;
        }
        FileUtils.close((InputStream)in);
        try {
            in = new FileInputStream(source);
            this._properties.load(in);
            if (this._messageFile) {
                for (Object o : this._properties.keySet()) {
                    String userAction;
                    String explanation;
                    String message;
                    MessageTriplet triplet;
                    String key = o.toString();
                    if (key.endsWith(".explanation") || key.endsWith(".useraction") || this._triplets.containsKey(key) || !(triplet = new MessageTriplet(key, message = StringUtils.trimToNull((String)this._properties.getProperty(key)), explanation = StringUtils.trimToNull((String)this._properties.getProperty(key.concat(".explanation"))), userAction = StringUtils.trimToNull((String)this._properties.getProperty(key.concat(".useraction"))))).isValid()) continue;
                    this._triplets.put(key, triplet);
                }
            }
            this._triplets = Collections.unmodifiableMap(this._triplets);
        }
        finally {
            FileUtils.close((InputStream)in);
        }
    }

    public File getSource() {
        return this._source;
    }

    public MessageFormat getFormat() {
        return this._format;
    }

    public String getSourcePath() {
        return this._sourcePath;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public boolean isMessageFile() {
        return this._messageFile;
    }

    public boolean isMessageFileSet() {
        return this._messageFileSet;
    }

    public Set<String> getComponentPrefixes() {
        return this._componentPrefixes;
    }

    public String getComponentDescription(String prefix) {
        return this._componentDescriptions.get(prefix);
    }

    public boolean containsKey(String key) {
        return this._properties.containsKey(key);
    }

    public Properties getProperties() {
        return this._properties;
    }

    public String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    public boolean containsTriplet(String key) {
        return this._triplets.containsKey(key);
    }

    public Map<String, MessageTriplet> getTriplets() {
        return this._triplets;
    }

    public MessageTriplet getTriplet(String key) {
        return this._triplets.get(key);
    }

    public List<MessageTriplet> getTripletByKey() {
        ArrayList<MessageTriplet> result = new ArrayList<MessageTriplet>(this._triplets.values());
        Collections.sort(result, BY_KEY);
        return result;
    }

    public List<MessageTriplet> getTripletByID() {
        ArrayList<MessageTriplet> result = new ArrayList<MessageTriplet>(this._triplets.values());
        Collections.sort(result, BY_ID);
        return result;
    }

    private static class IDComparator
    implements Comparator<MessageTriplet> {
        private IDComparator() {
        }

        @Override
        public int compare(MessageTriplet o1, MessageTriplet o2) {
            return o1.getID().compareTo(o2.getID());
        }
    }

    private static class KeyComparator
    implements Comparator<MessageTriplet> {
        private KeyComparator() {
        }

        @Override
        public int compare(MessageTriplet o1, MessageTriplet o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    }

    public static enum MessageFormat {
        ALL,
        NONE,
        VAR;

    }
}

