/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mantis.io;

import java.io.PrintWriter;
import java.io.Writer;

public class EncodingPrintWriter
extends PrintWriter {
    private static final String specialKeyChars = "=: \t\r\n\f#!";
    private static final String specialJavaChars = "\"";
    private boolean _encoding = false;
    private String _specialChars = null;

    public EncodingPrintWriter(Writer w) {
        super(w);
    }

    public void setEncoding(boolean encode) {
        this._encoding = encode;
        this._specialChars = null;
    }

    public void setJavaEncoding(boolean encode) {
        this._encoding = encode;
        this._specialChars = encode ? specialJavaChars : null;
    }

    public void setPropertyEncoding(boolean encode) {
        this._encoding = encode;
        this._specialChars = encode ? specialKeyChars : null;
    }

    public void write(String s, int off, int len) {
        this.write(s.toCharArray(), off, len);
    }

    public void write(char[] buf, int off, int len) {
        int i = off;
        int end = off + len;
        while (i < end) {
            this.write(buf[i]);
            ++i;
        }
    }

    public void write(int c) {
        if (this._encoding) {
            switch (c) {
                case 92: {
                    super.write(92);
                    super.write(92);
                    break;
                }
                case 9: {
                    super.write(92);
                    super.write(116);
                    break;
                }
                case 10: {
                    super.write(92);
                    super.write(110);
                    break;
                }
                case 13: {
                    super.write(92);
                    super.write(114);
                    break;
                }
                case 12: {
                    super.write(92);
                    super.write(102);
                    break;
                }
                default: {
                    if (c < 32 || c > 126) {
                        super.write(92);
                        super.write(117);
                        super.write(this.toHex(c >> 12 & 0xF));
                        super.write(this.toHex(c >> 8 & 0xF));
                        super.write(this.toHex(c >> 4 & 0xF));
                        super.write(this.toHex(c & 0xF));
                        break;
                    }
                    if (this._specialChars != null && this._specialChars.indexOf(c) != -1) {
                        super.write(92);
                    }
                    super.write(c);
                    break;
                }
            }
        } else {
            super.write(c);
        }
    }

    private int toHex(int c) {
        return c > 9 ? c - 10 + 97 : 48 + c;
    }
}

