/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.Scheduler;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.Nullable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ReplayProcessor<T>
extends FlowableProcessor<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    final ReplayBuffer<T> buffer;
    boolean done;
    final AtomicReference<ReplaySubscription<T>[]> subscribers;
    static final ReplaySubscription[] EMPTY = new ReplaySubscription[0];
    static final ReplaySubscription[] TERMINATED = new ReplaySubscription[0];

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> create() {
        return new ReplayProcessor(new UnboundedReplayBuffer(16));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> create(int capacityHint) {
        return new ReplayProcessor(new UnboundedReplayBuffer(capacityHint));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> createWithSize(int maxSize) {
        return new ReplayProcessor(new SizeBoundReplayBuffer(maxSize));
    }

    static <T> ReplayProcessor<T> createUnbounded() {
        return new ReplayProcessor(new SizeBoundReplayBuffer(Integer.MAX_VALUE));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> createWithTime(long maxAge, TimeUnit unit, Scheduler scheduler) {
        return new ReplayProcessor(new SizeAndTimeBoundReplayBuffer(Integer.MAX_VALUE, maxAge, unit, scheduler));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> createWithTimeAndSize(long maxAge, TimeUnit unit, Scheduler scheduler, int maxSize) {
        return new ReplayProcessor(new SizeAndTimeBoundReplayBuffer(maxSize, maxAge, unit, scheduler));
    }

    ReplayProcessor(ReplayBuffer<T> buffer) {
        this.buffer = buffer;
        this.subscribers = new AtomicReference<ReplaySubscription[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        ReplaySubscription<? super T> rs = new ReplaySubscription<T>(s2, this);
        s2.onSubscribe(rs);
        if (this.add(rs) && rs.cancelled) {
            this.remove(rs);
            return;
        }
        this.buffer.replay(rs);
    }

    @Override
    public void onSubscribe(Subscription s2) {
        if (this.done) {
            s2.cancel();
            return;
        }
        s2.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t) {
        ObjectHelper.requireNonNull(t, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.done) {
            return;
        }
        ReplayBuffer<T> b = this.buffer;
        b.next(t);
        for (ReplaySubscription<T> rs : this.subscribers.get()) {
            b.replay(rs);
        }
    }

    @Override
    public void onError(Throwable t) {
        ObjectHelper.requireNonNull(t, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.done = true;
        ReplayBuffer<T> b = this.buffer;
        b.error(t);
        for (ReplaySubscription rs : this.subscribers.getAndSet(TERMINATED)) {
            b.replay(rs);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        ReplayBuffer<T> b = this.buffer;
        b.complete();
        for (ReplaySubscription rs : this.subscribers.getAndSet(TERMINATED)) {
            b.replay(rs);
        }
    }

    @Override
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    int subscriberCount() {
        return this.subscribers.get().length;
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        ReplayBuffer<T> b = this.buffer;
        if (b.isDone()) {
            return b.getError();
        }
        return null;
    }

    public void cleanupBuffer() {
        this.buffer.trimHead();
    }

    public T getValue() {
        return this.buffer.getValue();
    }

    public Object[] getValues() {
        Object[] a = EMPTY_ARRAY;
        Object[] b = this.getValues(a);
        if (b == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b;
    }

    public T[] getValues(T[] array) {
        return this.buffer.getValues(array);
    }

    @Override
    public boolean hasComplete() {
        ReplayBuffer<T> b = this.buffer;
        return b.isDone() && b.getError() == null;
    }

    @Override
    public boolean hasThrowable() {
        ReplayBuffer<T> b = this.buffer;
        return b.isDone() && b.getError() != null;
    }

    public boolean hasValue() {
        return this.buffer.size() != 0;
    }

    int size() {
        return this.buffer.size();
    }

    boolean add(ReplaySubscription<T> rs) {
        ReplaySubscription[] b;
        ReplaySubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int len = a.length;
            b = new ReplaySubscription[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = rs;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void remove(ReplaySubscription<T> rs) {
        ReplaySubscription[] b;
        ReplaySubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED || a == EMPTY) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != rs) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                b = EMPTY;
                continue;
            }
            b = new ReplaySubscription[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    implements ReplayBuffer<T> {
        final int maxSize;
        final long maxAge;
        final TimeUnit unit;
        final Scheduler scheduler;
        int size;
        volatile TimedNode<T> head;
        TimedNode<T> tail;
        Throwable error;
        volatile boolean done;

        SizeAndTimeBoundReplayBuffer(int maxSize, long maxAge, TimeUnit unit, Scheduler scheduler) {
            this.maxSize = ObjectHelper.verifyPositive(maxSize, "maxSize");
            this.maxAge = ObjectHelper.verifyPositive(maxAge, "maxAge");
            this.unit = ObjectHelper.requireNonNull(unit, "unit is null");
            this.scheduler = ObjectHelper.requireNonNull(scheduler, "scheduler is null");
            TimedNode<Object> h2 = new TimedNode<Object>(null, 0L);
            this.tail = h2;
            this.head = h2;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                TimedNode<T> h2 = this.head;
                this.head = (TimedNode)h2.get();
            }
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h3 = this.head;
            while (true) {
                TimedNode next;
                if ((next = (TimedNode)h3.get()) == null) {
                    this.head = h3;
                    break;
                }
                if (next.time > limit) {
                    this.head = h3;
                    break;
                }
                h3 = next;
            }
        }

        void trimFinal() {
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h2 = this.head;
            while (true) {
                TimedNode next;
                if ((next = (TimedNode)h2.get()) == null) {
                    if (h2.value != null) {
                        this.head = new TimedNode<Object>(null, 0L);
                        break;
                    }
                    this.head = h2;
                    break;
                }
                if (next.time > limit) {
                    if (h2.value != null) {
                        TimedNode<Object> n = new TimedNode<Object>(null, 0L);
                        n.lazySet(h2.get());
                        this.head = n;
                        break;
                    }
                    this.head = h2;
                    break;
                }
                h2 = next;
            }
        }

        @Override
        public void trimHead() {
            if (this.head.value != null) {
                TimedNode<Object> n = new TimedNode<Object>(null, 0L);
                n.lazySet(this.head.get());
                this.head = n;
            }
        }

        @Override
        public void next(T value) {
            TimedNode<T> n = new TimedNode<T>(value, this.scheduler.now(this.unit));
            TimedNode<T> t = this.tail;
            this.tail = n;
            ++this.size;
            t.set(n);
            this.trim();
        }

        @Override
        public void error(Throwable ex) {
            this.trimFinal();
            this.error = ex;
            this.done = true;
        }

        @Override
        public void complete() {
            this.trimFinal();
            this.done = true;
        }

        @Override
        @Nullable
        public T getValue() {
            TimedNode next;
            TimedNode h2 = this.head;
            while ((next = (TimedNode)h2.get()) != null) {
                h2 = next;
            }
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            if (h2.time < limit) {
                return null;
            }
            return h2.value;
        }

        @Override
        public T[] getValues(T[] array) {
            TimedNode h2 = this.getHead();
            int s2 = this.size(h2);
            if (s2 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s2) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
                }
                for (int i = 0; i != s2; ++i) {
                    TimedNode next = (TimedNode)h2.get();
                    array[i] = next.value;
                    h2 = next;
                }
                if (array.length > s2) {
                    array[s2] = null;
                }
            }
            return array;
        }

        TimedNode<T> getHead() {
            long ts;
            TimedNode index = this.head;
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode next = (TimedNode)index.get();
            while (next != null && (ts = next.time) <= limit) {
                index = next;
                next = (TimedNode)index.get();
            }
            return index;
        }

        @Override
        public void replay(ReplaySubscription<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = rs.downstream;
            TimedNode index = (TimedNode)rs.index;
            if (index == null) {
                index = this.getHead();
            }
            long e = rs.emitted;
            do {
                boolean d;
                long r = rs.requested.get();
                while (e != r) {
                    boolean empty;
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d = this.done;
                    TimedNode next = (TimedNode)index.get();
                    boolean bl = empty = next == null;
                    if (d && empty) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(next.value);
                    ++e;
                    index = next;
                }
                if (e == r) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d = this.done;
                    if (d && index.get() == null) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                }
                rs.index = index;
                rs.emitted = e;
            } while ((missed = rs.addAndGet(-missed)) != 0);
        }

        @Override
        public int size() {
            return this.size(this.getHead());
        }

        int size(TimedNode<T> h2) {
            TimedNode next;
            int s2;
            for (s2 = 0; s2 != Integer.MAX_VALUE && (next = (TimedNode)h2.get()) != null; ++s2) {
                h2 = next;
            }
            return s2;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }
    }

    static final class SizeBoundReplayBuffer<T>
    implements ReplayBuffer<T> {
        final int maxSize;
        int size;
        volatile Node<T> head;
        Node<T> tail;
        Throwable error;
        volatile boolean done;

        SizeBoundReplayBuffer(int maxSize) {
            this.maxSize = ObjectHelper.verifyPositive(maxSize, "maxSize");
            Node<Object> h2 = new Node<Object>(null);
            this.tail = h2;
            this.head = h2;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                Node<T> h2 = this.head;
                this.head = (Node)h2.get();
            }
        }

        @Override
        public void next(T value) {
            Node<T> n = new Node<T>(value);
            Node<T> t = this.tail;
            this.tail = n;
            ++this.size;
            t.set(n);
            this.trim();
        }

        @Override
        public void error(Throwable ex) {
            this.error = ex;
            this.trimHead();
            this.done = true;
        }

        @Override
        public void complete() {
            this.trimHead();
            this.done = true;
        }

        @Override
        public void trimHead() {
            if (this.head.value != null) {
                Node<Object> n = new Node<Object>(null);
                n.lazySet(this.head.get());
                this.head = n;
            }
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public T getValue() {
            Node h2 = this.head;
            Node n;
            while ((n = (Node)h2.get()) != null) {
                h2 = n;
            }
            return h2.value;
        }

        @Override
        public T[] getValues(T[] array) {
            Node next;
            Node h2;
            int s2 = 0;
            Node h0 = h2 = this.head;
            while ((next = (Node)h0.get()) != null) {
                ++s2;
                h0 = next;
            }
            if (array.length < s2) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
            }
            for (int j = 0; j < s2; ++j) {
                h2 = (Node)h2.get();
                array[j] = h2.value;
            }
            if (array.length > s2) {
                array[s2] = null;
            }
            return array;
        }

        @Override
        public void replay(ReplaySubscription<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = rs.downstream;
            Node index = (Node)rs.index;
            if (index == null) {
                index = this.head;
            }
            long e = rs.emitted;
            do {
                boolean d;
                long r = rs.requested.get();
                while (e != r) {
                    boolean empty;
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d = this.done;
                    Node next = (Node)index.get();
                    boolean bl = empty = next == null;
                    if (d && empty) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(next.value);
                    ++e;
                    index = next;
                }
                if (e == r) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d = this.done;
                    if (d && index.get() == null) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                }
                rs.index = index;
                rs.emitted = e;
            } while ((missed = rs.addAndGet(-missed)) != 0);
        }

        @Override
        public int size() {
            Node next;
            int s2;
            Node h2 = this.head;
            for (s2 = 0; s2 != Integer.MAX_VALUE && (next = (Node)h2.get()) != null; ++s2) {
                h2 = next;
            }
            return s2;
        }
    }

    static final class TimedNode<T>
    extends AtomicReference<TimedNode<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;
        final long time;

        TimedNode(T value, long time) {
            this.value = value;
            this.time = time;
        }
    }

    static final class Node<T>
    extends AtomicReference<Node<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;

        Node(T value) {
            this.value = value;
        }
    }

    static final class UnboundedReplayBuffer<T>
    implements ReplayBuffer<T> {
        final List<T> buffer;
        Throwable error;
        volatile boolean done;
        volatile int size;

        UnboundedReplayBuffer(int capacityHint) {
            this.buffer = new ArrayList<T>(ObjectHelper.verifyPositive(capacityHint, "capacityHint"));
        }

        @Override
        public void next(T value) {
            this.buffer.add(value);
            ++this.size;
        }

        @Override
        public void error(Throwable ex) {
            this.error = ex;
            this.done = true;
        }

        @Override
        public void complete() {
            this.done = true;
        }

        @Override
        public void trimHead() {
        }

        @Override
        @Nullable
        public T getValue() {
            int s2 = this.size;
            if (s2 == 0) {
                return null;
            }
            return this.buffer.get(s2 - 1);
        }

        @Override
        public T[] getValues(T[] array) {
            int s2 = this.size;
            if (s2 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            List<T> b = this.buffer;
            if (array.length < s2) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
            }
            for (int i = 0; i < s2; ++i) {
                array[i] = b.get(i);
            }
            if (array.length > s2) {
                array[s2] = null;
            }
            return array;
        }

        @Override
        public void replay(ReplaySubscription<T> rs) {
            int index;
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            List<T> b = this.buffer;
            Subscriber<T> a = rs.downstream;
            Integer indexObject = (Integer)rs.index;
            if (indexObject != null) {
                index = indexObject;
            } else {
                index = 0;
                rs.index = 0;
            }
            long e = rs.emitted;
            do {
                int s2;
                boolean d;
                long r = rs.requested.get();
                while (e != r) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d = this.done;
                    s2 = this.size;
                    if (d && index == s2) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                    if (index == s2) break;
                    a.onNext(b.get(index));
                    ++index;
                    ++e;
                }
                if (e == r) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d = this.done;
                    s2 = this.size;
                    if (d && index == s2) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                }
                rs.index = index;
                rs.emitted = e;
            } while ((missed = rs.addAndGet(-missed)) != 0);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }
    }

    static final class ReplaySubscription<T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = 466549804534799122L;
        final Subscriber<? super T> downstream;
        final ReplayProcessor<T> state;
        Object index;
        final AtomicLong requested;
        volatile boolean cancelled;
        long emitted;

        ReplaySubscription(Subscriber<? super T> actual, ReplayProcessor<T> state) {
            this.downstream = actual;
            this.state = state;
            this.requested = new AtomicLong();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.state.buffer.replay(this);
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }
    }

    static interface ReplayBuffer<T> {
        public void next(T var1);

        public void error(Throwable var1);

        public void complete();

        public void replay(ReplaySubscription<T> var1);

        public int size();

        @Nullable
        public T getValue();

        public T[] getValues(T[] var1);

        public boolean isDone();

        public Throwable getError();

        public void trimHead();
    }
}

