/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.annotations.BackpressureKind;
import io.reactivex.annotations.BackpressureSupport;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.SchedulerSupport;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@BackpressureSupport(value=BackpressureKind.FULL)
@SchedulerSupport(value="none")
public final class MulticastProcessor<T>
extends FlowableProcessor<T> {
    final AtomicInteger wip;
    final AtomicReference<Subscription> upstream;
    final AtomicReference<MulticastSubscription<T>[]> subscribers;
    final AtomicBoolean once;
    final int bufferSize;
    final int limit;
    final boolean refcount;
    volatile SimpleQueue<T> queue;
    volatile boolean done;
    volatile Throwable error;
    int consumed;
    int fusionMode;
    static final MulticastSubscription[] EMPTY = new MulticastSubscription[0];
    static final MulticastSubscription[] TERMINATED = new MulticastSubscription[0];

    @CheckReturnValue
    @NonNull
    public static <T> MulticastProcessor<T> create() {
        return new MulticastProcessor<T>(MulticastProcessor.bufferSize(), false);
    }

    @CheckReturnValue
    @NonNull
    public static <T> MulticastProcessor<T> create(boolean refCount) {
        return new MulticastProcessor<T>(MulticastProcessor.bufferSize(), refCount);
    }

    @CheckReturnValue
    @NonNull
    public static <T> MulticastProcessor<T> create(int bufferSize) {
        return new MulticastProcessor<T>(bufferSize, false);
    }

    @CheckReturnValue
    @NonNull
    public static <T> MulticastProcessor<T> create(int bufferSize, boolean refCount) {
        return new MulticastProcessor<T>(bufferSize, refCount);
    }

    MulticastProcessor(int bufferSize, boolean refCount) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        this.bufferSize = bufferSize;
        this.limit = bufferSize - (bufferSize >> 2);
        this.wip = new AtomicInteger();
        this.subscribers = new AtomicReference<MulticastSubscription[]>(EMPTY);
        this.upstream = new AtomicReference();
        this.refcount = refCount;
        this.once = new AtomicBoolean();
    }

    public void start() {
        if (SubscriptionHelper.setOnce(this.upstream, EmptySubscription.INSTANCE)) {
            this.queue = new SpscArrayQueue<T>(this.bufferSize);
        }
    }

    public void startUnbounded() {
        if (SubscriptionHelper.setOnce(this.upstream, EmptySubscription.INSTANCE)) {
            this.queue = new SpscLinkedArrayQueue(this.bufferSize);
        }
    }

    @Override
    public void onSubscribe(Subscription s2) {
        if (SubscriptionHelper.setOnce(this.upstream, s2)) {
            if (s2 instanceof QueueSubscription) {
                QueueSubscription qs = (QueueSubscription)s2;
                int m3 = qs.requestFusion(3);
                if (m3 == 1) {
                    this.fusionMode = m3;
                    this.queue = qs;
                    this.done = true;
                    this.drain();
                    return;
                }
                if (m3 == 2) {
                    this.fusionMode = m3;
                    this.queue = qs;
                    s2.request(this.bufferSize);
                    return;
                }
            }
            this.queue = new SpscArrayQueue<T>(this.bufferSize);
            s2.request(this.bufferSize);
        }
    }

    @Override
    public void onNext(T t) {
        if (this.once.get()) {
            return;
        }
        if (this.fusionMode == 0) {
            ObjectHelper.requireNonNull(t, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
            if (!this.queue.offer(t)) {
                SubscriptionHelper.cancel(this.upstream);
                this.onError(new MissingBackpressureException());
                return;
            }
        }
        this.drain();
    }

    public boolean offer(T t) {
        if (this.once.get()) {
            return false;
        }
        ObjectHelper.requireNonNull(t, "offer called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.fusionMode == 0 && this.queue.offer(t)) {
            this.drain();
            return true;
        }
        return false;
    }

    @Override
    public void onError(Throwable t) {
        ObjectHelper.requireNonNull(t, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.once.compareAndSet(false, true)) {
            this.error = t;
            this.done = true;
            this.drain();
        } else {
            RxJavaPlugins.onError(t);
        }
    }

    @Override
    public void onComplete() {
        if (this.once.compareAndSet(false, true)) {
            this.done = true;
            this.drain();
        }
    }

    @Override
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    public boolean hasThrowable() {
        return this.once.get() && this.error != null;
    }

    @Override
    public boolean hasComplete() {
        return this.once.get() && this.error == null;
    }

    @Override
    public Throwable getThrowable() {
        return this.once.get() ? this.error : null;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        MulticastSubscription<T> ms = new MulticastSubscription<T>(s2, this);
        s2.onSubscribe(ms);
        if (this.add(ms)) {
            if (ms.get() == Long.MIN_VALUE) {
                this.remove(ms);
            } else {
                this.drain();
            }
        } else {
            Throwable ex;
            if ((this.once.get() || !this.refcount) && (ex = this.error) != null) {
                s2.onError(ex);
                return;
            }
            s2.onComplete();
        }
    }

    boolean add(MulticastSubscription<T> inner) {
        MulticastSubscription[] b;
        MulticastSubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new MulticastSubscription[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void remove(MulticastSubscription<T> inner) {
        MulticastSubscription<T>[] a;
        int n;
        while ((n = (a = this.subscribers.get()).length) != 0) {
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) return;
            if (n == 1) {
                if (this.refcount) {
                    if (!this.subscribers.compareAndSet(a, TERMINATED)) continue;
                    SubscriptionHelper.cancel(this.upstream);
                    this.once.set(true);
                    return;
                }
                if (!this.subscribers.compareAndSet(a, EMPTY)) continue;
                return;
            }
            MulticastSubscription[] b = new MulticastSubscription[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
            if (this.subscribers.compareAndSet(a, b)) return;
        }
        return;
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        AtomicReference<MulticastSubscription<T>[]> subs = this.subscribers;
        int c = this.consumed;
        int lim = this.limit;
        int fm = this.fusionMode;
        block2: while (true) {
            MulticastSubscription<T>[] as;
            int n;
            SimpleQueue<T> q;
            if ((q = this.queue) != null && (n = (as = subs.get()).length) != 0) {
                MulticastSubscription<T>[] bs;
                long r = -1L;
                for (MulticastSubscription<T> a : as) {
                    long ra = a.get();
                    if (ra < 0L) continue;
                    r = r == -1L ? ra - a.emitted : Math.min(r, ra - a.emitted);
                }
                while (r > 0L) {
                    boolean empty;
                    T v;
                    bs = subs.get();
                    if (bs == TERMINATED) {
                        q.clear();
                        return;
                    }
                    if (as != bs) continue block2;
                    boolean d = this.done;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        SubscriptionHelper.cancel(this.upstream);
                        d = true;
                        v = null;
                        this.error = ex;
                        this.done = true;
                    }
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            for (MulticastSubscription inner : subs.getAndSet(TERMINATED)) {
                                inner.onError(ex);
                            }
                        } else {
                            for (MulticastSubscription inner : subs.getAndSet(TERMINATED)) {
                                inner.onComplete();
                            }
                        }
                        return;
                    }
                    if (empty) break;
                    for (MulticastSubscription<T> inner : as) {
                        inner.onNext(v);
                    }
                    --r;
                    if (fm == 1 || ++c != lim) continue;
                    c = 0;
                    this.upstream.get().request(lim);
                }
                if (r == 0L) {
                    bs = subs.get();
                    if (bs == TERMINATED) {
                        q.clear();
                        return;
                    }
                    if (as != bs) continue;
                    if (this.done && q.isEmpty()) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            for (MulticastSubscription inner : subs.getAndSet(TERMINATED)) {
                                inner.onError(ex);
                            }
                        } else {
                            for (MulticastSubscription inner : subs.getAndSet(TERMINATED)) {
                                inner.onComplete();
                            }
                        }
                        return;
                    }
                }
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
        }
    }

    static final class MulticastSubscription<T>
    extends AtomicLong
    implements Subscription {
        private static final long serialVersionUID = -363282618957264509L;
        final Subscriber<? super T> downstream;
        final MulticastProcessor<T> parent;
        long emitted;

        MulticastSubscription(Subscriber<? super T> actual, MulticastProcessor<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                long r;
                while ((r = this.get()) != Long.MIN_VALUE && r != Long.MAX_VALUE) {
                    long u = r + n;
                    if (u < 0L) {
                        u = Long.MAX_VALUE;
                    }
                    if (!this.compareAndSet(r, u)) continue;
                    this.parent.drain();
                    break;
                }
            }
        }

        @Override
        public void cancel() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
            }
        }

        void onNext(T t) {
            if (this.get() != Long.MIN_VALUE) {
                ++this.emitted;
                this.downstream.onNext(t);
            }
        }

        void onError(Throwable t) {
            if (this.get() != Long.MIN_VALUE) {
                this.downstream.onError(t);
            }
        }

        void onComplete() {
            if (this.get() != Long.MIN_VALUE) {
                this.downstream.onComplete();
            }
        }
    }
}

