/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.UnicastProcessor;
import io.reactivex.subscribers.DisposableSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableWindowBoundary<T, B>
extends AbstractFlowableWithUpstream<T, Flowable<T>> {
    final Publisher<B> other;
    final int capacityHint;

    public FlowableWindowBoundary(Flowable<T> source2, Publisher<B> other, int capacityHint) {
        super(source2);
        this.other = other;
        this.capacityHint = capacityHint;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Flowable<T>> subscriber) {
        WindowBoundaryMainSubscriber parent = new WindowBoundaryMainSubscriber(subscriber, this.capacityHint);
        subscriber.onSubscribe(parent);
        parent.innerNext();
        this.other.subscribe(parent.boundarySubscriber);
        this.source.subscribe(parent);
    }

    static final class WindowBoundaryInnerSubscriber<T, B>
    extends DisposableSubscriber<B> {
        final WindowBoundaryMainSubscriber<T, B> parent;
        boolean done;

        WindowBoundaryInnerSubscriber(WindowBoundaryMainSubscriber<T, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t) {
            if (this.done) {
                return;
            }
            this.parent.innerNext();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.parent.innerError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.innerComplete();
        }
    }

    static final class WindowBoundaryMainSubscriber<T, B>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 2233020065421370272L;
        final Subscriber<? super Flowable<T>> downstream;
        final int capacityHint;
        final WindowBoundaryInnerSubscriber<T, B> boundarySubscriber;
        final AtomicReference<Subscription> upstream;
        final AtomicInteger windows;
        final MpscLinkedQueue<Object> queue;
        final AtomicThrowable errors;
        final AtomicBoolean stopWindows;
        final AtomicLong requested;
        static final Object NEXT_WINDOW = new Object();
        volatile boolean done;
        UnicastProcessor<T> window;
        long emitted;

        WindowBoundaryMainSubscriber(Subscriber<? super Flowable<T>> downstream, int capacityHint) {
            this.downstream = downstream;
            this.capacityHint = capacityHint;
            this.boundarySubscriber = new WindowBoundaryInnerSubscriber(this);
            this.upstream = new AtomicReference();
            this.windows = new AtomicInteger(1);
            this.queue = new MpscLinkedQueue();
            this.errors = new AtomicThrowable();
            this.stopWindows = new AtomicBoolean();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            SubscriptionHelper.setOnce(this.upstream, s2, Long.MAX_VALUE);
        }

        @Override
        public void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.boundarySubscriber.dispose();
            if (this.errors.addThrowable(e)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            this.boundarySubscriber.dispose();
            this.done = true;
            this.drain();
        }

        @Override
        public void cancel() {
            if (this.stopWindows.compareAndSet(false, true)) {
                this.boundarySubscriber.dispose();
                if (this.windows.decrementAndGet() == 0) {
                    SubscriptionHelper.cancel(this.upstream);
                }
            }
        }

        @Override
        public void request(long n) {
            BackpressureHelper.add(this.requested, n);
        }

        @Override
        public void run() {
            if (this.windows.decrementAndGet() == 0) {
                SubscriptionHelper.cancel(this.upstream);
            }
        }

        void innerNext() {
            this.queue.offer(NEXT_WINDOW);
            this.drain();
        }

        void innerError(Throwable e) {
            SubscriptionHelper.cancel(this.upstream);
            if (this.errors.addThrowable(e)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        void innerComplete() {
            SubscriptionHelper.cancel(this.upstream);
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<Flowable<UnicastProcessor<T>>> downstream = this.downstream;
            MpscLinkedQueue<Object> queue = this.queue;
            AtomicThrowable errors = this.errors;
            long emitted = this.emitted;
            while (true) {
                boolean empty;
                if (this.windows.get() == 0) {
                    queue.clear();
                    this.window = null;
                    return;
                }
                UnicastProcessor<Object> w = this.window;
                boolean d = this.done;
                if (d && errors.get() != null) {
                    queue.clear();
                    Throwable ex = errors.terminate();
                    if (w != null) {
                        this.window = null;
                        w.onError(ex);
                    }
                    downstream.onError(ex);
                    return;
                }
                Object v = queue.poll();
                boolean bl = empty = v == null;
                if (d && empty) {
                    Throwable ex = errors.terminate();
                    if (ex == null) {
                        if (w != null) {
                            this.window = null;
                            w.onComplete();
                        }
                        downstream.onComplete();
                    } else {
                        if (w != null) {
                            this.window = null;
                            w.onError(ex);
                        }
                        downstream.onError(ex);
                    }
                    return;
                }
                if (!empty) {
                    if (v != NEXT_WINDOW) {
                        w.onNext(v);
                        continue;
                    }
                    if (w != null) {
                        this.window = null;
                        w.onComplete();
                    }
                    if (this.stopWindows.get()) continue;
                    w = UnicastProcessor.create(this.capacityHint, this);
                    this.window = w;
                    this.windows.getAndIncrement();
                    if (emitted != this.requested.get()) {
                        ++emitted;
                        downstream.onNext(w);
                        continue;
                    }
                    SubscriptionHelper.cancel(this.upstream);
                    this.boundarySubscriber.dispose();
                    errors.addThrowable(new MissingBackpressureException("Could not deliver a window due to lack of requests"));
                    this.done = true;
                    continue;
                }
                this.emitted = emitted;
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

