/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableCount<T>
extends AbstractFlowableWithUpstream<T, Long> {
    public FlowableCount(Flowable<T> source2) {
        super(source2);
    }

    @Override
    protected void subscribeActual(Subscriber<? super Long> s2) {
        this.source.subscribe(new CountSubscriber(s2));
    }

    static final class CountSubscriber
    extends DeferredScalarSubscription<Long>
    implements FlowableSubscriber<Object> {
        private static final long serialVersionUID = 4973004223787171406L;
        Subscription upstream;
        long count;

        CountSubscriber(Subscriber<? super Long> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(Object t) {
            ++this.count;
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.complete(this.count);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

