/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableZip<T, R>
extends Observable<R> {
    final ObservableSource<? extends T>[] sources;
    final Iterable<? extends ObservableSource<? extends T>> sourcesIterable;
    final Function<? super Object[], ? extends R> zipper;
    final int bufferSize;
    final boolean delayError;

    public ObservableZip(ObservableSource<? extends T>[] sources, Iterable<? extends ObservableSource<? extends T>> sourcesIterable, Function<? super Object[], ? extends R> zipper, int bufferSize, boolean delayError) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
        this.zipper = zipper;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super R> observer) {
        ObservableSource<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new Observable[8];
            for (ObservableSource<? extends T> observableSource : this.sourcesIterable) {
                if (count == sources.length) {
                    ObservableSource[] b = new ObservableSource[count + (count >> 2)];
                    System.arraycopy(sources, 0, b, 0, count);
                    sources = b;
                }
                sources[count++] = observableSource;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptyDisposable.complete(observer);
            return;
        }
        ZipCoordinator<? extends T, R> zc = new ZipCoordinator<T, R>(observer, this.zipper, count, this.delayError);
        zc.subscribe(sources, this.bufferSize);
    }

    static final class ZipObserver<T, R>
    implements Observer<T> {
        final ZipCoordinator<T, R> parent;
        final SpscLinkedArrayQueue<T> queue;
        volatile boolean done;
        Throwable error;
        final AtomicReference<Disposable> upstream = new AtomicReference();

        ZipObserver(ZipCoordinator<T, R> parent, int bufferSize) {
            this.parent = parent;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this.upstream, d);
        }

        @Override
        public void onNext(T t) {
            this.queue.offer(t);
            this.parent.drain();
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.parent.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        public void dispose() {
            DisposableHelper.dispose(this.upstream);
        }
    }

    static final class ZipCoordinator<T, R>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = 2983708048395377667L;
        final Observer<? super R> downstream;
        final Function<? super Object[], ? extends R> zipper;
        final ZipObserver<T, R>[] observers;
        final T[] row;
        final boolean delayError;
        volatile boolean cancelled;

        ZipCoordinator(Observer<? super R> actual, Function<? super Object[], ? extends R> zipper, int count, boolean delayError) {
            this.downstream = actual;
            this.zipper = zipper;
            this.observers = new ZipObserver[count];
            this.row = new Object[count];
            this.delayError = delayError;
        }

        public void subscribe(ObservableSource<? extends T>[] sources, int bufferSize) {
            int i;
            ZipObserver<T, R>[] s2 = this.observers;
            int len = s2.length;
            for (i = 0; i < len; ++i) {
                s2[i] = new ZipObserver(this, bufferSize);
            }
            this.lazySet(0);
            this.downstream.onSubscribe(this);
            for (i = 0; i < len; ++i) {
                if (this.cancelled) {
                    return;
                }
                sources[i].subscribe(s2[i]);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelSources();
                if (this.getAndIncrement() == 0) {
                    this.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancel() {
            this.clear();
            this.cancelSources();
        }

        void cancelSources() {
            for (ZipObserver<T, R> zs : this.observers) {
                zs.dispose();
            }
        }

        void clear() {
            for (ZipObserver<T, R> zs : this.observers) {
                zs.queue.clear();
            }
        }

        public void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missing = 1;
            ZipObserver<T, R>[] zs = this.observers;
            Observer<R> a = this.downstream;
            Object[] os = this.row;
            boolean delayError = this.delayError;
            while (true) {
                int i = 0;
                int emptyCount = 0;
                for (ZipObserver<T, R> z : zs) {
                    Throwable ex;
                    if (os[i] == null) {
                        boolean empty;
                        boolean d = z.done;
                        Object v = z.queue.poll();
                        boolean bl = empty = v == null;
                        if (this.checkTerminated(d, empty, a, delayError, z)) {
                            return;
                        }
                        if (!empty) {
                            os[i] = v;
                        } else {
                            ++emptyCount;
                        }
                    } else if (z.done && !delayError && (ex = z.error) != null) {
                        this.cancel();
                        a.onError(ex);
                        return;
                    }
                    ++i;
                }
                if (emptyCount == 0) {
                    R v;
                    try {
                        v = ObjectHelper.requireNonNull(this.zipper.apply((Object[])os.clone()), "The zipper returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.cancel();
                        a.onError(ex);
                        return;
                    }
                    a.onNext(v);
                    Arrays.fill(os, null);
                    continue;
                }
                if ((missing = this.addAndGet(-missing)) == 0) break;
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Observer<? super R> a, boolean delayError, ZipObserver<?, ?> source2) {
            if (this.cancelled) {
                this.cancel();
                return true;
            }
            if (d) {
                if (delayError) {
                    if (empty) {
                        Throwable e = source2.error;
                        this.cancel();
                        if (e != null) {
                            a.onError(e);
                        } else {
                            a.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e = source2.error;
                    if (e != null) {
                        this.cancel();
                        a.onError(e);
                        return true;
                    }
                    if (empty) {
                        this.cancel();
                        a.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

