/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    public static final DateTimeFormatter rfc3339FullDateFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneOffset.UTC);
    public static final DateTimeFormatter rfc3339DateTimeFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX").withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter partialTimeBase = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR_OF_ERA, 4, 19, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2).toFormatter();
    private static final DateTimeFormatter rfc3339BaseParser = new DateTimeFormatterBuilder().append(partialTimeBase).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private static final DateTimeFormatter rfc3339DateTimeParser = new DateTimeFormatterBuilder().append(rfc3339BaseParser).appendOffset("+HH:MM", "Z").toFormatter();
    private static final DateTimeFormatter rfc3339DateTimeNoColonParser = new DateTimeFormatterBuilder().append(rfc3339BaseParser).appendOffset("+HHMM", "Z").toFormatter();
    private static final DateTimeFormatter rfc3339DateTime2DigitTZParser = new DateTimeFormatterBuilder().append(rfc3339BaseParser).appendOffset("+HH", "Z").toFormatter();
    private static final DateTimeFormatter utcDateTimeWithoutTZ = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SSS]").withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter dialogDateTimeParser = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter alchemyDateTimeParser = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss").withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter iamIdentityParser = new DateTimeFormatterBuilder().append(partialTimeBase).appendOffset("+HHMM", "Z").toFormatter();
    private static final List<DateTimeFormatter> dateTimeParsers = Arrays.asList(rfc3339DateTimeParser, rfc3339DateTimeNoColonParser, rfc3339DateTime2DigitTZParser, utcDateTimeWithoutTZ, dialogDateTimeParser, alchemyDateTimeParser, iamIdentityParser);
    private static Pattern isJustNumber = Pattern.compile("^\\d+$");

    private DateUtils() {
    }

    public static String formatAsDate(Date d) {
        return rfc3339FullDateFmt.format(d.toInstant());
    }

    public static String formatAsDateTime(Date d) {
        return rfc3339DateTimeFmt.format(d.toInstant());
    }

    public static Date parseAsDate(String s2) {
        if (s2 == null) {
            return null;
        }
        if (StringUtils.isEmpty(s2 = s2.trim())) {
            return null;
        }
        LocalDate ld = LocalDate.parse(s2.trim());
        Instant instant = Instant.from(ld.atStartOfDay(ZoneId.of("UTC")));
        Date d = Date.from(instant);
        return d;
    }

    public static Date parseAsDateTime(String dateAsString) {
        if (dateAsString == null) {
            return null;
        }
        if (StringUtils.isEmpty(dateAsString = dateAsString.trim())) {
            return null;
        }
        for (DateTimeFormatter formatter : dateTimeParsers) {
            try {
                return DateUtils.parse(dateAsString, formatter);
            }
            catch (Throwable throwable) {
            }
        }
        try {
            return DateUtils.parseAsDate(dateAsString);
        }
        catch (Throwable throwable) {
            Matcher foundMatch = isJustNumber.matcher(dateAsString);
            if (foundMatch.find()) {
                Long timeAsLong = Long.parseLong(dateAsString);
                return new Date(timeAsLong);
            }
            throw new DateTimeException(String.format("Text '%s' could not be parsed as a date-time value.", dateAsString));
        }
    }

    private static Date parse(String s2, DateTimeFormatter formatter) {
        TemporalAccessor ta = formatter.parse(s2);
        return Date.from(Instant.from(ta));
    }
}

