/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Subscription;

public abstract class BasicFuseableConditionalSubscriber<T, R>
implements ConditionalSubscriber<T>,
QueueSubscription<R> {
    protected final ConditionalSubscriber<? super R> downstream;
    protected Subscription upstream;
    protected QueueSubscription<T> qs;
    protected boolean done;
    protected int sourceMode;

    public BasicFuseableConditionalSubscriber(ConditionalSubscriber<? super R> downstream) {
        this.downstream = downstream;
    }

    @Override
    public final void onSubscribe(Subscription s2) {
        if (SubscriptionHelper.validate(this.upstream, s2)) {
            this.upstream = s2;
            if (s2 instanceof QueueSubscription) {
                this.qs = (QueueSubscription)s2;
            }
            if (this.beforeDownstream()) {
                this.downstream.onSubscribe(this);
                this.afterDownstream();
            }
        }
    }

    protected boolean beforeDownstream() {
        return true;
    }

    protected void afterDownstream() {
    }

    @Override
    public void onError(Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.done = true;
        this.downstream.onError(t);
    }

    protected final void fail(Throwable t) {
        Exceptions.throwIfFatal(t);
        this.upstream.cancel();
        this.onError(t);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.downstream.onComplete();
    }

    protected final int transitiveBoundaryFusion(int mode) {
        QueueSubscription<T> qs = this.qs;
        if (qs != null && (mode & 4) == 0) {
            int m3 = qs.requestFusion(mode);
            if (m3 != 0) {
                this.sourceMode = m3;
            }
            return m3;
        }
        return 0;
    }

    @Override
    public void request(long n) {
        this.upstream.request(n);
    }

    @Override
    public void cancel() {
        this.upstream.cancel();
    }

    @Override
    public boolean isEmpty() {
        return this.qs.isEmpty();
    }

    @Override
    public void clear() {
        this.qs.clear();
    }

    @Override
    public final boolean offer(R e) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    @Override
    public final boolean offer(R v1, R v2) {
        throw new UnsupportedOperationException("Should not be called!");
    }
}

