/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

public final class CompletableMerge
extends Completable {
    final Publisher<? extends CompletableSource> source;
    final int maxConcurrency;
    final boolean delayErrors;

    public CompletableMerge(Publisher<? extends CompletableSource> source2, int maxConcurrency, boolean delayErrors) {
        this.source = source2;
        this.maxConcurrency = maxConcurrency;
        this.delayErrors = delayErrors;
    }

    @Override
    public void subscribeActual(CompletableObserver observer) {
        CompletableMergeSubscriber parent = new CompletableMergeSubscriber(observer, this.maxConcurrency, this.delayErrors);
        this.source.subscribe(parent);
    }

    static final class CompletableMergeSubscriber
    extends AtomicInteger
    implements FlowableSubscriber<CompletableSource>,
    Disposable {
        private static final long serialVersionUID = -2108443387387077490L;
        final CompletableObserver downstream;
        final int maxConcurrency;
        final boolean delayErrors;
        final AtomicThrowable error;
        final CompositeDisposable set;
        Subscription upstream;

        CompletableMergeSubscriber(CompletableObserver actual, int maxConcurrency, boolean delayErrors) {
            this.downstream = actual;
            this.maxConcurrency = maxConcurrency;
            this.delayErrors = delayErrors;
            this.set = new CompositeDisposable();
            this.error = new AtomicThrowable();
            this.lazySet(1);
        }

        @Override
        public void dispose() {
            this.upstream.cancel();
            this.set.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.set.isDisposed();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                if (this.maxConcurrency == Integer.MAX_VALUE) {
                    s2.request(Long.MAX_VALUE);
                } else {
                    s2.request(this.maxConcurrency);
                }
            }
        }

        @Override
        public void onNext(CompletableSource t) {
            this.getAndIncrement();
            MergeInnerObserver inner = new MergeInnerObserver();
            this.set.add(inner);
            t.subscribe(inner);
        }

        @Override
        public void onError(Throwable t) {
            if (!this.delayErrors) {
                this.set.dispose();
                if (this.error.addThrowable(t)) {
                    if (this.getAndSet(0) > 0) {
                        this.downstream.onError(this.error.terminate());
                    }
                } else {
                    RxJavaPlugins.onError(t);
                }
            } else if (this.error.addThrowable(t)) {
                if (this.decrementAndGet() == 0) {
                    this.downstream.onError(this.error.terminate());
                }
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (this.decrementAndGet() == 0) {
                Throwable ex = (Throwable)this.error.get();
                if (ex != null) {
                    this.downstream.onError(this.error.terminate());
                } else {
                    this.downstream.onComplete();
                }
            }
        }

        void innerError(MergeInnerObserver inner, Throwable t) {
            this.set.delete(inner);
            if (!this.delayErrors) {
                this.upstream.cancel();
                this.set.dispose();
                if (this.error.addThrowable(t)) {
                    if (this.getAndSet(0) > 0) {
                        this.downstream.onError(this.error.terminate());
                    }
                } else {
                    RxJavaPlugins.onError(t);
                }
            } else if (this.error.addThrowable(t)) {
                if (this.decrementAndGet() == 0) {
                    this.downstream.onError(this.error.terminate());
                } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                    this.upstream.request(1L);
                }
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        void innerComplete(MergeInnerObserver inner) {
            this.set.delete(inner);
            if (this.decrementAndGet() == 0) {
                Throwable ex = (Throwable)this.error.get();
                if (ex != null) {
                    this.downstream.onError(ex);
                } else {
                    this.downstream.onComplete();
                }
            } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                this.upstream.request(1L);
            }
        }

        final class MergeInnerObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver,
        Disposable {
            private static final long serialVersionUID = 251330541679988317L;

            MergeInnerObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onError(Throwable e) {
                CompletableMergeSubscriber.this.innerError(this, e);
            }

            @Override
            public void onComplete() {
                CompletableMergeSubscriber.this.innerComplete(this);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((Disposable)this.get());
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

