/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.security.AbstractToken;
import com.ibm.cloud.sdk.core.security.Cp4dTokenResponse;
import com.ibm.cloud.sdk.core.security.JsonWebToken;
import com.ibm.cloud.sdk.core.util.Clock;
import org.apache.commons.lang3.StringUtils;

public class Cp4dToken
extends AbstractToken {
    private String accessToken;
    private long expirationTime;
    private long refreshTime;

    public Cp4dToken() {
    }

    public Cp4dToken(String accessToken) {
        this.accessToken = accessToken;
        this.expirationTime = -1L;
        this.refreshTime = -1L;
    }

    public Cp4dToken(Throwable t) {
        super(t);
    }

    public Cp4dToken(Cp4dTokenResponse response) {
        this.accessToken = response.getAccessToken();
        JsonWebToken jwt = new JsonWebToken(this.accessToken);
        Long iat = jwt.getPayload().getIssuedAt();
        Long exp = jwt.getPayload().getExpiresAt();
        if (iat == null || exp == null) {
            throw new RuntimeException("Properties 'iat' and 'exp' MUST be present within the encoded access token");
        }
        long ttl = exp - iat;
        this.expirationTime = exp;
        this.refreshTime = iat + (long)(0.8 * (double)ttl);
    }

    @Override
    public synchronized boolean needsRefresh() {
        if (this.getException() != null) {
            return true;
        }
        if (StringUtils.isEmpty(this.accessToken) || this.refreshTime >= 0L && Clock.getCurrentTimeInSeconds() > this.refreshTime) {
            this.refreshTime = Clock.getCurrentTimeInSeconds() + 60L;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTokenValid() {
        return this.getException() == null && this.expirationTime >= 0L && Clock.getCurrentTimeInSeconds() < this.expirationTime;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }
}

