/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.annotations.Nullable;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import org.reactivestreams.Subscriber;

public final class FlowableRangeLong
extends Flowable<Long> {
    final long start;
    final long end;

    public FlowableRangeLong(long start, long count) {
        this.start = start;
        this.end = start + count;
    }

    @Override
    public void subscribeActual(Subscriber<? super Long> s) {
        if (s instanceof ConditionalSubscriber) {
            s.onSubscribe(new RangeConditionalSubscription((ConditionalSubscriber)s, this.start, this.end));
        } else {
            s.onSubscribe(new RangeSubscription(s, this.start, this.end));
        }
    }

    static final class RangeConditionalSubscription
    extends BaseRangeSubscription {
        private static final long serialVersionUID = 2587302975077663557L;
        final ConditionalSubscriber<? super Long> downstream;

        RangeConditionalSubscription(ConditionalSubscriber<? super Long> actual, long index, long end) {
            super(index, end);
            this.downstream = actual;
        }

        @Override
        void fastPath() {
            long f = this.end;
            ConditionalSubscriber<? super Long> a = this.downstream;
            for (long i = this.index; i != f; ++i) {
                if (this.cancelled) {
                    return;
                }
                a.tryOnNext((Long)i);
            }
            if (this.cancelled) {
                return;
            }
            a.onComplete();
        }

        @Override
        void slowPath(long r) {
            long e = 0L;
            long f = this.end;
            long i = this.index;
            ConditionalSubscriber<? super Long> a = this.downstream;
            while (true) {
                if (e != r && i != f) {
                    if (this.cancelled) {
                        return;
                    }
                    if (a.tryOnNext((Long)i)) {
                        ++e;
                    }
                    ++i;
                    continue;
                }
                if (i == f) {
                    if (!this.cancelled) {
                        a.onComplete();
                    }
                    return;
                }
                r = this.get();
                if (e != r) continue;
                this.index = i;
                r = this.addAndGet(-e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }

    static final class RangeSubscription
    extends BaseRangeSubscription {
        private static final long serialVersionUID = 2587302975077663557L;
        final Subscriber<? super Long> downstream;

        RangeSubscription(Subscriber<? super Long> actual, long index, long end) {
            super(index, end);
            this.downstream = actual;
        }

        @Override
        void fastPath() {
            long f = this.end;
            Subscriber<? super Long> a = this.downstream;
            for (long i = this.index; i != f; ++i) {
                if (this.cancelled) {
                    return;
                }
                a.onNext((Long)i);
            }
            if (this.cancelled) {
                return;
            }
            a.onComplete();
        }

        @Override
        void slowPath(long r) {
            long e = 0L;
            long f = this.end;
            long i = this.index;
            Subscriber<? super Long> a = this.downstream;
            while (true) {
                if (e != r && i != f) {
                    if (this.cancelled) {
                        return;
                    }
                    a.onNext((Long)i);
                    ++e;
                    ++i;
                    continue;
                }
                if (i == f) {
                    if (!this.cancelled) {
                        a.onComplete();
                    }
                    return;
                }
                r = this.get();
                if (e != r) continue;
                this.index = i;
                r = this.addAndGet(-e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }

    static abstract class BaseRangeSubscription
    extends BasicQueueSubscription<Long> {
        private static final long serialVersionUID = -2252972430506210021L;
        final long end;
        long index;
        volatile boolean cancelled;

        BaseRangeSubscription(long index, long end) {
            this.index = index;
            this.end = end;
        }

        @Override
        public final int requestFusion(int mode) {
            return mode & 1;
        }

        @Override
        @Nullable
        public final Long poll() {
            long i = this.index;
            if (i == this.end) {
                return null;
            }
            this.index = i + 1L;
            return i;
        }

        @Override
        public final boolean isEmpty() {
            return this.index == this.end;
        }

        @Override
        public final void clear() {
            this.index = this.end;
        }

        @Override
        public final void request(long n) {
            if (SubscriptionHelper.validate(n) && BackpressureHelper.add(this, n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n);
                }
            }
        }

        @Override
        public final void cancel() {
            this.cancelled = true;
        }

        abstract void fastPath();

        abstract void slowPath(long var1);
    }
}

