/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.service.model;

import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.service.model.ObjectModel;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class DynamicModel<T>
implements ObjectModel {
    private TypeToken<T> additionalPropertyTypeToken;
    private Map<String, T> dynamicProperties = new HashMap<String, T>();

    private DynamicModel() {
    }

    public DynamicModel(TypeToken<T> t) {
        this.additionalPropertyTypeToken = t;
    }

    public TypeToken<T> getAdditionalPropertyTypeToken() {
        return this.additionalPropertyTypeToken;
    }

    public T put(String key, T value) {
        return this.dynamicProperties.put(key, value);
    }

    public T get(String key) {
        return this.dynamicProperties.get(key);
    }

    public Map<String, T> getProperties() {
        return new HashMap<String, T>(this.dynamicProperties);
    }

    public Set<String> getPropertyNames() {
        return this.dynamicProperties.keySet();
    }

    public T removeProperty(String key) {
        return this.dynamicProperties.remove(key);
    }

    public void removeProperties() {
        this.dynamicProperties.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicModel other = (DynamicModel)o;
        return this.toString().equals(other.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        return GsonSingleton.getGson().toJson(this);
    }
}

