/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.personality_insights.v3;

import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.AuthenticatorConfig;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.personality_insights.v3.model.Profile;
import com.ibm.watson.personality_insights.v3.model.ProfileOptions;
import java.io.InputStream;
import java.util.Map;

public class PersonalityInsights
extends BaseService {
    private static final String SERVICE_NAME = "personality_insights";
    private static final String URL = "https://gateway.watsonplatform.net/personality-insights/api";
    private String versionDate;

    @Deprecated
    public PersonalityInsights(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        Validator.isTrue(versionDate != null && !versionDate.isEmpty(), "version cannot be null.");
        this.versionDate = versionDate;
    }

    @Deprecated
    public PersonalityInsights(String versionDate, String username, String password) {
        this(versionDate);
        this.setUsernameAndPassword(username, password);
    }

    public PersonalityInsights(String versionDate, AuthenticatorConfig authenticatorConfig) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        this.setAuthenticator(authenticatorConfig);
        Validator.isTrue(versionDate != null && !versionDate.isEmpty(), "version cannot be null.");
        this.versionDate = versionDate;
    }

    public ServiceCall<Profile> profile(ProfileOptions profileOptions) {
        Validator.notNull(profileOptions, "profileOptions cannot be null");
        String[] pathSegments = new String[]{"v3/profile"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(SERVICE_NAME, "v3", "profile");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (profileOptions.contentLanguage() != null) {
            builder.header("Content-Language", profileOptions.contentLanguage());
        }
        if (profileOptions.acceptLanguage() != null) {
            builder.header("Accept-Language", profileOptions.acceptLanguage());
        }
        if (profileOptions.contentType() != null) {
            builder.header("Content-Type", profileOptions.contentType());
        }
        if (profileOptions.rawScores() != null) {
            builder.query("raw_scores", String.valueOf(profileOptions.rawScores()));
        }
        if (profileOptions.csvHeaders() != null) {
            builder.query("csv_headers", String.valueOf(profileOptions.csvHeaders()));
        }
        if (profileOptions.consumptionPreferences() != null) {
            builder.query("consumption_preferences", String.valueOf(profileOptions.consumptionPreferences()));
        }
        builder.bodyContent(profileOptions.contentType(), (Object)profileOptions.content(), null, profileOptions.body());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Profile>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> profileAsCsv(ProfileOptions profileOptions) {
        Validator.notNull(profileOptions, "profileOptions cannot be null");
        String[] pathSegments = new String[]{"v3/profile"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(SERVICE_NAME, "v3", "profileAsCsv");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "text/csv");
        if (profileOptions.contentLanguage() != null) {
            builder.header("Content-Language", profileOptions.contentLanguage());
        }
        if (profileOptions.acceptLanguage() != null) {
            builder.header("Accept-Language", profileOptions.acceptLanguage());
        }
        if (profileOptions.contentType() != null) {
            builder.header("Content-Type", profileOptions.contentType());
        }
        if (profileOptions.rawScores() != null) {
            builder.query("raw_scores", String.valueOf(profileOptions.rawScores()));
        }
        if (profileOptions.csvHeaders() != null) {
            builder.query("csv_headers", String.valueOf(profileOptions.csvHeaders()));
        }
        if (profileOptions.consumptionPreferences() != null) {
            builder.query("consumption_preferences", String.valueOf(profileOptions.consumptionPreferences()));
        }
        builder.bodyContent(profileOptions.contentType(), (Object)profileOptions.content(), null, profileOptions.body());
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

