/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.service.security;

import com.google.common.io.BaseEncoding;
import com.ibm.cloud.sdk.core.http.HttpClientSingleton;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;
import com.ibm.cloud.sdk.core.service.security.IamOptions;
import com.ibm.cloud.sdk.core.service.security.IamToken;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import java.io.IOException;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.Request;
import okhttp3.Response;

public class IamTokenManager
implements Authenticator {
    private String userManagedAccessToken;
    private String apiKey;
    private String url;
    private String clientId;
    private String clientSecret;
    private boolean disableSSLVerification;
    private IamToken tokenData;
    private static final Logger LOG = Logger.getLogger(IamTokenManager.class.getName());
    private static final String ERROR_MESSAGE = "Error getting IAM token from API";
    private static final String DEFAULT_AUTHORIZATION = "Basic Yng6Yng=";
    private static final String DEFAULT_IAM_URL = "https://iam.cloud.ibm.com/identity/token";
    private static final String GRANT_TYPE = "grant_type";
    private static final String REQUEST_GRANT_TYPE = "urn:ibm:params:oauth:grant-type:apikey";
    private static final String API_KEY = "apikey";
    private static final String RESPONSE_TYPE = "response_type";
    private static final String CLOUD_IAM = "cloud_iam";

    public IamTokenManager(IamOptions options) {
        if (options.getApiKey() != null) {
            if (CredentialUtils.hasBadStartOrEndChar(options.getApiKey())) {
                throw new IllegalArgumentException("The IAM API key shouldn't start or end with curly brackets or quotes. Please remove any surrounding {, }, or \" characters.");
            }
            this.apiKey = options.getApiKey();
        }
        this.url = options.getUrl() != null ? options.getUrl() : DEFAULT_IAM_URL;
        this.userManagedAccessToken = options.getAccessToken();
        this.clientId = options.getClientId();
        this.clientSecret = options.getClientSecret();
        this.tokenData = new IamToken();
    }

    @Override
    public String authenticationType() {
        return "iam";
    }

    @Override
    public void authenticate(Request.Builder builder) {
        builder.addHeader("Authorization", "Bearer " + this.getToken());
    }

    public String getToken() {
        String token = this.userManagedAccessToken != null ? this.userManagedAccessToken : (this.tokenData.getAccessToken() == null || this.isAccessTokenExpired() ? this.requestToken() : this.tokenData.getAccessToken());
        return token;
    }

    private String requestToken() {
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.url, new String[0]));
        builder.header("Content-Type", "application/x-www-form-urlencoded");
        builder.header("Authorization", this.getAuthorizationHeaderValue());
        FormBody formBody = new FormBody.Builder().add(GRANT_TYPE, REQUEST_GRANT_TYPE).add(API_KEY, this.apiKey).add(RESPONSE_TYPE, CLOUD_IAM).build();
        builder.body(formBody);
        this.tokenData = this.callIamApi(builder.build());
        return this.tokenData.getAccessToken();
    }

    private boolean isAccessTokenExpired() {
        if (this.tokenData.getExpiresIn() == null || this.tokenData.getExpiration() == null) {
            return true;
        }
        Double fractionOfTimeToLive = 0.8;
        Long timeToLive = this.tokenData.getExpiresIn();
        Long expirationTime = this.tokenData.getExpiration();
        Double refreshTime = (double)expirationTime.longValue() - (double)timeToLive.longValue() * (1.0 - fractionOfTimeToLive);
        Double currentTime = Math.floor(System.currentTimeMillis() / 1000L);
        return refreshTime < currentTime;
    }

    private IamToken callIamApi(final Request request) {
        final IamToken[] returnToken = new IamToken[1];
        Thread iamApiCall = new Thread(new Runnable(){

            @Override
            public void run() {
                Call call = HttpClientSingleton.getInstance().createHttpClient().newCall(request);
                ResponseConverter<IamToken> converter = ResponseConverterUtils.getObject(IamToken.class);
                try {
                    Response response = call.execute();
                    if (response.code() >= 400) {
                        throw new ServiceResponseException(response.code(), response);
                    }
                    returnToken[0] = converter.convert(response);
                }
                catch (IOException e) {
                    LOG.severe(IamTokenManager.ERROR_MESSAGE);
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        });
        iamApiCall.start();
        try {
            iamApiCall.join();
        }
        catch (InterruptedException e) {
            LOG.severe(ERROR_MESSAGE);
            e.printStackTrace();
        }
        return returnToken[0];
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setDisableSSLVerification(boolean disableSSLVerification) {
        this.disableSSLVerification = disableSSLVerification;
    }

    public String getAuthorizationHeaderValue() {
        String result;
        if (this.getClientId() != null && this.getClientSecret() != null) {
            String s = this.getClientId() + ":" + this.getClientSecret();
            result = "Basic " + BaseEncoding.base64().encode(s.getBytes());
        } else {
            result = DEFAULT_AUTHORIZATION;
        }
        return result;
    }
}

