/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security.icp4d;

import com.ibm.cloud.sdk.core.security.icp4d.ICP4DTokenResponse;
import com.ibm.cloud.sdk.core.security.jwt.JsonWebToken;
import org.apache.commons.lang3.StringUtils;

public class ICP4DToken {
    public String accessToken;
    public long expirationTimeInMillis;

    public ICP4DToken(String accessToken) {
        this.accessToken = accessToken;
        this.expirationTimeInMillis = -1L;
    }

    public ICP4DToken(ICP4DTokenResponse response) {
        this.accessToken = response.getAccessToken();
        JsonWebToken jwt = new JsonWebToken(this.accessToken);
        Long iat = jwt.getPayload().getIssuedAt();
        Long exp = jwt.getPayload().getExpiresAt();
        if (iat == null || exp == null) {
            throw new RuntimeException("Properties 'iat' and 'exp' MUST be present within the encoded access token");
        }
        long ttl = exp - iat;
        this.expirationTimeInMillis = (iat + (long)(0.8 * (double)ttl)) * 1000L;
    }

    public boolean isTokenValid() {
        return StringUtils.isNotEmpty(this.accessToken) && (this.expirationTimeInMillis < 0L || System.currentTimeMillis() <= this.expirationTimeInMillis);
    }
}

