/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ibm.cloud.sdk.core.util.DateDeserializer;
import com.ibm.cloud.sdk.core.util.DateSerializer;
import java.lang.reflect.Type;
import java.util.Date;

public final class GsonSingleton {
    private static Gson gson;
    private static Gson gsonWithoutPrinting;

    private GsonSingleton() {
    }

    private static Gson createGson(Boolean prettyPrint) {
        GsonBuilder builder = new GsonBuilder();
        GsonSingleton.registerTypeAdapters(builder);
        if (prettyPrint.booleanValue()) {
            builder.setPrettyPrinting();
        }
        builder.disableHtmlEscaping();
        return builder.create();
    }

    private static void registerTypeAdapters(GsonBuilder builder) {
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateDeserializer());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateSerializer());
    }

    public static synchronized Gson getGson() {
        if (gson == null) {
            gson = GsonSingleton.createGson(true);
        }
        return gson;
    }

    public static synchronized Gson getGsonWithoutPrettyPrinting() {
        if (gsonWithoutPrinting == null) {
            gsonWithoutPrinting = GsonSingleton.createGson(false);
        }
        return gsonWithoutPrinting;
    }
}

