/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.spring.boot;

import com.ibm.watson.developer_cloud.spring.boot.ConditionalOnWatsonServiceProperties;
import java.util.Map;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class WatsonServiceCondition
implements Condition {
    public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata metadata) {
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnWatsonServiceProperties.class.getName());
        String prefix = (String)attributes.get("prefix");
        if (Boolean.valueOf(conditionContext.getEnvironment().getProperty(prefix + ".enabled")).booleanValue()) {
            return true;
        }
        String url = conditionContext.getEnvironment().getProperty(prefix + ".url");
        String username = conditionContext.getEnvironment().getProperty(prefix + ".username");
        String password = conditionContext.getEnvironment().getProperty(prefix + ".password");
        String apiKey = conditionContext.getEnvironment().getProperty(prefix + ".apiKey");
        String iamApiKey = conditionContext.getEnvironment().getProperty(prefix + ".iamApiKey");
        String versionDate = conditionContext.getEnvironment().getProperty(prefix + ".versionDate");
        return url != null || username != null || password != null || versionDate != null || apiKey != null || iamApiKey != null;
    }
}

